/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.client.helper;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.common.util.ExecutorWrapperService;
import org.somda.sdc.common.util.JaxbUtil;
import org.somda.sdc.dpws.CommunicationLog;
import org.somda.sdc.dpws.CommunicationLogContext;
import org.somda.sdc.dpws.TransportBinding;
import org.somda.sdc.dpws.client.DiscoveredDevice;
import org.somda.sdc.dpws.client.exception.EprAddressMismatchException;
import org.somda.sdc.dpws.factory.CommunicationLogFactory;
import org.somda.sdc.dpws.factory.TransportBindingFactory;
import org.somda.sdc.dpws.guice.ResolverThreadPool;
import org.somda.sdc.dpws.http.HttpUriBuilder;
import org.somda.sdc.dpws.model.HostServiceType;
import org.somda.sdc.dpws.model.HostedServiceType;
import org.somda.sdc.dpws.model.Relationship;
import org.somda.sdc.dpws.model.ThisDeviceType;
import org.somda.sdc.dpws.model.ThisModelType;
import org.somda.sdc.dpws.network.LocalAddressResolver;
import org.somda.sdc.dpws.service.HostedServiceProxy;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.dpws.service.factory.HostedServiceFactory;
import org.somda.sdc.dpws.service.factory.HostingServiceFactory;
import org.somda.sdc.dpws.soap.RequestResponseClient;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.exception.MalformedSoapMessageException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.factory.RequestResponseClientFactory;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wseventing.EventSink;
import org.somda.sdc.dpws.soap.wseventing.factory.WsEventingEventSinkFactory;
import org.somda.sdc.dpws.soap.wsmetadataexchange.GetMetadataClient;
import org.somda.sdc.dpws.soap.wsmetadataexchange.model.Metadata;
import org.somda.sdc.dpws.soap.wsmetadataexchange.model.MetadataSection;
import org.somda.sdc.dpws.soap.wstransfer.TransferGetClient;

public class HostingServiceResolver {
    private static final Logger LOG = LogManager.getLogger(HostingServiceResolver.class);
    private final ExecutorWrapperService<ListeningExecutorService> resolveExecutor;
    private final LocalAddressResolver localAddressResolver;
    private final TransportBindingFactory transportBindingFactory;
    private final RequestResponseClientFactory requestResponseClientFactory;
    private final TransferGetClient transferGetClient;
    private final JaxbUtil jaxbUtil;
    private final SoapUtil soapUtil;
    private final WsAddressingUtil wsaUtil;
    private final HostingServiceFactory hostingServiceFactory;
    private final HostedServiceFactory hostedServiceFactory;
    private final WsEventingEventSinkFactory eventSinkFactory;
    private final HttpUriBuilder uriBuilder;
    private final GetMetadataClient getMetadataClient;
    private final Duration maxWaitForFutures;
    private final CommunicationLogFactory communicationLogFactory;
    private final Logger instanceLogger;

    @Inject
    HostingServiceResolver(@Named(value="Dpws.MaxWaitForFutures") Duration maxWaitForFutures, @ResolverThreadPool ExecutorWrapperService<ListeningExecutorService> resolveExecutor, LocalAddressResolver localAddressResolver, TransportBindingFactory transportBindingFactory, RequestResponseClientFactory requestResponseClientFactory, TransferGetClient transferGetClient, GetMetadataClient getMetadataClient, JaxbUtil jaxbUtil, SoapUtil soapUtil, WsAddressingUtil wsaUtil, HostingServiceFactory hostingServiceFactory, HostedServiceFactory hostedServiceFactory, WsEventingEventSinkFactory eventSinkFactory, HttpUriBuilder uriBuilder, CommunicationLogFactory communicationLogFactory, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.communicationLogFactory = communicationLogFactory;
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.maxWaitForFutures = maxWaitForFutures;
        this.resolveExecutor = resolveExecutor;
        this.localAddressResolver = localAddressResolver;
        this.transportBindingFactory = transportBindingFactory;
        this.requestResponseClientFactory = requestResponseClientFactory;
        this.transferGetClient = transferGetClient;
        this.getMetadataClient = getMetadataClient;
        this.jaxbUtil = jaxbUtil;
        this.soapUtil = soapUtil;
        this.wsaUtil = wsaUtil;
        this.hostingServiceFactory = hostingServiceFactory;
        this.hostedServiceFactory = hostedServiceFactory;
        this.eventSinkFactory = eventSinkFactory;
        this.uriBuilder = uriBuilder;
    }

    public ListenableFuture<HostingServiceProxy> resolveHostingService(DiscoveredDevice discoveredDevice) {
        return ((ListeningExecutorService)this.resolveExecutor.get()).submit(() -> {
            if (discoveredDevice.getXAddrs().isEmpty()) {
                throw new IllegalArgumentException("Given device proxy has no XAddrs. Connection aborted.");
            }
            RequestResponseClient rrClient = null;
            SoapMessage transferGetResponse = null;
            String activeXAddr = null;
            ListenableFuture<SoapMessage> transferGetResponseFuture = null;
            for (String xAddr : discoveredDevice.getXAddrs()) {
                try {
                    activeXAddr = xAddr;
                    CommunicationLog commLog = this.communicationLogFactory.createCommunicationLog(new CommunicationLogContext(discoveredDevice.getEprAddress()));
                    rrClient = this.createRequestResponseClient(activeXAddr, commLog);
                    transferGetResponseFuture = this.transferGetClient.sendTransferGet(rrClient, xAddr);
                    transferGetResponse = (SoapMessage)transferGetResponseFuture.get(this.maxWaitForFutures.toMillis(), TimeUnit.MILLISECONDS);
                    break;
                }
                catch (TimeoutException e) {
                    this.instanceLogger.debug("TransferGet to {} failed after {}s", (Object)xAddr, (Object)this.maxWaitForFutures.toSeconds(), (Object)e);
                    if (transferGetResponseFuture == null) continue;
                    transferGetResponseFuture.cancel(true);
                }
                catch (InterruptedException | CancellationException | ExecutionException e) {
                    this.instanceLogger.debug("TransferGet to {} failed", (Object)xAddr, (Object)e);
                }
            }
            if (transferGetResponse == null) {
                throw new TransportException(String.format("None of the %s XAddr URL(s) responded with a valid TransferGet response", discoveredDevice.getXAddrs().size()));
            }
            Metadata deviceMetadata = this.soapUtil.getBody(transferGetResponse, Metadata.class).orElseThrow(() -> new MalformedSoapMessageException("Could not get metadata element from TransferGet response"));
            if (deviceMetadata.getMetadataSection().isEmpty()) {
                throw new MalformedSoapMessageException("No metadata sections in TransferGet response");
            }
            String deviceEprAddress = discoveredDevice.getEprAddress();
            long metadataVersion = discoveredDevice.getMetadataVersion();
            return this.extractHostingServiceProxy(deviceMetadata, rrClient, deviceEprAddress, metadataVersion, activeXAddr).orElseThrow(() -> new MalformedSoapMessageException(String.format("Could not resolve hosting service proxy information for %s", deviceEprAddress)));
        });
    }

    private Optional<HostingServiceProxy> extractHostingServiceProxy(Metadata deviceMetadata, RequestResponseClient rrClient, String eprAddress, long metadataVersion, String xAddr) {
        RelationshipData rsDataFromOptional;
        String epr;
        Optional thisDevice = Optional.empty();
        Optional thisModel = Optional.empty();
        Optional<Object> relationshipData = Optional.empty();
        for (Object potentialMetadataSection : deviceMetadata.getMetadataSection()) {
            MetadataSection metadataSection = this.jaxbUtil.extractElement(potentialMetadataSection, MetadataSection.class).orElse(null);
            if (metadataSection == null) continue;
            String dialect = metadataSection.getDialect();
            if (dialect.equals("http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01/ThisDevice")) {
                try {
                    thisDevice = this.jaxbUtil.extractElement(metadataSection.getAny(), ThisDeviceType.class);
                }
                catch (Exception e) {
                    this.instanceLogger.info("Resolve dpws:ThisDevice from {} failed", (Object)eprAddress);
                }
                continue;
            }
            if (dialect.equals("http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01/ThisModel")) {
                try {
                    thisModel = this.jaxbUtil.extractElement(metadataSection.getAny(), ThisModelType.class);
                }
                catch (Exception e) {
                    this.instanceLogger.info("Resolve dpws:ThisModel from {} failed", (Object)eprAddress);
                }
                continue;
            }
            if (!dialect.equals("http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01/Relationship")) continue;
            try {
                Relationship rs = (Relationship)this.jaxbUtil.extractElement(metadataSection.getAny(), Relationship.class).orElseThrow(Exception::new);
                if (!rs.getType().equals("http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01/host")) {
                    this.instanceLogger.debug("Incompatible dpws:Relationship type found for {}: {}", (Object)eprAddress, (Object)rs.getType());
                    continue;
                }
                relationshipData = this.extractRelationshipData(rs, eprAddress);
            }
            catch (Exception e) {
                this.instanceLogger.info("Resolve dpws:Relationship from {} failed", (Object)eprAddress);
            }
        }
        if (thisDevice.isEmpty()) {
            this.instanceLogger.info("No dpws:ThisDevice found for {}", (Object)eprAddress);
        }
        if (thisModel.isEmpty()) {
            this.instanceLogger.info("No dpws:ThisModel found for {}", (Object)eprAddress);
        }
        if (!(epr = (rsDataFromOptional = (RelationshipData)relationshipData.orElseThrow(() -> new MalformedSoapMessageException(String.format("No dpws:Relationship found for %s, but required", eprAddress)))).getEprAddress().orElseThrow(() -> new MalformedSoapMessageException(String.format("Malformed relationship data. Missing expected EPR: %s", eprAddress)))).equals(eprAddress)) {
            throw new EprAddressMismatchException(String.format("Expected EPR address '%s', but received '%s'", eprAddress, epr));
        }
        return Optional.of(this.hostingServiceFactory.createHostingServiceProxy(epr, rsDataFromOptional.getTypes(), thisDevice.orElse(null), thisModel.orElse(null), rsDataFromOptional.getHostedServices(), metadataVersion, rrClient, xAddr));
    }

    private Optional<RelationshipData> extractRelationshipData(Relationship relationship, String eprAddress) {
        RelationshipData result = new RelationshipData();
        for (Object potentialRelationship : relationship.getAny()) {
            this.jaxbUtil.extractElement(potentialRelationship, HostServiceType.class).ifPresent(host -> {
                result.setEprAddress(this.wsaUtil.getAddressUri(host.getEndpointReference()).orElse(null));
                result.setTypes(host.getTypes());
            });
            this.jaxbUtil.extractElement(potentialRelationship, HostedServiceType.class).ifPresent(hsType -> this.extractHostedServiceProxy((HostedServiceType)hsType, eprAddress).ifPresent(hsProxy -> result.getHostedServices().put(hsProxy.getType().getServiceId(), (HostedServiceProxy)hsProxy)));
        }
        if (result.getEprAddress().isEmpty()) {
            this.instanceLogger.info("Found no valid dpws:Host for {}", (Object)eprAddress);
            return Optional.empty();
        }
        if (result.getHostedServices().isEmpty()) {
            this.instanceLogger.info("Found no dpws:Hosted for {}", (Object)eprAddress);
        }
        return Optional.of(result);
    }

    private Optional<HostedServiceProxy> extractHostedServiceProxy(HostedServiceType host, String endpointAddress) {
        String activeHostedServiceEprAddress = null;
        RequestResponseClient rrClient = null;
        SoapMessage getMetadataResponse = null;
        CommunicationLog commLog = this.communicationLogFactory.createCommunicationLog(new CommunicationLogContext(endpointAddress));
        for (EndpointReferenceType eprType : host.getEndpointReference()) {
            ListenableFuture<SoapMessage> getMetadataResponseFuture = null;
            try {
                activeHostedServiceEprAddress = eprType.getAddress().getValue();
                rrClient = this.createRequestResponseClient(activeHostedServiceEprAddress, commLog);
                getMetadataResponseFuture = this.getMetadataClient.sendGetMetadata(rrClient);
                getMetadataResponse = (SoapMessage)getMetadataResponseFuture.get(this.maxWaitForFutures.toMillis(), TimeUnit.MILLISECONDS);
                break;
            }
            catch (InterruptedException | CancellationException | ExecutionException | TimeoutException e) {
                this.instanceLogger.info("GetMetadata to {} failed", (Object)eprType.getAddress().getValue(), (Object)e);
                if (getMetadataResponseFuture == null) continue;
                getMetadataResponseFuture.cancel(true);
            }
        }
        if (getMetadataResponse == null) {
            this.instanceLogger.info("None of the {} hosted service EPR addresses responded with a valid GetMetadata response", (Object)host.getEndpointReference().size());
            return Optional.empty();
        }
        Optional<String> localAddress = this.localAddressResolver.getLocalAddress(activeHostedServiceEprAddress);
        if (localAddress.isEmpty()) {
            return Optional.empty();
        }
        String httpBinding = this.uriBuilder.buildUri(URI.create(activeHostedServiceEprAddress).getScheme(), localAddress.get(), 0);
        EventSink eventSink = this.eventSinkFactory.createWsEventingEventSink(rrClient, httpBinding, commLog);
        return Optional.of(this.hostedServiceFactory.createHostedServiceProxy(host, rrClient, activeHostedServiceEprAddress, eventSink));
    }

    private RequestResponseClient createRequestResponseClient(String xAddr, CommunicationLog communicationLog) {
        TransportBinding tBinding = this.transportBindingFactory.createTransportBinding(xAddr, communicationLog);
        return this.requestResponseClientFactory.createRequestResponseClient(tBinding);
    }

    private static class RelationshipData {
        private String eprAddress = null;
        private List<QName> types = null;
        private final Map<String, HostedServiceProxy> hostedServices = new HashMap<String, HostedServiceProxy>();

        private RelationshipData() {
        }

        Optional<String> getEprAddress() {
            return Optional.ofNullable(this.eprAddress);
        }

        void setEprAddress(@Nullable String eprAddress) {
            this.eprAddress = eprAddress;
        }

        List<QName> getTypes() {
            return this.types == null ? Collections.emptyList() : this.types;
        }

        void setTypes(@Nullable List<QName> types) {
            this.types = types;
        }

        Map<String, HostedServiceProxy> getHostedServices() {
            return this.hostedServices;
        }
    }
}

