/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.device.helper;

import com.google.common.collect.ListMultimap;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.http.ContentType;
import org.somda.sdc.dpws.http.HttpException;
import org.somda.sdc.dpws.http.HttpHandler;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.HttpApplicationInfo;
import org.somda.sdc.dpws.soap.MarshallingService;
import org.somda.sdc.dpws.soap.RequestResponseServer;
import org.somda.sdc.dpws.soap.SoapDebug;
import org.somda.sdc.dpws.soap.SoapFaultHttpStatusCodeMapping;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.InterceptorHandler;

public class RequestResponseServerHttpHandler
implements HttpHandler,
InterceptorHandler {
    static final String NO_CONTENT_TYPE_MESSAGE = "Could not parse Content-Type header element";
    private static final Logger LOG = LogManager.getLogger(RequestResponseServerHttpHandler.class);
    private final RequestResponseServer reqResServer;
    private final MarshallingService marshallingService;
    private final SoapUtil soapUtil;
    private final Logger instanceLogger;

    @Inject
    RequestResponseServerHttpHandler(RequestResponseServer reqResServer, MarshallingService marshallingService, SoapUtil soapUtil, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.reqResServer = reqResServer;
        this.marshallingService = marshallingService;
        this.soapUtil = soapUtil;
    }

    @Override
    public void handle(InputStream inStream, OutputStream outStream, CommunicationContext communicationContext) throws HttpException {
        SoapMessage requestMsg;
        ListMultimap<String, String> headers;
        try {
            headers = ((HttpApplicationInfo)communicationContext.getApplicationInfo()).getHeaders();
        }
        catch (ClassCastException e) {
            String errorText = "Unexpected ApplicationInfo received, expected HttpApplicationInfo.";
            this.instanceLogger.error(errorText);
            throw new HttpException(500, errorText);
        }
        Optional<ContentType> contentTypeOpt = ContentType.fromListMultimap(headers);
        if (contentTypeOpt.isEmpty()) {
            throw new HttpException(400, NO_CONTENT_TYPE_MESSAGE);
        }
        ContentType contentType = contentTypeOpt.get();
        try {
            if (contentType.getCharset() != null) {
                InputStreamReader reader = new InputStreamReader(inStream, contentType.getCharset());
                requestMsg = this.marshallingService.unmarshal(reader);
            } else {
                requestMsg = this.marshallingService.unmarshal(inStream);
            }
        }
        catch (MarshallingException e) {
            throw new HttpException(400, String.format("Error unmarshalling HTTP input stream: %s", e.getMessage()));
        }
        this.instanceLogger.debug("Incoming SOAP/HTTP request: {}", new Supplier[]{() -> SoapDebug.get(requestMsg)});
        SoapMessage responseMsg = this.soapUtil.createMessage();
        HttpException httpExceptionToThrow = null;
        try {
            this.reqResServer.receiveRequestResponse(requestMsg, responseMsg, communicationContext);
        }
        catch (SoapFaultException e) {
            responseMsg = e.getFaultMessage();
            this.instanceLogger.warn("{}: Processing message triggered soap fault: {}", (Object)communicationContext.getTransportInfo().getRemoteNodeInfo(), (Object)e.getMessage());
            this.instanceLogger.trace("Processing message triggered soap fault", (Throwable)e);
            httpExceptionToThrow = new HttpException(SoapFaultHttpStatusCodeMapping.get(e.getFault()));
        }
        try {
            this.marshallingService.marshal(responseMsg, outStream);
        }
        catch (MarshallingException e) {
            throw new HttpException(500, String.format("Error marshalling HTTP output stream: %s", e.getMessage()));
        }
        if (this.instanceLogger.isDebugEnabled()) {
            this.instanceLogger.debug("Outgoing SOAP/HTTP response: {}", (Object)SoapDebug.get(responseMsg));
        }
        if (httpExceptionToThrow != null) {
            throw httpExceptionToThrow;
        }
    }

    @Override
    public void register(Interceptor interceptor) {
        this.reqResServer.register(interceptor);
    }
}

