/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.helper;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingConstants;

class CommunicationLogSoapXmlUtils {
    private static final String EMPTY_XML = "[empty]";
    private static final String ACTION_UNKNOWN = "[unknown]";

    CommunicationLogSoapXmlUtils() {
    }

    String makeNameElement(byte[] xmlDocument) {
        return this.moreReadable(this.findAction(xmlDocument));
    }

    String findAction(byte[] xmlDocument) {
        if (xmlDocument.length == 0) {
            return EMPTY_XML;
        }
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            XMLStreamReader parser = factory.createXMLStreamReader(new ByteArrayInputStream(xmlDocument));
            QName actionElement = null;
            while (parser.hasNext()) {
                switch (parser.getEventType()) {
                    case 8: {
                        parser.close();
                        return "";
                    }
                    case 1: {
                        actionElement = new QName(parser.getNamespaceURI(), parser.getLocalName());
                        break;
                    }
                    case 4: {
                        if (!WsAddressingConstants.ACTION.equals(actionElement) || parser.isWhiteSpace()) break;
                        return parser.getText();
                    }
                }
                parser.next();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        return ACTION_UNKNOWN;
    }

    String moreReadable(String action) {
        switch (action) {
            case "[unknown]": 
            case "[empty]": {
                return action;
            }
            case "http://schemas.xmlsoap.org/ws/2004/08/eventing/Subscribe": {
                return "WseSubscribe";
            }
            case "http://schemas.xmlsoap.org/ws/2004/08/eventing/SubscribeResponse": {
                return "WseSubscribeResponse";
            }
            case "http://schemas.xmlsoap.org/ws/2004/08/eventing/Renew": {
                return "WseRenew";
            }
            case "http://schemas.xmlsoap.org/ws/2004/08/eventing/RenewResponse": {
                return "WseRenewResponse";
            }
            case "http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatus": {
                return "WseGetStatus";
            }
            case "http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatusResponse": {
                return "WseGetStatusResponse";
            }
            case "http://schemas.xmlsoap.org/ws/2004/08/eventing/Unsubscribe": {
                return "WseUnsubscribe";
            }
            case "http://schemas.xmlsoap.org/ws/2004/08/eventing/UnsubscribeResponse": {
                return "WseUnsubscribeResponse";
            }
            case "http://schemas.xmlsoap.org/ws/2004/08/eventing/SubscriptionEnd": {
                return "WseSubscriptionEnd";
            }
            case "http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata/Request": {
                return "MexRequest";
            }
            case "http://schemas.xmlsoap.org/ws/2004/09/mex/GetMetadata/Response": {
                return "MexResponse";
            }
            case "http://schemas.xmlsoap.org/ws/2004/09/transfer/Get": {
                return "WstGet";
            }
            case "http://schemas.xmlsoap.org/ws/2004/09/transfer/GetResponse": {
                return "WstGetResponse";
            }
            case "http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Probe": {
                return "WsdProbe";
            }
            case "http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/ProbeMatches": {
                return "WsdProbeMatches";
            }
            case "http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Resolve": {
                return "WsdResolve";
            }
            case "http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/ResolveMatches": {
                return "WsdResolveMatches";
            }
            case "http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Hello": {
                return "WsdHello";
            }
            case "http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Bye": {
                return "WsdBye";
            }
        }
        int indexLastSlash = action.lastIndexOf(47);
        if (indexLastSlash != -1) {
            return action.substring(indexLastSlash + 1);
        }
        return action;
    }

    byte[] prettyPrint(byte[] unformattedXml) {
        if (unformattedXml.length == 0) {
            return unformattedXml;
        }
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 4);
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            StreamResult xmlOutput = new StreamResult(output);
            StreamSource xmlInput = new StreamSource(new ByteArrayInputStream(unformattedXml));
            transformer.transform(xmlInput, xmlOutput);
            return output.toByteArray();
        }
        catch (Exception e) {
            return unformattedXml;
        }
    }
}

