/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.http;

import com.google.common.collect.ListMultimap;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.util.ObjectStringifier;
import org.somda.sdc.common.util.Stringified;

public class ContentType {
    private static final Logger LOG = LogManager.getLogger();
    private static final String CHARSET = "charset";
    private static final String BOUNDARY = "boundary";
    @Stringified
    private final ContentTypes contentType;
    @Stringified
    private final Charset charset;
    @Stringified
    private final String boundary;

    ContentType(ContentTypes contentType, @Nullable Charset charset, @Nullable String boundary) {
        this.contentType = contentType;
        this.boundary = boundary;
        this.charset = charset == null ? contentType.defaultEncoding : charset;
    }

    private static Optional<Charset> parseCharset(@Nullable String charset) {
        if (charset != null && !charset.isBlank()) {
            try {
                return Optional.of(Charset.forName(charset));
            }
            catch (UnsupportedCharsetException ex) {
                LOG.debug("Could not parse unknown charset {}", (Object)charset);
            }
        }
        return Optional.empty();
    }

    public static Optional<ContentType> fromListMultimap(ListMultimap<String, String> headers) {
        List contentTypeList = headers.get((Object)"Content-Type".toLowerCase());
        if (contentTypeList.size() != 1) {
            return Optional.empty();
        }
        String contentTypeEntry = (String)contentTypeList.get(0);
        String[] elements = contentTypeEntry.split(";");
        Optional<ContentTypes> contentTypeOpt = ContentTypes.fromMime(elements[0]);
        if (contentTypeOpt.isEmpty()) {
            return Optional.empty();
        }
        ContentTypes contentType = contentTypeOpt.get();
        Charset charset = null;
        String boundary = null;
        if (elements.length > 1) {
            for (int i = 1; i < elements.length; ++i) {
                String element = elements[i];
                String[] parts = element.strip().split("=");
                assert (parts.length == 2);
                String key = parts[0];
                String value = parts[1];
                if (CHARSET.equalsIgnoreCase(key)) {
                    Optional<Charset> parsedCharset = ContentType.parseCharset(value);
                    if (parsedCharset.isEmpty()) {
                        LOG.error("Unknown charset provided with content type {}. Charset: {}", (Object)contentType, (Object)value);
                        return Optional.empty();
                    }
                    charset = parsedCharset.get();
                    continue;
                }
                if (!BOUNDARY.equalsIgnoreCase(key)) continue;
                boundary = value;
            }
        }
        return Optional.of(new ContentType(contentType, charset, boundary));
    }

    public static Optional<ContentType> fromApache(@Nullable Header header) {
        if (header == null || header.getElements().length != 1) {
            return Optional.empty();
        }
        HeaderElement headerElement = header.getElements()[0];
        Optional<ContentTypes> contentTypeOpt = ContentTypes.fromMime(headerElement.getName());
        if (contentTypeOpt.isEmpty()) {
            return Optional.empty();
        }
        ContentTypes contentType = contentTypeOpt.get();
        Charset charset = null;
        String boundary = null;
        NameValuePair charsetParam = headerElement.getParameterByName(CHARSET);
        NameValuePair boundaryParam = headerElement.getParameterByName(BOUNDARY);
        if (charsetParam != null) {
            String s = charsetParam.getValue();
            Optional<Charset> parsedCharset = ContentType.parseCharset(s);
            if (parsedCharset.isEmpty()) {
                LOG.error("Unknown charset provided with content type {}. charset: {}", (Object)contentType, (Object)s);
                return Optional.empty();
            }
            charset = parsedCharset.get();
        }
        if (boundaryParam != null) {
            boundary = boundaryParam.getValue();
        }
        return Optional.of(new ContentType(contentType, charset, boundary));
    }

    public Charset getCharset() {
        return this.charset;
    }

    public ContentTypes getContentType() {
        return this.contentType;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public String toString() {
        return ObjectStringifier.stringify((Object)this);
    }

    public static enum ContentTypes {
        TEXT_XML("text/xml", StandardCharsets.ISO_8859_1),
        APPLICATION_XML("application/xml", null),
        APPLICATION_SOAP_XML("application/soap+xml", StandardCharsets.UTF_8);

        private final String contentType;
        private final Charset defaultEncoding;

        private ContentTypes(String contentType, Charset defaultEncoding) {
            this.contentType = contentType;
            this.defaultEncoding = defaultEncoding;
        }

        public static Optional<ContentTypes> fromMime(String mime) {
            for (ContentTypes contentType : ContentTypes.values()) {
                if (!contentType.contentType.equalsIgnoreCase(mime)) continue;
                return Optional.of(contentType);
            }
            return Optional.empty();
        }

        public Charset getDefaultEncoding() {
            return this.defaultEncoding;
        }

        public String getContentType() {
            return this.contentType;
        }
    }
}

