/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.http.apache;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.CommunicationLog;
import org.somda.sdc.dpws.TransportBinding;
import org.somda.sdc.dpws.crypto.CryptoConfigurator;
import org.somda.sdc.dpws.crypto.CryptoSettings;
import org.somda.sdc.dpws.factory.CommunicationLogFactory;
import org.somda.sdc.dpws.factory.TransportBindingFactory;
import org.somda.sdc.dpws.http.HttpClient;
import org.somda.sdc.dpws.http.apache.ClientTransportBindingFactory;
import org.somda.sdc.dpws.http.apache.CommunicationLogHttpRequestInterceptor;
import org.somda.sdc.dpws.http.apache.CommunicationLogHttpResponseInterceptor;
import org.somda.sdc.dpws.http.factory.HttpClientFactory;
import org.somda.sdc.dpws.soap.SoapMarshalling;
import org.somda.sdc.dpws.soap.SoapUtil;

public class ApacheTransportBindingFactoryImpl
implements TransportBindingFactory,
HttpClientFactory {
    private static final Logger LOG = LogManager.getLogger(ApacheTransportBindingFactoryImpl.class);
    private static final String SCHEME_SOAP_OVER_UDP = "soap.udp";
    private static final String SCHEME_HTTP = "http";
    private static final String SCHEME_HTTPS = "https";
    private final SoapMarshalling marshalling;
    private final SoapUtil soapUtil;
    private final boolean enableGzipCompression;
    private final Duration clientConnectTimeout;
    private final Duration clientReadTimeout;
    private final org.apache.http.client.HttpClient client;
    private final String[] tlsProtocols;
    private final HostnameVerifier hostnameVerifier;
    private final String[] enabledCiphers;
    private final boolean enableHttps;
    private final boolean enableHttp;
    private final CryptoConfigurator cryptoConfigurator;
    @Nullable
    private final CryptoSettings cryptoSettings;
    private final Logger instanceLogger;
    private final String frameworkIdentifier;
    private ClientTransportBindingFactory clientTransportBindingFactory;

    @Inject
    ApacheTransportBindingFactoryImpl(SoapMarshalling marshalling, SoapUtil soapUtil, CryptoConfigurator cryptoConfigurator, @Nullable @Named(value="Dpws.Crypto.Settings") CryptoSettings cryptoSettings, @Named(value="Dpws.HttpClientConnectTimeout") Duration clientConnectTimeout, @Named(value="Dpws.HttpClientReadTimeout") Duration clientReadTimeout, @Named(value="Dpws.GzipCompression") boolean enableGzipCompression, ClientTransportBindingFactory clientTransportBindingFactory, CommunicationLogFactory communicationLogFactory, @Named(value="Dpws.Crypto.TlsEnabledVersions") String[] tlsProtocols, @Named(value="Dpws.Crypto.TlsEnabledCiphers") String[] enabledCiphers, @Named(value="Dpws.Crypto.ClientHostnameVerifier") HostnameVerifier hostnameVerifier, @Named(value="Dpws.EnableHttps") boolean enableHttps, @Named(value="Dpws.EnableHttp") boolean enableHttp, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.cryptoConfigurator = cryptoConfigurator;
        this.cryptoSettings = cryptoSettings;
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.frameworkIdentifier = frameworkIdentifier;
        this.marshalling = marshalling;
        this.soapUtil = soapUtil;
        this.clientConnectTimeout = clientConnectTimeout;
        this.clientReadTimeout = clientReadTimeout;
        this.enableGzipCompression = enableGzipCompression;
        this.clientTransportBindingFactory = clientTransportBindingFactory;
        this.tlsProtocols = tlsProtocols;
        this.enabledCiphers = enabledCiphers;
        this.hostnameVerifier = hostnameVerifier;
        this.enableHttps = enableHttps;
        this.enableHttp = enableHttp;
        if (!this.enableHttp && !this.enableHttps) {
            throw new RuntimeException("Http and https are disabled, cannot continue");
        }
        this.client = this.buildClient(cryptoConfigurator, cryptoSettings, communicationLogFactory.createCommunicationLog());
    }

    private org.apache.http.client.HttpClient buildClient(CryptoConfigurator cryptoConfigurator, @Nullable CryptoSettings cryptoSettings, CommunicationLog communicationLog) {
        SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout((int)this.clientReadTimeout.toMillis()).setConnectTimeout((int)this.clientConnectTimeout.toMillis()).setSocketTimeout((int)this.clientConnectTimeout.toMillis()).build();
        HttpClientBuilder clientBuilder = HttpClients.custom().setDefaultSocketConfig(socketConfig).addInterceptorLast((HttpRequestInterceptor)new CommunicationLogHttpRequestInterceptor(communicationLog, this.frameworkIdentifier, cryptoConfigurator.getCertificates(cryptoSettings))).addInterceptorLast((HttpResponseInterceptor)new CommunicationLogHttpResponseInterceptor(communicationLog, this.frameworkIdentifier)).setDefaultRequestConfig(requestConfig).disableConnectionState().setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(1, false));
        if (!this.enableGzipCompression) {
            clientBuilder.disableContentCompression();
        }
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        if (this.enableHttps) {
            SSLContext sslContext;
            try {
                sslContext = cryptoConfigurator.createSslContextFromCryptoConfig(cryptoSettings);
            }
            catch (Exception e) {
                this.instanceLogger.error("Could not read client crypto config, fallback to system properties", (Throwable)e);
                sslContext = cryptoConfigurator.createSslContextFromSystemProperties();
            }
            this.instanceLogger.debug("Enabled protocols: {}", new Supplier[]{() -> List.of(this.tlsProtocols)});
            SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, this.tlsProtocols, this.enabledCiphers, this.hostnameVerifier);
            registryBuilder.register(SCHEME_HTTPS, (Object)socketFactory);
        }
        if (this.enableHttp) {
            registryBuilder.register(SCHEME_HTTP, (Object)PlainConnectionSocketFactory.getSocketFactory());
        }
        PoolingHttpClientConnectionManager poolingmgr = new PoolingHttpClientConnectionManager(registryBuilder.build(), null, null, null, -1L, TimeUnit.MILLISECONDS);
        poolingmgr.setDefaultMaxPerRoute(1);
        return clientBuilder.setConnectionManager((HttpClientConnectionManager)poolingmgr).build();
    }

    @Override
    public TransportBinding createTransportBinding(String endpointUri, @Nullable CommunicationLog communicationLog) throws UnsupportedOperationException {
        String scheme = URI.create(endpointUri).getScheme();
        if (scheme.equalsIgnoreCase(SCHEME_SOAP_OVER_UDP)) {
            throw new UnsupportedOperationException("SOAP-over-UDP is currently not supported by the TransportBindingFactory");
        }
        if (scheme.equalsIgnoreCase(SCHEME_HTTP)) {
            return this.createHttpBinding(endpointUri, communicationLog);
        }
        if (scheme.equalsIgnoreCase(SCHEME_HTTPS)) {
            return this.createHttpBinding(endpointUri, communicationLog);
        }
        throw new UnsupportedOperationException(String.format("Unsupported transport binding requested: %s", scheme));
    }

    @Override
    public TransportBinding createHttpBinding(String endpointUri, @Nullable CommunicationLog communicationLog) throws UnsupportedOperationException {
        String scheme = URI.create(endpointUri).getScheme();
        if (scheme.toLowerCase().startsWith(SCHEME_HTTP)) {
            org.apache.http.client.HttpClient httpClient = communicationLog == null ? this.client : this.buildClient(this.cryptoConfigurator, this.cryptoSettings, communicationLog);
            return this.clientTransportBindingFactory.create(httpClient, endpointUri, this.marshalling, this.soapUtil);
        }
        throw new UnsupportedOperationException(String.format("Binding with scheme %s is currently not supported", scheme));
    }

    @Override
    public HttpClient createHttpClient() {
        return this.clientTransportBindingFactory.createHttpClient(this.client);
    }

    public org.apache.http.client.HttpClient getClient() {
        return this.client;
    }
}

