/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.http.helper;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.Enumeration;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.crypto.CryptoConfigurator;
import org.somda.sdc.dpws.crypto.CryptoSettings;
import org.somda.sdc.dpws.http.HttpHandler;
import org.somda.sdc.dpws.http.helper.ServerClientSelfTestException;
import org.somda.sdc.dpws.http.jetty.JettyHttpServerHandler;
import org.somda.sdc.dpws.http.jetty.factory.JettyHttpServerHandlerFactory;
import org.somda.sdc.dpws.soap.CommunicationContext;

public class HttpServerClientSelfTest {
    private static final Logger LOG = LogManager.getLogger(HttpServerClientSelfTest.class);
    private final Logger instanceLogger;
    private final boolean enableHttps;
    private final String[] tlsProtocols;
    private final String[] enabledCiphers;
    private final HostnameVerifier hostnameVerifier;
    private final Duration connectionTimeout;
    private final JettyHttpServerHandlerFactory jettyHttpServerHandlerFactory;
    private final CryptoConfigurator cryptoConfigurator;
    private final CryptoSettings cryptoSettings;
    private SSLContext sslContext;

    @Inject
    public HttpServerClientSelfTest(@Named(value="Common.InstanceIdentifier") String frameworkIdentifier, @Named(value="Dpws.EnableHttps") boolean enableHttps, CryptoConfigurator cryptoConfigurator, @Nullable @Named(value="Dpws.Crypto.Settings") CryptoSettings cryptoSettings, @Named(value="Dpws.Crypto.TlsEnabledVersions") String[] tlsProtocols, @Named(value="Dpws.Crypto.TlsEnabledCiphers") String[] enabledCiphers, @Named(value="Dpws.Crypto.DeviceHostnameVerifier") HostnameVerifier hostnameVerifier, @Named(value="Dpws.HttpServerConnectionTimeout") Duration connectionTimeout, JettyHttpServerHandlerFactory jettyHttpServerHandlerFactory) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.enableHttps = enableHttps;
        this.cryptoConfigurator = cryptoConfigurator;
        this.cryptoSettings = cryptoSettings;
        this.tlsProtocols = tlsProtocols;
        this.hostnameVerifier = hostnameVerifier;
        this.enabledCiphers = enabledCiphers;
        this.connectionTimeout = connectionTimeout;
        this.jettyHttpServerHandlerFactory = jettyHttpServerHandlerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnection() {
        if (!this.enableHttps) {
            this.instanceLogger.info("HTTPS protocol disabled, skipping self-test");
            return;
        }
        if (this.cryptoSettings == null) {
            this.logAndThrowException("Crypto settings are required for HTTPS protocol");
        }
        this.instanceLogger.info("Starting self test between server and client");
        this.sslContext = this.getSslContext();
        Server server = this.buildServer();
        String uri = server.getURI().toString();
        this.instanceLogger.info("Using URI {} for the self test", (Object)uri);
        HttpClientBuilder clientBuilder = this.buildHttpClient();
        try (CloseableHttpClient client = clientBuilder.build();
             CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpGet(uri));){
            int responseCode = response.getStatusLine().getStatusCode();
            if (responseCode != 200) {
                this.logAndThrowException("Connection self test failed with status: " + responseCode);
            }
            this.instanceLogger.info("Connection self test was successful");
        }
        catch (IOException e) {
            this.logAndThrowException("Connection self test failed", e);
        }
        finally {
            try {
                server.stop();
            }
            catch (Exception e) {
                this.instanceLogger.error("Could not stop HTTP server", (Throwable)e);
            }
        }
    }

    private SSLContext getSslContext() {
        try {
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            if (this.cryptoSettings.getKeyStoreStream().isEmpty() || this.cryptoSettings.getTrustStoreStream().isEmpty()) {
                throw new IOException("Expected key and trust store, but none found");
            }
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(this.cryptoSettings.getKeyStoreStream().get(), this.cryptoSettings.getKeyStorePassword().toCharArray());
            sslContextBuilder.loadKeyMaterial(keyStore, this.cryptoSettings.getKeyStorePassword().toCharArray());
            this.printCertificateDetails(keyStore);
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(this.cryptoSettings.getTrustStoreStream().get(), this.cryptoSettings.getTrustStorePassword().toCharArray());
            sslContextBuilder.loadTrustMaterial(trustStore, null);
            return sslContextBuilder.build();
        }
        catch (IOException | IllegalArgumentException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            this.instanceLogger.warn("Could not read server crypto config, fallback to system properties");
            return this.cryptoConfigurator.createSslContextFromSystemProperties();
        }
    }

    private HttpClientBuilder buildHttpClient() {
        return HttpClients.custom().setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).build()).setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(this.sslContext, this.tlsProtocols, this.enabledCiphers, this.hostnameVerifier));
    }

    private Server buildServer() {
        String schemeAndAuthority = "https://127.0.0.1:0";
        String contextPath = "/ctxt/self-test";
        this.instanceLogger.debug("Init new HTTP server from URI: {}", (Object)schemeAndAuthority);
        URI uri = URI.create(schemeAndAuthority);
        Server server = new Server(new InetSocketAddress(uri.getHost(), uri.getPort()));
        server.setHandler((Handler)new ContextHandlerCollection(new ContextHandler[]{this.getHttpHandler(contextPath)}));
        server.setConnectors(new Connector[]{this.getServerConnector(uri, server)});
        try {
            server.start();
        }
        catch (Exception e) {
            this.logAndThrowException("Could not start HTTP server for self-test", e);
        }
        return server;
    }

    private ServerConnector getServerConnector(URI uri, Server server) {
        HttpConfiguration httpsConfig = new HttpConfiguration();
        httpsConfig.setHttpCompliance(HttpCompliance.RFC2616);
        SecureRequestCustomizer src = new SecureRequestCustomizer();
        src.setSniHostCheck(false);
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)src);
        ServerConnector httpsConnector = new ServerConnector(server, new ConnectionFactory[]{this.getContextFactory(), new HttpConnectionFactory(httpsConfig)});
        httpsConnector.setIdleTimeout(this.connectionTimeout.toMillis());
        httpsConnector.setHost(uri.getHost());
        httpsConnector.setPort(uri.getPort());
        return httpsConnector;
    }

    private SslConnectionFactory getContextFactory() {
        SslContextFactory.Server contextFactory = new SslContextFactory.Server();
        contextFactory.setSslContext(this.sslContext);
        contextFactory.setNeedClientAuth(true);
        contextFactory.setExcludeProtocols(new String[0]);
        contextFactory.setIncludeProtocols(this.tlsProtocols);
        contextFactory.setExcludeCipherSuites(new String[0]);
        contextFactory.setIncludeCipherSuites(this.enabledCiphers);
        return new SslConnectionFactory(contextFactory, HttpVersion.HTTP_1_1.asString());
    }

    private ContextHandler getHttpHandler(String contextPath) {
        HttpHandler handler = new HttpHandler(){

            @Override
            public void handle(InputStream inStream, OutputStream outStream, CommunicationContext communicationContext) {
                try {
                    outStream.write("OK".getBytes());
                }
                catch (IOException e) {
                    HttpServerClientSelfTest.this.logAndThrowException("HTTP handler failed", e);
                }
            }
        };
        JettyHttpServerHandler endpointHandler = this.jettyHttpServerHandlerFactory.create("application/soap+xml", handler);
        ContextHandler contextHandler = new ContextHandler(contextPath);
        contextHandler.setHandler((Handler)endpointHandler);
        contextHandler.setAllowNullPathInfo(true);
        return contextHandler;
    }

    private void printCertificateDetails(KeyStore keyStore) {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                X509Certificate certificate = (X509Certificate)keyStore.getCertificate(alias);
                this.instanceLogger.info("Certificate Alias: {}", (Object)alias);
                this.instanceLogger.info("Certificate Issuer DName: {}", (Object)certificate.getIssuerDN().getName());
                this.instanceLogger.info("Certificate Subject DName: {}", (Object)certificate.getSubjectDN().getName());
                this.instanceLogger.info("Certificate Extended Key Usage: {}", certificate.getExtendedKeyUsage());
                this.instanceLogger.info("Certificate Expiration: {}", (Object)certificate.getNotAfter());
                this.instanceLogger.trace("Certificate: {}", (Object)certificate);
            }
        }
        catch (KeyStoreException | CertificateParsingException e) {
            this.instanceLogger.warn("Failed to parse certificate details", (Throwable)e);
        }
    }

    private void logAndThrowException(String msg) {
        this.instanceLogger.error(msg);
        throw new ServerClientSelfTestException(msg);
    }

    private void logAndThrowException(String msg, Exception e) {
        this.instanceLogger.error(msg, (Throwable)e);
        throw new ServerClientSelfTestException(msg, e);
    }
}

