/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.http.jetty;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.somda.sdc.dpws.CommunicationLog;
import org.somda.sdc.dpws.http.jetty.CommunicationLogInputInterceptor;
import org.somda.sdc.dpws.http.jetty.CommunicationLogOutputInterceptor;
import org.somda.sdc.dpws.http.jetty.JettyHttpServerHandler;
import org.somda.sdc.dpws.http.jetty.JettyUtil;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.HttpApplicationInfo;
import org.somda.sdc.dpws.soap.TransportInfo;

public class CommunicationLogHandlerWrapper
extends HandlerWrapper {
    private static final String TRANSACTION_ID_PREFIX_SERVER = "rrId:server:" + UUID.randomUUID() + ":";
    private static final AtomicLong TRANSACTION_ID = new AtomicLong(-1L);
    private final CommunicationLog commLog;
    private final String frameworkIdentifier;

    CommunicationLogHandlerWrapper(CommunicationLog commLog, String frameworkIdentifier) {
        this.frameworkIdentifier = frameworkIdentifier;
        this.commLog = commLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String currentTransactionId = TRANSACTION_ID_PREFIX_SERVER + TRANSACTION_ID.incrementAndGet();
        baseRequest.setAttribute(CommunicationLog.MessageType.REQUEST.name(), (Object)currentTransactionId);
        HttpApplicationInfo requestHttpApplicationInfo = new HttpApplicationInfo(JettyUtil.getRequestHeaders(request), currentTransactionId, baseRequest.getRequestURI());
        List<X509Certificate> requestCertificates = JettyHttpServerHandler.getX509Certificates(request, baseRequest.isSecure());
        TransportInfo transportInfo = new TransportInfo(request.getScheme(), request.getLocalAddr(), request.getLocalPort(), request.getRemoteAddr(), request.getRemotePort(), requestCertificates);
        CommunicationContext requestCommContext = new CommunicationContext(requestHttpApplicationInfo, transportInfo);
        OutputStream input = this.commLog.logMessage(CommunicationLog.Direction.INBOUND, CommunicationLog.TransportType.HTTP, CommunicationLog.MessageType.REQUEST, requestCommContext);
        HttpOutput out = baseRequest.getResponse().getHttpOutput();
        baseRequest.getHttpInput().addInterceptor((HttpInput.Interceptor)new CommunicationLogInputInterceptor(input, this.frameworkIdentifier));
        HttpOutput.Interceptor previousInterceptor = out.getInterceptor();
        try {
            CommunicationLogOutputInterceptor outInterceptor = new CommunicationLogOutputInterceptor(baseRequest.getHttpChannel(), previousInterceptor, this.commLog, transportInfo, this.frameworkIdentifier, currentTransactionId);
            out.setInterceptor((HttpOutput.Interceptor)outInterceptor);
            super.handle(target, baseRequest, request, response);
        }
        finally {
            if (!baseRequest.isHandled() && !baseRequest.isAsyncStarted()) {
                out.setInterceptor(previousInterceptor);
            }
        }
    }
}

