/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap;

import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.helper.JaxbMarshalling;
import org.somda.sdc.dpws.soap.SoapMarshalling;
import org.somda.sdc.dpws.soap.model.Envelope;
import org.somda.sdc.dpws.soap.model.ObjectFactory;

public class JaxbSoapMarshalling
extends AbstractIdleService
implements SoapMarshalling {
    private static final Logger LOG = LogManager.getLogger(JaxbSoapMarshalling.class);
    private final Logger instanceLogger;
    private final ObjectFactory soapFactory;
    private final JaxbMarshalling jaxbMarshalling;

    @Inject
    JaxbSoapMarshalling(@Named(value="Common.InstanceIdentifier") String frameworkIdentifier, ObjectFactory soapFactory, JaxbMarshalling jaxbMarshalling) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.soapFactory = soapFactory;
        this.jaxbMarshalling = jaxbMarshalling;
    }

    protected void startUp() throws Exception {
        this.instanceLogger.info("SOAP marshalling started");
    }

    protected void shutDown() {
        this.instanceLogger.info("SOAP marshalling stopped");
    }

    @Override
    public void marshal(Envelope envelope, OutputStream outputStream) throws JAXBException {
        this.checkRunning();
        this.jaxbMarshalling.marshal(this.soapFactory.createEnvelope(envelope), outputStream);
    }

    private void checkRunning() {
        if (!this.isRunning()) {
            throw new RuntimeException("Try to marshal, but SOAP marshalling service is not running. Please check if the DPWS framework is up and running.");
        }
    }

    @Override
    public Envelope unmarshal(InputStream inputStream) throws JAXBException, ClassCastException {
        this.checkRunning();
        return (Envelope)((JAXBElement)this.jaxbMarshalling.unmarshal(inputStream)).getValue();
    }

    @Override
    public Envelope unmarshal(Reader reader) throws JAXBException, ClassCastException {
        this.checkRunning();
        return (Envelope)((JAXBElement)this.jaxbMarshalling.unmarshal(reader)).getValue();
    }
}

