/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import org.somda.sdc.dpws.soap.NotificationSource;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.interception.ClientDispatcher;
import org.somda.sdc.dpws.soap.interception.Direction;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.InterceptorException;
import org.somda.sdc.dpws.soap.interception.InterceptorRegistry;
import org.somda.sdc.dpws.soap.interception.NotificationCallback;
import org.somda.sdc.dpws.soap.interception.NotificationObject;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingClientInterceptor;

public class NotificationSourceImpl
implements NotificationSource {
    private final InterceptorRegistry interceptorRegistry;
    private final NotificationCallback networkCallback;
    private final ClientDispatcher clientDispatcher;

    @Inject
    NotificationSourceImpl(@Assisted NotificationCallback networkCallback, ClientDispatcher clientDispatcher, InterceptorRegistry interceptorRegistry, WsAddressingClientInterceptor wsaClientInterceptor) {
        this.networkCallback = networkCallback;
        this.clientDispatcher = clientDispatcher;
        this.interceptorRegistry = interceptorRegistry;
        this.register(wsaClientInterceptor);
    }

    @Override
    public void register(Interceptor interceptor) {
        this.interceptorRegistry.addInterceptor(interceptor);
    }

    @Override
    public void sendNotification(SoapMessage notification) throws MarshallingException, TransportException, InterceptorException {
        NotificationObject nObj = new NotificationObject(notification);
        this.clientDispatcher.invokeDispatcher(Direction.NOTIFICATION, this.interceptorRegistry, notification, nObj);
        this.networkCallback.onNotification(notification);
    }
}

