/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Collections;
import org.somda.sdc.dpws.soap.ApplicationInfo;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.RequestResponseClient;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.TransportInfo;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.interception.ClientDispatcher;
import org.somda.sdc.dpws.soap.interception.Direction;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.InterceptorException;
import org.somda.sdc.dpws.soap.interception.InterceptorRegistry;
import org.somda.sdc.dpws.soap.interception.RequestObject;
import org.somda.sdc.dpws.soap.interception.RequestResponseCallback;
import org.somda.sdc.dpws.soap.interception.RequestResponseObject;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingClientInterceptor;

public class RequestResponseClientImpl
implements RequestResponseClient {
    private final InterceptorRegistry interceptorRegistry;
    private final RequestResponseCallback networkCallback;
    private final ClientDispatcher clientDispatcher;

    @AssistedInject
    RequestResponseClientImpl(@Assisted RequestResponseCallback networkCallback, ClientDispatcher clientDispatcher, InterceptorRegistry interceptorRegistry, WsAddressingClientInterceptor wsaClientInterceptor) {
        this.networkCallback = networkCallback;
        this.clientDispatcher = clientDispatcher;
        this.interceptorRegistry = interceptorRegistry;
        this.register(wsaClientInterceptor);
    }

    @Override
    public void register(Interceptor interceptor) {
        this.interceptorRegistry.addInterceptor(interceptor);
    }

    @Override
    public SoapMessage sendRequestResponse(SoapMessage request) throws SoapFaultException, MarshallingException, TransportException, InterceptorException {
        RequestObject rObj = new RequestObject(request);
        this.clientDispatcher.invokeDispatcher(Direction.REQUEST, this.interceptorRegistry, request, rObj);
        SoapMessage response = this.networkCallback.onRequestResponse(request);
        if (response.isFault()) {
            throw new SoapFaultException(response, request.getWsAddressingHeader().getMessageId().orElse(null));
        }
        TransportInfo transportInfo = new TransportInfo("", null, null, null, null, Collections.emptyList());
        RequestResponseObject rrObj = new RequestResponseObject(request, response, new CommunicationContext(new ApplicationInfo(), transportInfo));
        this.clientDispatcher.invokeDispatcher(Direction.RESPONSE, this.interceptorRegistry, response, rrObj);
        return response;
    }
}

