/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wsaddressing;

import com.google.inject.Inject;
import java.net.URI;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedQNameType;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wsaddressing.model.ObjectFactory;
import org.somda.sdc.dpws.soap.wsaddressing.model.RelatesToType;

public class WsAddressingUtil {
    private final ObjectFactory wsaFactory;

    @Inject
    WsAddressingUtil(ObjectFactory wsaFactory) {
        this.wsaFactory = wsaFactory;
    }

    public AttributedURIType createAttributedURIType(String uri) {
        AttributedURIType attributedURIType = this.wsaFactory.createAttributedURIType();
        attributedURIType.setValue(uri);
        return attributedURIType;
    }

    public AttributedQNameType createAttributedQNameType(QName qName) {
        AttributedQNameType attributedQNameType = this.wsaFactory.createAttributedQNameType();
        attributedQNameType.setValue(qName);
        return attributedQNameType;
    }

    public AttributedURIType createAttributedURIType(URI uri) {
        return this.createAttributedURIType(uri.toString());
    }

    public RelatesToType createRelatesToType(String uri) {
        RelatesToType relatesToType = this.wsaFactory.createRelatesToType();
        relatesToType.setValue(uri);
        return relatesToType;
    }

    public RelatesToType createRelatesToType(@Nullable AttributedURIType attributedURIType) {
        String msgId = attributedURIType != null ? attributedURIType.getValue() : "http://www.w3.org/2005/08/addressing/unspecified";
        return this.createRelatesToType(msgId);
    }

    public Optional<String> getAddressUri(EndpointReferenceType epr) {
        return Optional.ofNullable(epr.getAddress()).map(AttributedURIType::getValue);
    }

    public String getAddressUriString(AttributedURIType attributedURIType) {
        return attributedURIType.getValue() == null ? "" : attributedURIType.getValue();
    }

    public EndpointReferenceType createEprWithAddress(String addressUri) {
        EndpointReferenceType eprType = this.wsaFactory.createEndpointReferenceType();
        eprType.setAddress(this.createAttributedURIType(addressUri));
        return eprType;
    }

    public EndpointReferenceType createEprWithAddress(URI addressUri) {
        return this.createEprWithAddress(addressUri.toString());
    }
}

