/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wseventing;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.common.util.JaxbUtil;
import org.somda.sdc.dpws.device.helper.RequestResponseServerHttpHandler;
import org.somda.sdc.dpws.http.HttpServerRegistry;
import org.somda.sdc.dpws.http.HttpUriBuilder;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.TransportInfo;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.factory.EnvelopeFactory;
import org.somda.sdc.dpws.soap.factory.SoapMessageFactory;
import org.somda.sdc.dpws.soap.interception.Direction;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.RequestResponseObject;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wsaddressing.model.ReferenceParametersType;
import org.somda.sdc.dpws.soap.wseventing.EventSource;
import org.somda.sdc.dpws.soap.wseventing.SourceSubscriptionManager;
import org.somda.sdc.dpws.soap.wseventing.SubscriptionManager;
import org.somda.sdc.dpws.soap.wseventing.WsEventingConstants;
import org.somda.sdc.dpws.soap.wseventing.factory.SubscriptionManagerFactory;
import org.somda.sdc.dpws.soap.wseventing.factory.WsEventingFaultFactory;
import org.somda.sdc.dpws.soap.wseventing.helper.SubscriptionRegistry;
import org.somda.sdc.dpws.soap.wseventing.model.FilterType;
import org.somda.sdc.dpws.soap.wseventing.model.GetStatus;
import org.somda.sdc.dpws.soap.wseventing.model.GetStatusResponse;
import org.somda.sdc.dpws.soap.wseventing.model.Notification;
import org.somda.sdc.dpws.soap.wseventing.model.ObjectFactory;
import org.somda.sdc.dpws.soap.wseventing.model.Renew;
import org.somda.sdc.dpws.soap.wseventing.model.RenewResponse;
import org.somda.sdc.dpws.soap.wseventing.model.Subscribe;
import org.somda.sdc.dpws.soap.wseventing.model.SubscribeResponse;
import org.somda.sdc.dpws.soap.wseventing.model.SubscriptionEnd;
import org.somda.sdc.dpws.soap.wseventing.model.Unsubscribe;
import org.somda.sdc.dpws.soap.wseventing.model.WsEventingStatus;

public class EventSourceInterceptor
extends AbstractIdleService
implements EventSource {
    private static final Logger LOG = LogManager.getLogger(EventSourceInterceptor.class);
    private final Duration maxExpires;
    private final String subscriptionManagerPath;
    private final SoapUtil soapUtil;
    private final WsEventingFaultFactory faultFactory;
    private final HttpServerRegistry httpServerRegistry;
    private final Provider<RequestResponseServerHttpHandler> rrServerHttpHandlerProvider;
    private final SubscriptionRegistry subscriptionRegistry;
    private final SubscriptionManagerFactory subscriptionManagerFactory;
    private final HttpUriBuilder httpUriBuilder;
    private final Multimap<String, String> subscribedActionsToSubManIds;
    private final Lock subscribedActionsLock;
    private final JaxbUtil jaxbUtil;
    private final WsAddressingUtil wsaUtil;
    private final ObjectFactory wseFactory;
    private final SoapMessageFactory soapMessageFactory;
    private final EnvelopeFactory envelopeFactory;
    private final Logger instanceLogger;

    @Inject
    EventSourceInterceptor(@Named(value="WsEventing.Source.MaxExpires") Duration maxExpires, @Named(value="WsEventing.Source.SubscriptionManagerPath") String subscriptionManagerPath, SoapUtil soapUtil, WsEventingFaultFactory faultFactory, JaxbUtil jaxbUtil, WsAddressingUtil wsaUtil, ObjectFactory wseFactory, SoapMessageFactory soapMessageFactory, EnvelopeFactory envelopeFactory, HttpServerRegistry httpServerRegistry, Provider<RequestResponseServerHttpHandler> rrServerHttpHandlerProvider, SubscriptionRegistry subscriptionRegistry, SubscriptionManagerFactory subscriptionManagerFactory, HttpUriBuilder httpUriBuilder, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.maxExpires = maxExpires;
        this.subscriptionManagerPath = subscriptionManagerPath;
        this.soapUtil = soapUtil;
        this.faultFactory = faultFactory;
        this.httpServerRegistry = httpServerRegistry;
        this.rrServerHttpHandlerProvider = rrServerHttpHandlerProvider;
        this.subscriptionRegistry = subscriptionRegistry;
        this.subscriptionManagerFactory = subscriptionManagerFactory;
        this.httpUriBuilder = httpUriBuilder;
        this.subscribedActionsToSubManIds = LinkedListMultimap.create();
        this.jaxbUtil = jaxbUtil;
        this.wsaUtil = wsaUtil;
        this.subscribedActionsLock = new ReentrantLock();
        this.wseFactory = wseFactory;
        this.soapMessageFactory = soapMessageFactory;
        this.envelopeFactory = envelopeFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendNotification(String action, Object payload) {
        HashSet affectedSubscriptionIds;
        this.removeStaleSubscriptions();
        this.subscribedActionsLock.lock();
        try {
            affectedSubscriptionIds = new HashSet(this.subscribedActionsToSubManIds.get((Object)action));
            if (affectedSubscriptionIds.isEmpty()) {
                return;
            }
        }
        finally {
            this.subscribedActionsLock.unlock();
        }
        for (String subId : affectedSubscriptionIds) {
            this.subscriptionRegistry.getSubscription(subId).ifPresent(subscriptionManager -> {
                SoapMessage notifyTo = this.createForNotifyTo(action, payload, (SourceSubscriptionManager)subscriptionManager);
                subscriptionManager.offerNotification(new Notification(notifyTo));
            });
        }
    }

    @Override
    public void subscriptionEndToAll(WsEventingStatus status) {
        this.removeStaleSubscriptions();
        this.subscriptionRegistry.getSubscriptions().forEach((uri, subMan) -> {
            subMan.getEndTo().ifPresent(endTo -> {
                SoapMessage endToMessage = this.createForEndTo(status, (SourceSubscriptionManager)subMan, (EndpointReferenceType)endTo);
                subMan.sendToEndTo(endToMessage);
            });
            subMan.stopAsync().awaitTerminated();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MessageInterceptor(value="http://schemas.xmlsoap.org/ws/2004/08/eventing/Subscribe", direction=Direction.REQUEST)
    void processSubscribe(RequestResponseObject rrObj) throws SoapFaultException {
        this.removeStaleSubscriptions();
        AttributedURIType requestMsgId = rrObj.getRequest().getWsAddressingHeader().getMessageId().orElse(null);
        Supplier<SoapFaultException> soapFaultExceptionSupplier = () -> new SoapFaultException(this.createInvalidMsg(rrObj, String.format("Subscribe request %s was not valid", requestMsgId)));
        Subscribe subscribe = this.soapUtil.getBody(rrObj.getRequest(), Subscribe.class).orElseThrow(soapFaultExceptionSupplier);
        String deliveryMode = Optional.ofNullable(subscribe.getDelivery().getMode()).orElse("http://schemas.xmlsoap.org/ws/2004/08/eventing/DeliveryModes/Push");
        if (!deliveryMode.equals("http://schemas.xmlsoap.org/ws/2004/08/eventing/DeliveryModes/Push")) {
            throw new SoapFaultException(this.faultFactory.createDeliveryModeRequestedUnavailable(), requestMsgId);
        }
        if (subscribe.getDelivery().getContent().size() != 1) {
            throw new SoapFaultException(this.createInvalidMsg(rrObj), requestMsgId);
        }
        EndpointReferenceType notifyTo = (EndpointReferenceType)this.jaxbUtil.extractElement(subscribe.getDelivery().getContent().get(0), WsEventingConstants.NOTIFY_TO, EndpointReferenceType.class).orElseThrow(soapFaultExceptionSupplier);
        this.wsaUtil.getAddressUri(notifyTo).orElseThrow(soapFaultExceptionSupplier);
        Duration grantedExpires = this.grantExpires(this.validateExpires(subscribe.getExpires()));
        TransportInfo transportInfo = rrObj.getCommunicationContext().getTransportInfo();
        EndpointReferenceType epr = this.createSubscriptionManagerEprAndRegisterHttpHandler(transportInfo.getScheme(), transportInfo.getLocalAddress().orElseThrow(() -> new RuntimeException("Fatal error. Missing local address in transport information.")), transportInfo.getLocalPort().orElseThrow(() -> new RuntimeException("Fatal error. Missing local port in transport information.")));
        FilterType filterType = Optional.ofNullable(subscribe.getFilter()).orElseThrow(() -> new SoapFaultException(this.faultFactory.createEventSourceUnableToProcess("No filter given, but required."), requestMsgId));
        String filterDialect = Optional.ofNullable(filterType.getDialect()).orElse("");
        if (!filterDialect.equals("http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01/Action")) {
            throw new SoapFaultException(this.faultFactory.createFilteringRequestedUnavailable(), requestMsgId);
        }
        List<String> uris = this.explodeUriList(filterType);
        SourceSubscriptionManager subMan = this.subscriptionManagerFactory.createSourceSubscriptionManager(epr, grantedExpires, notifyTo, subscribe.getEndTo(), epr.getAddress().getValue(), Collections.unmodifiableList(uris));
        subMan.startAsync().awaitRunning();
        this.subscribedActionsLock.lock();
        try {
            uris.forEach(uri -> this.subscribedActionsToSubManIds.put(uri, (Object)subMan.getSubscriptionId()));
        }
        finally {
            this.subscribedActionsLock.unlock();
        }
        this.subscriptionRegistry.addSubscription(subMan);
        SubscribeResponse subscribeResponse = this.wseFactory.createSubscribeResponse();
        subscribeResponse.setExpires(grantedExpires);
        subscribeResponse.setSubscriptionManager(subMan.getSubscriptionManagerEpr());
        this.soapUtil.setBody(subscribeResponse, rrObj.getResponse());
        this.soapUtil.setWsaAction(rrObj.getResponse(), "http://schemas.xmlsoap.org/ws/2004/08/eventing/SubscribeResponse");
        this.instanceLogger.info("Incoming subscribe request. Action(s): {}. Generated subscription id: {}. Notifications go to {}. Expiration in {} seconds", (Object)Arrays.toString(uris.toArray()), (Object)subMan.getSubscriptionId(), (Object)this.wsaUtil.getAddressUri(subMan.getNotifyTo()).orElse("<unknown>"), (Object)grantedExpires.getSeconds());
    }

    @MessageInterceptor(value="http://schemas.xmlsoap.org/ws/2004/08/eventing/Renew", direction=Direction.REQUEST)
    void processRenew(RequestResponseObject rrObj) throws SoapFaultException {
        this.removeStaleSubscriptions();
        Renew renew = this.validateRequestBody(rrObj, Renew.class);
        Duration grantedExpires = this.grantExpires(this.validateExpires(renew.getExpires()));
        SourceSubscriptionManager subMan = this.validateSubscriptionEpr(rrObj);
        subMan.renew(grantedExpires);
        RenewResponse renewResponse = this.wseFactory.createRenewResponse();
        renewResponse.setExpires(grantedExpires);
        this.soapUtil.setBody(renewResponse, rrObj.getResponse());
        this.soapUtil.setWsaAction(rrObj.getResponse(), "http://schemas.xmlsoap.org/ws/2004/08/eventing/RenewResponse");
        this.instanceLogger.info("Subscription {} is renewed. New expiration in {} seconds", (Object)subMan.getSubscriptionId(), (Object)grantedExpires.getSeconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MessageInterceptor(value="http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatus", direction=Direction.REQUEST)
    void processGetStatus(RequestResponseObject rrObj) throws SoapFaultException {
        Duration expires;
        this.removeStaleSubscriptions();
        this.validateRequestBody(rrObj, GetStatus.class);
        this.subscribedActionsLock.lock();
        try {
            SourceSubscriptionManager subMan = this.validateSubscriptionEpr(rrObj);
            expires = Duration.between(LocalDateTime.now(), subMan.getExpiresTimeout());
            if (expires.isNegative() || expires.isZero()) {
                throw new SoapFaultException(this.createInvalidMsg(rrObj, String.format("Given wse:Identifier '%s' is invalid.", subMan.getSubscriptionId())), rrObj.getRequest().getWsAddressingHeader().getMessageId().orElse(null));
            }
        }
        finally {
            this.subscribedActionsLock.unlock();
        }
        GetStatusResponse getStatusResponse = this.wseFactory.createGetStatusResponse();
        getStatusResponse.setExpires(expires);
        this.soapUtil.setBody(getStatusResponse, rrObj.getResponse());
        this.soapUtil.setWsaAction(rrObj.getResponse(), "http://schemas.xmlsoap.org/ws/2004/08/eventing/GetStatusResponse");
    }

    @MessageInterceptor(value="http://schemas.xmlsoap.org/ws/2004/08/eventing/Unsubscribe", direction=Direction.REQUEST)
    void processUnsubscribe(RequestResponseObject rrObj) throws SoapFaultException {
        this.removeStaleSubscriptions();
        this.validateRequestBody(rrObj, Unsubscribe.class);
        SourceSubscriptionManager subMan = this.validateSubscriptionEpr(rrObj);
        subMan.stopAsync().awaitTerminated();
        this.soapUtil.setWsaAction(rrObj.getResponse(), "http://schemas.xmlsoap.org/ws/2004/08/eventing/UnsubscribeResponse");
        this.instanceLogger.info("Unsubscribe {}. Invalidate subscription manager", (Object)subMan.getSubscriptionId());
    }

    private void removeStaleSubscriptions() {
        this.subscriptionRegistry.getSubscriptions().forEach((key, subMan) -> {
            if (!subMan.isRunning() || this.isSubscriptionExpired((SourceSubscriptionManager)subMan)) {
                this.subscriptionRegistry.removeSubscription((String)key);
                this.unregisterHttpHandler((SourceSubscriptionManager)subMan);
                this.subscribedActionsLock.lock();
                try {
                    HashSet uris = new HashSet(this.subscribedActionsToSubManIds.keySet());
                    uris.forEach(uri -> this.subscribedActionsToSubManIds.remove(uri, key));
                }
                finally {
                    this.subscribedActionsLock.unlock();
                }
                subMan.stopAsync();
                this.instanceLogger.info("Remove expired subscription: {}", key);
            }
        });
    }

    private EndpointReferenceType createSubscriptionManagerEprAndRegisterHttpHandler(String scheme, String address, Integer port) {
        String hostPart = this.httpUriBuilder.buildUri(scheme, address, port);
        String contextPath = "/" + UUID.randomUUID() + "/" + this.subscriptionManagerPath;
        String eprAddress = hostPart + contextPath;
        RequestResponseServerHttpHandler handler = (RequestResponseServerHttpHandler)this.rrServerHttpHandlerProvider.get();
        handler.register(this);
        this.httpServerRegistry.registerContext(hostPart, contextPath, handler);
        return this.wsaUtil.createEprWithAddress(eprAddress);
    }

    private void unregisterHttpHandler(SourceSubscriptionManager subMan) {
        URI fullUri = URI.create(subMan.getSubscriptionManagerEpr().getAddress().getValue());
        String uriWithoutPath = this.httpUriBuilder.buildUri(fullUri.getScheme(), fullUri.getHost(), fullUri.getPort());
        this.httpServerRegistry.unregisterContext(uriWithoutPath, fullUri.getPath());
    }

    private boolean isSubscriptionExpired(SourceSubscriptionManager subMan) {
        Duration expires = Duration.between(LocalDateTime.now(), subMan.getExpiresTimeout());
        return expires.isZero() || expires.isNegative();
    }

    private Duration validateExpires(@Nullable Duration requestedExpires) throws SoapFaultException {
        try {
            if (requestedExpires == null) {
                return null;
            }
            if (requestedExpires.isZero() || requestedExpires.isNegative()) {
                throw new Exception(String.format("Expires is less than or equal to 0: {}", requestedExpires));
            }
            return requestedExpires;
        }
        catch (Exception e) {
            throw new SoapFaultException(this.faultFactory.createInvalidExpirationTime());
        }
    }

    private <T> T validateRequestBody(RequestResponseObject rrObj, Class<T> expectedType) throws SoapFaultException {
        return this.soapUtil.getBody(rrObj.getRequest(), expectedType).orElseThrow(() -> new SoapFaultException(this.createInvalidMsg(rrObj), rrObj.getRequest().getWsAddressingHeader().getMessageId().orElse(null)));
    }

    private SourceSubscriptionManager validateSubscriptionEpr(RequestResponseObject rrObj) throws SoapFaultException {
        AttributedURIType toUri = rrObj.getRequest().getWsAddressingHeader().getTo().orElseThrow(() -> new SoapFaultException(this.createInvalidMsg(rrObj), rrObj.getRequest().getWsAddressingHeader().getMessageId().orElse(null)));
        return this.subscriptionRegistry.getSubscription(toUri.getValue()).orElseThrow(() -> new SoapFaultException(this.createInvalidMsg(rrObj, String.format("Subscription manager '%s' does not exist.", toUri.getValue())), rrObj.getRequest().getWsAddressingHeader().getMessageId().orElse(null)));
    }

    private List<String> explodeUriList(FilterType filterType) {
        ArrayList<String> result = new ArrayList<String>();
        if (filterType.getContent().size() != 1) {
            return result;
        }
        if (!String.class.isAssignableFrom(filterType.getContent().get(0).getClass())) {
            return result;
        }
        String listOfAnyUri = (String)filterType.getContent().get(0);
        result.addAll(Arrays.asList(listOfAnyUri.split("\\s+")));
        return result;
    }

    private SoapMessage createInvalidMsg(RequestResponseObject rrObj, String reason) {
        return this.faultFactory.createInvalidMessage(reason, rrObj.getRequest().getOriginalEnvelope());
    }

    private SoapMessage createInvalidMsg(RequestResponseObject rrObj) {
        return this.createInvalidMsg(rrObj, "SOAP message is invalid.");
    }

    private Duration grantExpires(@Nullable Duration expires) {
        if (expires != null && this.maxExpires.compareTo(expires) >= 0) {
            return expires;
        }
        return this.maxExpires;
    }

    private SoapMessage createForEndTo(WsEventingStatus status, SourceSubscriptionManager subMan, EndpointReferenceType endTo) {
        SubscriptionEnd subscriptionEnd = this.wseFactory.createSubscriptionEnd();
        subscriptionEnd.setSubscriptionManager(subMan.getSubscriptionManagerEpr());
        subscriptionEnd.setStatus(status.getUri());
        String wsaTo = this.wsaUtil.getAddressUri(endTo).orElse(null);
        return this.createNotification("http://schemas.xmlsoap.org/ws/2004/08/eventing/SubscriptionEnd", wsaTo, subscriptionEnd);
    }

    private SoapMessage createForNotifyTo(String wsaAction, Object payload, SourceSubscriptionManager subMan) {
        EndpointReferenceType notifyTo = subMan.getNotifyTo();
        String wsaTo = this.wsaUtil.getAddressUri(notifyTo).orElseThrow(() -> new RuntimeException("Could not resolve URI from NotifyTo"));
        ReferenceParametersType referenceParameters = notifyTo.getReferenceParameters();
        return this.soapUtil.createMessage(wsaAction, wsaTo, payload, referenceParameters);
    }

    private SoapMessage createNotification(String wsaAction, @Nullable String wsaTo, Object payload) {
        SoapMessage msg = this.soapUtil.createMessage(wsaAction, payload);
        Optional.ofNullable(wsaTo).ifPresent(to -> msg.getWsAddressingHeader().setTo(this.wsaUtil.createAttributedURIType((String)to)));
        return msg;
    }

    @Override
    public Map<String, SubscriptionManager> getActiveSubscriptions() {
        this.removeStaleSubscriptions();
        return this.subscriptionRegistry.getSubscriptions().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    protected void startUp() {
    }

    protected void shutDown() {
        this.subscriptionEndToAll(WsEventingStatus.STATUS_SOURCE_SHUTTING_DOWN);
    }
}

