/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wseventing;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wseventing.SinkSubscriptionManager;
import org.somda.sdc.dpws.soap.wseventing.helper.SubscriptionManagerBase;

public class SinkSubscriptionManagerImpl
implements SinkSubscriptionManager {
    private final SubscriptionManagerBase delegate;

    @AssistedInject
    SinkSubscriptionManagerImpl(@Assisted(value="SubscriptionManager") EndpointReferenceType subscriptionManagerEpr, @Assisted Duration expires, @Assisted(value="NotifyTo") EndpointReferenceType notifyTo, @Assisted(value="EndTo") EndpointReferenceType endTo, @Assisted(value="Actions") Collection<String> actions) {
        String subscriptionId = UUID.randomUUID().toString();
        this.delegate = new SubscriptionManagerBase(notifyTo, endTo, subscriptionId, expires, subscriptionManagerEpr, actions);
    }

    @Override
    public String getSubscriptionId() {
        return this.delegate.getSubscriptionId();
    }

    @Override
    public LocalDateTime getExpiresTimeout() {
        return this.delegate.getExpiresTimeout();
    }

    @Override
    public EndpointReferenceType getNotifyTo() {
        return this.delegate.getNotifyTo();
    }

    @Override
    public Optional<EndpointReferenceType> getEndTo() {
        return this.delegate.getEndTo();
    }

    @Override
    public Duration getExpires() {
        return this.delegate.getExpires();
    }

    @Override
    public EndpointReferenceType getSubscriptionManagerEpr() {
        return this.delegate.getSubscriptionManagerEpr();
    }

    @Override
    public Collection<String> getActions() {
        return this.delegate.getActions();
    }

    @Override
    public void renew(Duration expires) {
        this.delegate.renew(expires);
    }
}

