/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.wsdl;

import com.google.common.util.concurrent.AbstractIdleService;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.helper.JaxbMarshalling;
import org.somda.sdc.dpws.wsdl.WsdlMarshalling;
import org.somda.sdc.dpws.wsdl.model.ObjectFactory;
import org.somda.sdc.dpws.wsdl.model.TDefinitions;

public class JaxbWsdlMarshalling
extends AbstractIdleService
implements WsdlMarshalling {
    private static final Logger LOG = LogManager.getLogger(JaxbWsdlMarshalling.class);
    private final Logger instanceLogger;
    private final ObjectFactory wsdlFactory;
    private final JaxbMarshalling jaxbMarshalling;

    @Inject
    JaxbWsdlMarshalling(@Named(value="Common.InstanceIdentifier") String frameworkIdentifier, ObjectFactory wsdlFactory, JaxbMarshalling jaxbMarshalling) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.wsdlFactory = wsdlFactory;
        this.jaxbMarshalling = jaxbMarshalling;
    }

    protected void startUp() throws Exception {
        this.instanceLogger.info("WSDL marshalling started");
    }

    protected void shutDown() {
        this.instanceLogger.info("WSDL marshalling stopped");
    }

    @Override
    public void marshal(TDefinitions wsdlDefinition, OutputStream outputStream) throws JAXBException {
        this.checkRunning();
        this.jaxbMarshalling.marshal(this.wsdlFactory.createDefinitions(wsdlDefinition), outputStream);
    }

    private void checkRunning() {
        if (!this.isRunning()) {
            throw new RuntimeException("Try to marshal, but WSDL marshalling service is not running. Please check if the DPWS framework is up and running.");
        }
    }

    @Override
    public TDefinitions unmarshal(InputStream inputStream) throws JAXBException, ClassCastException {
        this.checkRunning();
        return (TDefinitions)((JAXBElement)this.jaxbMarshalling.unmarshal(inputStream)).getValue();
    }
}

