/*
 * Decompiled with CFR 0.152.
 */
package it.org.somda.sdc.dpws;

import com.google.inject.AbstractModule;
import com.sun.net.httpserver.HttpServer;
import it.org.somda.sdc.dpws.HttpServerUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.somda.sdc.dpws.CommunicationLogContext;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.TransportBinding;
import org.somda.sdc.dpws.factory.TransportBindingFactory;
import org.somda.sdc.dpws.guice.DefaultDpwsConfigModule;
import org.somda.sdc.dpws.helper.JaxbMarshalling;
import org.somda.sdc.dpws.http.apache.ClientTransportBinding;
import org.somda.sdc.dpws.soap.SoapMarshalling;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.factory.EnvelopeFactory;
import org.somda.sdc.dpws.soap.factory.SoapMessageFactory;

class ApacheHttpClientTransportBindingFactoryImplIT
extends DpwsTest {
    private TransportBindingFactory transportBindingFactory;
    private SoapMessageFactory soapMessageFactory;
    private EnvelopeFactory envelopeFactory;
    private SoapMarshalling marshalling;

    ApacheHttpClientTransportBindingFactoryImplIT() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        DefaultDpwsConfigModule override = new DefaultDpwsConfigModule(){

            public void customConfigure() {
                this.bind("Dpws.GzipCompression", Boolean.class, true);
            }
        };
        this.overrideBindings((AbstractModule)override);
        super.setUp();
        this.transportBindingFactory = (TransportBindingFactory)this.getInjector().getInstance(TransportBindingFactory.class);
        this.soapMessageFactory = (SoapMessageFactory)this.getInjector().getInstance(SoapMessageFactory.class);
        this.envelopeFactory = (EnvelopeFactory)this.getInjector().getInstance(EnvelopeFactory.class);
        ((JaxbMarshalling)this.getInjector().getInstance(JaxbMarshalling.class)).startAsync().awaitRunning();
        this.marshalling = (SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class);
        this.marshalling.startAsync().awaitRunning();
    }

    @Test
    void testGzipCompression() throws Exception {
        URI baseUri = URI.create("http://127.0.0.1:0/");
        String expectedResponse = "Sehr geehrter Kaliba, netter Versuch\nKritische Texte, Weltverbesserer-Blues;";
        JAXBElement jaxbElement = new JAXBElement(new QName("root-element"), String.class, (Object)expectedResponse);
        SoapMessage responseEnvelope = this.createASoapMessage();
        responseEnvelope.getOriginalEnvelope().getBody().getAny().add(jaxbElement);
        ByteArrayOutputStream expectedResponseStream = new ByteArrayOutputStream();
        this.marshalling.marshal(responseEnvelope.getEnvelopeWithMappedHeaders(), (OutputStream)expectedResponseStream);
        byte[] responseBytes = expectedResponseStream.toByteArray();
        HttpServerUtil.GzipResponseHandler handler = new HttpServerUtil.GzipResponseHandler(responseBytes);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(baseUri.getHost(), baseUri.getPort());
        HttpServer server = HttpServerUtil.spawnHttpServer(inetSocketAddress, handler);
        baseUri = new URI(baseUri.getScheme(), baseUri.getUserInfo(), baseUri.getHost(), server.getAddress().getPort(), baseUri.getPath(), baseUri.getQuery(), baseUri.getFragment());
        TransportBinding httpBinding1 = this.transportBindingFactory.createHttpBinding(baseUri.toString(), null);
        SoapMessage response = httpBinding1.onRequestResponse(this.createASoapMessage());
        ByteArrayOutputStream actualResponseStream = new ByteArrayOutputStream();
        this.marshalling.marshal(response.getEnvelopeWithMappedHeaders(), (OutputStream)actualResponseStream);
        Assertions.assertArrayEquals((byte[])expectedResponseStream.toByteArray(), (byte[])actualResponseStream.toByteArray());
    }

    @Test
    @DisplayName(value="test that factory uses same client for all bindings")
    void testNoDuplicateClient() throws Exception {
        URI baseUri = URI.create("http://127.0.0.1:5000/");
        ClientTransportBinding httpBinding1 = (ClientTransportBinding)this.transportBindingFactory.createHttpBinding(baseUri.toString(), null);
        Object client1 = FieldUtils.readDeclaredField((Object)httpBinding1, (String)"client", (boolean)true);
        CommunicationLogContext ctx = new CommunicationLogContext("dummy");
        ClientTransportBinding httpBinding2 = (ClientTransportBinding)this.transportBindingFactory.createHttpBinding(baseUri.toString(), ctx);
        Object client2 = FieldUtils.readDeclaredField((Object)httpBinding2, (String)"client", (boolean)true);
        Assertions.assertNotNull((Object)client1);
        Assertions.assertSame((Object)client1, (Object)client2);
    }

    private SoapMessage createASoapMessage() {
        return this.soapMessageFactory.createSoapMessage(this.envelopeFactory.createEnvelope());
    }
}

