/*
 * Decompiled with CFR 0.152.
 */
package it.org.somda.sdc.dpws.soap;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import dpws_test_service.messages._2017._05._10.TestNotification;
import dpws_test_service.messages._2017._05._10.TestOperationRequest;
import it.org.somda.sdc.dpws.IntegrationTestUtil;
import it.org.somda.sdc.dpws.MockedUdpBindingModule;
import it.org.somda.sdc.dpws.soap.BasicPopulatedDevice;
import it.org.somda.sdc.dpws.soap.ClientPeer;
import it.org.somda.sdc.dpws.soap.Ssl;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.somda.sdc.dpws.crypto.CryptoSettings;
import org.somda.sdc.dpws.device.DeviceSettings;
import org.somda.sdc.dpws.guice.DefaultDpwsConfigModule;
import org.somda.sdc.dpws.service.HostedServiceProxy;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.NotificationObject;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wseventing.EventSourceDialectHandler;
import org.somda.sdc.dpws.soap.wseventing.GenericEventSource;
import org.somda.sdc.dpws.soap.wseventing.IndividualSubscriptionHandler;
import org.somda.sdc.dpws.soap.wseventing.SourceSubscriptionManager;
import org.somda.sdc.dpws.soap.wseventing.SubscribeResult;
import org.somda.sdc.dpws.soap.wseventing.SubscriptionManager;
import org.somda.sdc.dpws.soap.wseventing.factory.GenericEventSourceInterceptorFactory;
import org.somda.sdc.dpws.soap.wseventing.model.SubscriptionEnd;
import org.somda.sdc.dpws.soap.wseventing.model.WsEventingStatus;
import test.org.somda.common.LoggingTestWatcher;

@ExtendWith(value={LoggingTestWatcher.class})
class GenericFilterSubscriptionIT {
    private static final String FILTER_DIALECT = "urn:test:example";
    private static final Duration MAX_WAIT_TIME = Duration.ofMinutes(3L);
    private final IntegrationTestUtil IT = new IntegrationTestUtil();
    private final SoapUtil soapUtil = (SoapUtil)this.IT.getInjector().getInstance(SoapUtil.class);
    private final WsAddressingUtil wsaUtil = (WsAddressingUtil)this.IT.getInjector().getInstance(WsAddressingUtil.class);
    private BasicPopulatedDevice devicePeer;
    private GenericEventSource customEventSource;
    private ClientPeer clientPeer;
    private HostnameVerifier verifier;
    private SettableFuture<ImmutablePair<String, TestOperationRequest>> individualSubscription;
    private SettableFuture<String> individualSubscriptionEnd;

    GenericFilterSubscriptionIT() {
        IntegrationTestUtil.preferIpV4Usage();
    }

    @BeforeEach
    void setUp() {
        final CryptoSettings serverCryptoSettings = Ssl.setupServer();
        this.verifier = (HostnameVerifier)Mockito.mock(HostnameVerifier.class);
        Mockito.when((Object)this.verifier.verify(ArgumentMatchers.anyString(), (SSLSession)ArgumentMatchers.any())).thenReturn((Object)true);
        this.devicePeer = new BasicPopulatedDevice(new DeviceSettings(){
            final EndpointReferenceType epr;
            {
                this.epr = GenericFilterSubscriptionIT.this.wsaUtil.createEprWithAddress(GenericFilterSubscriptionIT.this.soapUtil.createUriFromUuid(UUID.randomUUID()));
            }

            public EndpointReferenceType getEndpointReference() {
                return this.epr;
            }

            public NetworkInterface getNetworkInterface() {
                try {
                    return NetworkInterface.getByInetAddress(InetAddress.getLoopbackAddress());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, new DefaultDpwsConfigModule(){

            public void customConfigure() {
                this.bind("Dpws.Crypto.Settings", CryptoSettings.class, serverCryptoSettings);
                this.bind("Dpws.EnableHttp", Boolean.class, false);
                this.bind("Dpws.EnableHttps", Boolean.class, true);
                this.bind("Dpws.Crypto.DeviceHostnameVerifier", HostnameVerifier.class, GenericFilterSubscriptionIT.this.verifier);
                this.bind("Dpws.Crypto.TlsEnabledVersions", String[].class, new String[]{"TLSv1.3"});
                this.bind("Dpws.Crypto.TlsEnabledCiphers", String[].class, new String[]{"TLS_AES_128_GCM_SHA256"});
            }
        }, new MockedUdpBindingModule());
        this.individualSubscription = SettableFuture.create();
        this.individualSubscriptionEnd = SettableFuture.create();
        this.customEventSource = ((GenericEventSourceInterceptorFactory)this.IT.getInjector().getInstance(GenericEventSourceInterceptorFactory.class)).create(FILTER_DIALECT, new IndividualSubscriptionHandler(){

            public void startStream(SourceSubscriptionManager subscriptionManager) {
                List filterObjects = subscriptionManager.getFilters();
                assert (!filterObjects.isEmpty());
                assert (filterObjects.get(0) instanceof TestOperationRequest);
                GenericFilterSubscriptionIT.this.individualSubscription.set((Object)ImmutablePair.of((Object)subscriptionManager.getSubscriptionId(), (Object)((TestOperationRequest)filterObjects.get(0))));
            }

            public void endStream(SourceSubscriptionManager subscriptionManager) {
                GenericFilterSubscriptionIT.this.individualSubscriptionEnd.set((Object)subscriptionManager.getSubscriptionId());
            }
        });
        this.devicePeer.getService1().registerEventSource((EventSourceDialectHandler)this.customEventSource);
        final CryptoSettings clientCryptoSettings = Ssl.setupClient();
        this.clientPeer = new ClientPeer(new DefaultDpwsConfigModule(){

            public void customConfigure() {
                this.bind("WsDiscovery.MaxWaitForProbeMatches", Duration.class, Duration.ofSeconds(MAX_WAIT_TIME.getSeconds() / 2L));
                this.bind("Dpws.Crypto.Settings", CryptoSettings.class, clientCryptoSettings);
                this.bind("SoapConfig.JaxbContextPath", String.class, "dpws_test_service.messages._2017._05._10");
                this.bind("Dpws.Crypto.TlsEnabledVersions", String[].class, new String[]{"TLSv1.3"});
                this.bind("Dpws.Crypto.TlsEnabledCiphers", String[].class, new String[]{"TLS_AES_128_GCM_SHA256"});
                this.bind("Dpws.EnableHttp", Boolean.class, false);
                this.bind("Dpws.EnableHttps", Boolean.class, true);
            }
        }, new MockedUdpBindingModule());
    }

    @AfterEach
    void tearDown() {
        this.devicePeer.stopAsync().awaitTerminated();
        this.clientPeer.stopAsync().awaitTerminated();
    }

    @Test
    void testGenericEventSourceSubscriptionWithIndividualDeliveryAndEndBySource() throws Exception {
        this.devicePeer.startAsync().awaitRunning();
        this.clientPeer.startAsync().awaitRunning();
        HostingServiceProxy hostingServiceProxy = (HostingServiceProxy)this.clientPeer.getClient().connect(this.devicePeer.getEprAddress()).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        int count = 5;
        final SettableFuture notificationFuture = SettableFuture.create();
        HostedServiceProxy srv1 = (HostedServiceProxy)hostingServiceProxy.getHostedServices().get("TestService1");
        TestOperationRequest filter = new TestOperationRequest();
        String expectedParam1 = "Test";
        int expectedParam2 = 100;
        filter.setParam1("Test");
        filter.setParam2(100);
        ListenableFuture subscribe = srv1.getEventSinkAccess().subscribe(FILTER_DIALECT, Collections.singletonList(filter), Duration.ofMinutes(1L), new Interceptor(){
            private final List<Object> receivedNotifications = new ArrayList<Object>();

            @MessageInterceptor(value="http://dpws-test-service/2017/05/10/TestPortType1/TestNotification")
            void onNotification(NotificationObject message) {
                GenericFilterSubscriptionIT.this.soapUtil.getBody(message.getNotification(), TestNotification.class).ifPresent(this.receivedNotifications::add);
                if (this.receivedNotifications.size() == 5) {
                    notificationFuture.set(this.receivedNotifications);
                }
            }

            @MessageInterceptor(value="http://schemas.xmlsoap.org/ws/2004/08/eventing/SubscriptionEnd")
            void onSubscriptionEnd(NotificationObject message) {
                GenericFilterSubscriptionIT.this.soapUtil.getBody(message.getNotification(), SubscriptionEnd.class).ifPresent(this.receivedNotifications::add);
                if (this.receivedNotifications.size() == 5) {
                    notificationFuture.set(this.receivedNotifications);
                }
            }
        });
        subscribe.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        Map activeSubs = this.devicePeer.getDevice().getActiveSubscriptions();
        Optional subscriptionManagerOpt = activeSubs.values().stream().findFirst();
        Assertions.assertTrue((boolean)subscriptionManagerOpt.isPresent());
        Assertions.assertEquals((Object)FILTER_DIALECT, (Object)((SubscriptionManager)subscriptionManagerOpt.get()).getFilterDialect());
        Optional subscriptionFilter = ((SubscriptionManager)subscriptionManagerOpt.get()).getFilters().stream().findFirst();
        Assertions.assertTrue((boolean)subscriptionFilter.isPresent());
        Assertions.assertInstanceOf(TestOperationRequest.class, subscriptionFilter.get());
        TestOperationRequest castSubscriptionFilter = (TestOperationRequest)subscriptionFilter.get();
        Assertions.assertEquals((Object)"Test", (Object)castSubscriptionFilter.getParam1());
        Assertions.assertEquals((int)100, (int)castSubscriptionFilter.getParam2());
        ImmutablePair incomingSubscription = (ImmutablePair)this.individualSubscription.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        Assertions.assertEquals((Object)"Test", (Object)((TestOperationRequest)incomingSubscription.right).getParam1());
        Assertions.assertEquals((int)100, (int)((TestOperationRequest)incomingSubscription.right).getParam2());
        for (int i = 0; i < 4; ++i) {
            TestNotification notification = new TestNotification();
            notification.setParam1("Test");
            notification.setParam2(100 + i);
            this.customEventSource.sendNotificationFor((String)incomingSubscription.left, "http://dpws-test-service/2017/05/10/TestPortType1/TestNotification", (Object)notification);
        }
        this.customEventSource.endSubscriptionFor((String)incomingSubscription.left);
        List notifications = (List)notificationFuture.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        Assertions.assertEquals((int)5, (int)notifications.size());
        for (int i = 0; i < 4; ++i) {
            Assertions.assertEquals((Object)"Test", (Object)((TestNotification)notifications.get(i)).getParam1());
            Assertions.assertEquals((int)(100 + i), (int)((TestNotification)notifications.get(i)).getParam2());
        }
        Assertions.assertInstanceOf(SubscriptionEnd.class, notifications.get(4));
    }

    @Test
    void testGenericEventSourceSubscriptionWithIndividualDeliveryAndEndBySink() throws Exception {
        this.devicePeer.startAsync().awaitRunning();
        this.clientPeer.startAsync().awaitRunning();
        HostingServiceProxy hostingServiceProxy = (HostingServiceProxy)this.clientPeer.getClient().connect(this.devicePeer.getEprAddress()).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        int count = 5;
        final SettableFuture notificationFuture = SettableFuture.create();
        HostedServiceProxy srv1 = (HostedServiceProxy)hostingServiceProxy.getHostedServices().get("TestService1");
        TestOperationRequest filter = new TestOperationRequest();
        String expectedParam1 = "Test";
        int expectedParam2 = 100;
        filter.setParam1("Test");
        filter.setParam2(100);
        ListenableFuture subscribe = srv1.getEventSinkAccess().subscribe(FILTER_DIALECT, Collections.singletonList(filter), Duration.ofMinutes(1L), new Interceptor(){
            private final List<TestNotification> receivedNotifications = new ArrayList<TestNotification>();

            @MessageInterceptor(value="http://dpws-test-service/2017/05/10/TestPortType1/TestNotification")
            void onNotification(NotificationObject message) {
                GenericFilterSubscriptionIT.this.soapUtil.getBody(message.getNotification(), TestNotification.class).ifPresent(this.receivedNotifications::add);
                if (this.receivedNotifications.size() == 5) {
                    notificationFuture.set(this.receivedNotifications);
                }
            }
        });
        SubscribeResult subscribeResult = (SubscribeResult)subscribe.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        ImmutablePair incomingSubscription = (ImmutablePair)this.individualSubscription.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        for (int i = 0; i < 5; ++i) {
            TestNotification notification = new TestNotification();
            notification.setParam1("Test");
            notification.setParam2(100 + i);
            this.customEventSource.sendNotificationFor((String)incomingSubscription.left, "http://dpws-test-service/2017/05/10/TestPortType1/TestNotification", (Object)notification);
        }
        srv1.getEventSinkAccess().unsubscribe(subscribeResult.getSubscriptionId());
        String incomingSubscriptionEnd = (String)this.individualSubscriptionEnd.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        Assertions.assertEquals((Object)incomingSubscription.left, (Object)incomingSubscriptionEnd);
    }

    @Test
    void testGenericEventSourceSubscriptionWithEndBySource() throws Exception {
        this.devicePeer.startAsync().awaitRunning();
        this.clientPeer.startAsync().awaitRunning();
        HostingServiceProxy hostingServiceProxy = (HostingServiceProxy)this.clientPeer.getClient().connect(this.devicePeer.getEprAddress()).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        int count = 5;
        final SettableFuture notificationFuture = SettableFuture.create();
        HostedServiceProxy srv1 = (HostedServiceProxy)hostingServiceProxy.getHostedServices().get("TestService1");
        TestOperationRequest filter = new TestOperationRequest();
        String expectedParam1 = "Test";
        int expectedParam2 = 100;
        filter.setParam1("Test");
        filter.setParam2(100);
        ListenableFuture subscribe = srv1.getEventSinkAccess().subscribe(FILTER_DIALECT, Collections.singletonList(filter), Duration.ofMinutes(1L), new Interceptor(){
            private final List<Object> receivedNotifications = new ArrayList<Object>();

            @MessageInterceptor(value="http://dpws-test-service/2017/05/10/TestPortType1/TestNotification")
            void onNotification(NotificationObject message) {
                GenericFilterSubscriptionIT.this.soapUtil.getBody(message.getNotification(), TestNotification.class).ifPresent(this.receivedNotifications::add);
                if (this.receivedNotifications.size() == 5) {
                    notificationFuture.set(this.receivedNotifications);
                }
            }

            @MessageInterceptor(value="http://schemas.xmlsoap.org/ws/2004/08/eventing/SubscriptionEnd")
            void onSubscriptionEnd(NotificationObject message) {
                GenericFilterSubscriptionIT.this.soapUtil.getBody(message.getNotification(), SubscriptionEnd.class).ifPresent(this.receivedNotifications::add);
                if (this.receivedNotifications.size() == 5) {
                    notificationFuture.set(this.receivedNotifications);
                }
            }
        });
        subscribe.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        for (int i = 0; i < 4; ++i) {
            TestNotification notification = new TestNotification();
            notification.setParam1("Test");
            notification.setParam2(100 + i);
            this.customEventSource.sendNotification("http://dpws-test-service/2017/05/10/TestPortType1/TestNotification", (Object)notification);
        }
        this.customEventSource.subscriptionEndToAll(WsEventingStatus.STATUS_SOURCE_CANCELLING);
        List notifications = (List)notificationFuture.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        Assertions.assertEquals((int)5, (int)notifications.size());
        for (int i = 0; i < 4; ++i) {
            Assertions.assertEquals((Object)"Test", (Object)((TestNotification)notifications.get(i)).getParam1());
            Assertions.assertEquals((int)(100 + i), (int)((TestNotification)notifications.get(i)).getParam2());
        }
        Assertions.assertInstanceOf(SubscriptionEnd.class, notifications.get(4));
    }

    @Test
    void testGenericEventSourceSubscriptionWithEndBySink() throws Exception {
        this.devicePeer.startAsync().awaitRunning();
        this.clientPeer.startAsync().awaitRunning();
        HostingServiceProxy hostingServiceProxy = (HostingServiceProxy)this.clientPeer.getClient().connect(this.devicePeer.getEprAddress()).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        int count = 5;
        final SettableFuture notificationFuture = SettableFuture.create();
        HostedServiceProxy srv1 = (HostedServiceProxy)hostingServiceProxy.getHostedServices().get("TestService1");
        TestOperationRequest filter = new TestOperationRequest();
        String expectedParam1 = "Test";
        int expectedParam2 = 100;
        filter.setParam1("Test");
        filter.setParam2(100);
        ListenableFuture subscribe = srv1.getEventSinkAccess().subscribe(FILTER_DIALECT, Collections.singletonList(filter), Duration.ofMinutes(1L), new Interceptor(){
            private final List<TestNotification> receivedNotifications = new ArrayList<TestNotification>();

            @MessageInterceptor(value="http://dpws-test-service/2017/05/10/TestPortType1/TestNotification")
            void onNotification(NotificationObject message) {
                GenericFilterSubscriptionIT.this.soapUtil.getBody(message.getNotification(), TestNotification.class).ifPresent(this.receivedNotifications::add);
                if (this.receivedNotifications.size() == 5) {
                    notificationFuture.set(this.receivedNotifications);
                }
            }
        });
        SubscribeResult subscribeResult = (SubscribeResult)subscribe.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        for (int i = 0; i < 5; ++i) {
            TestNotification notification = new TestNotification();
            notification.setParam1("Test");
            notification.setParam2(100 + i);
            this.customEventSource.sendNotification("http://dpws-test-service/2017/05/10/TestPortType1/TestNotification", (Object)notification);
        }
        List notifications = (List)notificationFuture.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        Assertions.assertEquals((int)5, (int)notifications.size());
        for (int i = 0; i < 5; ++i) {
            Assertions.assertEquals((Object)"Test", (Object)((TestNotification)notifications.get(i)).getParam1());
            Assertions.assertEquals((int)(100 + i), (int)((TestNotification)notifications.get(i)).getParam2());
        }
        srv1.getEventSinkAccess().unsubscribe(subscribeResult.getSubscriptionId()).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)this.customEventSource.getActiveSubscriptions().isEmpty());
    }
}

