/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.crypto;

import it.org.somda.sdc.dpws.soap.Ssl;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.somda.sdc.dpws.crypto.CachingCryptoSettings;
import org.somda.sdc.dpws.crypto.CryptoConfigurator;
import org.somda.sdc.dpws.crypto.CryptoSettings;

class CryptoConfiguratorTest {
    CryptoConfiguratorTest() {
    }

    @Test
    @DisplayName(value="Verifies that in case a CachingCryptoSettings is provided, it is used to cache context instances.")
    void testCache() throws Exception {
        CryptoConfigurator configurator = new CryptoConfigurator();
        CachingCryptoSettings mockSettings = (CachingCryptoSettings)Mockito.mock(CachingCryptoSettings.class);
        CryptoSettings innerData = Ssl.setupServer();
        Mockito.when((Object)mockSettings.getKeyStoreStream()).thenReturn((Object)innerData.getKeyStoreStream());
        Mockito.when((Object)mockSettings.getKeyStorePassword()).thenReturn((Object)innerData.getKeyStorePassword());
        Mockito.when((Object)mockSettings.getTrustStoreStream()).thenReturn((Object)innerData.getTrustStoreStream());
        Mockito.when((Object)mockSettings.getTrustStorePassword()).thenReturn((Object)innerData.getTrustStorePassword());
        Mockito.when((Object)mockSettings.getSslContext()).thenReturn(Optional.empty());
        SSLContext context = configurator.createSslContextFromCryptoConfig(mockSettings);
        ArgumentCaptor contextCaptor = ArgumentCaptor.forClass(SSLContext.class);
        ((CachingCryptoSettings)Mockito.verify((Object)mockSettings, (VerificationMode)Mockito.times((int)1))).setSslContext((SSLContext)contextCaptor.capture());
        ((CachingCryptoSettings)Mockito.verify((Object)mockSettings, (VerificationMode)Mockito.atLeast((int)1))).getKeyStoreStream();
        ((CachingCryptoSettings)Mockito.verify((Object)mockSettings, (VerificationMode)Mockito.atLeast((int)1))).getKeyStorePassword();
        ((CachingCryptoSettings)Mockito.verify((Object)mockSettings, (VerificationMode)Mockito.atLeast((int)1))).getTrustStoreStream();
        ((CachingCryptoSettings)Mockito.verify((Object)mockSettings, (VerificationMode)Mockito.atLeast((int)1))).getTrustStorePassword();
        Assertions.assertEquals((Object)context, (Object)contextCaptor.getValue());
        Mockito.clearInvocations((Object[])new CachingCryptoSettings[]{mockSettings});
        Mockito.when((Object)mockSettings.getSslContext()).thenReturn(Optional.of(context));
        SSLContext context2 = configurator.createSslContextFromCryptoConfig(mockSettings);
        ((CachingCryptoSettings)Mockito.verify((Object)mockSettings, (VerificationMode)Mockito.never())).setSslContext((SSLContext)contextCaptor.capture());
        ((CachingCryptoSettings)Mockito.verify((Object)mockSettings, (VerificationMode)Mockito.never())).getKeyStoreStream();
        ((CachingCryptoSettings)Mockito.verify((Object)mockSettings, (VerificationMode)Mockito.never())).getKeyStorePassword();
        ((CachingCryptoSettings)Mockito.verify((Object)mockSettings, (VerificationMode)Mockito.never())).getTrustStoreStream();
        ((CachingCryptoSettings)Mockito.verify((Object)mockSettings, (VerificationMode)Mockito.never())).getTrustStorePassword();
        Assertions.assertEquals((Object)context, (Object)context2);
    }
}

