/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.device.helper;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.io.CharStreams;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.device.helper.RequestResponseServerHttpHandler;
import org.somda.sdc.dpws.http.ContentType;
import org.somda.sdc.dpws.http.HttpException;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.HttpApplicationInfo;
import org.somda.sdc.dpws.soap.MarshallingService;
import org.somda.sdc.dpws.soap.RequestResponseServer;

class RequestResponseServerHttpHandlerTest
extends DpwsTest {
    private static final String DUMMY_TRANSACTION_ID = "0";
    private static final String DUMMY_REQUEST_URI = "someRequestUri";
    private Injector injector;
    private MarshallingService mockMarshalling;

    RequestResponseServerHttpHandlerTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.mockMarshalling = (MarshallingService)Mockito.mock(MarshallingService.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        final RequestResponseServer mockServer = (RequestResponseServer)Mockito.mock(RequestResponseServer.class);
        AbstractModule overrideModule = new AbstractModule(){

            protected void configure() {
                super.configure();
                this.bind(MarshallingService.class).toInstance((Object)RequestResponseServerHttpHandlerTest.this.mockMarshalling);
                this.bind(RequestResponseServer.class).toInstance((Object)mockServer);
            }
        };
        this.overrideBindings(overrideModule);
        super.setUp();
        this.injector = this.getInjector();
    }

    @Test
    @DisplayName(value="RequestResponseServerHttpHandler shall fail without a content-type")
    void testContentTypeMissing() {
        String expectedString = "The quick brown fox jumps over the lazy dog \u00fd \u2602";
        ArrayListMultimap headers = ArrayListMultimap.create();
        headers.put((Object)"Date", (Object)"tomorrow");
        RequestResponseServerHttpHandler reqResServer = (RequestResponseServerHttpHandler)this.injector.getInstance(RequestResponseServerHttpHandler.class);
        CommunicationContext mockContext = (CommunicationContext)Mockito.mock(CommunicationContext.class);
        HttpApplicationInfo applicationInfo = new HttpApplicationInfo((ListMultimap)headers, DUMMY_TRANSACTION_ID, DUMMY_REQUEST_URI);
        Mockito.when((Object)mockContext.getApplicationInfo()).thenReturn((Object)applicationInfo);
        ByteArrayInputStream requestStream = new ByteArrayInputStream("The quick brown fox jumps over the lazy dog \u00fd \u2602".getBytes(StandardCharsets.UTF_8));
        ByteArrayOutputStream responseStream = new ByteArrayOutputStream();
        HttpException error = (HttpException)Assertions.assertThrows(HttpException.class, () -> reqResServer.handle((InputStream)requestStream, (OutputStream)responseStream, mockContext));
        Assertions.assertTrue((boolean)error.getMessage().contains("Could not parse Content-Type header element"));
    }

    @Test
    @DisplayName(value="RequestResponseServerHttpHandler shall properly handle implicit latin1 encoding using text/xml")
    void testContentTypeEncodingCorrectTextXmlImplicit() throws Exception {
        String expectedString = "The quick brown fox jumps over the lazy dog \u00fd";
        ContentType.ContentTypes contentType = ContentType.ContentTypes.TEXT_XML;
        Assertions.assertNotNull((Object)contentType.getDefaultEncoding());
        ArrayListMultimap headers = ArrayListMultimap.create();
        headers.put((Object)"Date".toLowerCase(), (Object)"tomorrow");
        headers.put((Object)"Content-Type".toLowerCase(), (Object)contentType.getContentType());
        RequestResponseServerHttpHandler reqResServer = (RequestResponseServerHttpHandler)this.injector.getInstance(RequestResponseServerHttpHandler.class);
        CommunicationContext mockContext = (CommunicationContext)Mockito.mock(CommunicationContext.class);
        HttpApplicationInfo applicationInfo = new HttpApplicationInfo((ListMultimap)headers, DUMMY_TRANSACTION_ID, DUMMY_REQUEST_URI);
        Mockito.when((Object)mockContext.getApplicationInfo()).thenReturn((Object)applicationInfo);
        ByteArrayInputStream requestStream = new ByteArrayInputStream("The quick brown fox jumps over the lazy dog \u00fd".getBytes(contentType.getDefaultEncoding()));
        ByteArrayOutputStream responseStream = new ByteArrayOutputStream();
        reqResServer.handle((InputStream)requestStream, (OutputStream)responseStream, mockContext);
        ArgumentCaptor readerCaptor = ArgumentCaptor.forClass(Reader.class);
        ((MarshallingService)Mockito.verify((Object)this.mockMarshalling, (VerificationMode)Mockito.times((int)1))).unmarshal((Reader)readerCaptor.capture());
        Reader reader = (Reader)readerCaptor.getValue();
        String content = CharStreams.toString((Readable)reader);
        Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog \u00fd", (Object)content, (String)"Reader content does not match input");
    }

    @Test
    @DisplayName(value="RequestResponseServerHttpHandler shall properly handle explicit utf-16 encoding using text/xml")
    void testContentTypeEncodingCorrectTextXmlExplicitUtf8() throws Exception {
        String expectedString = "The quick brown fox jumps over the lazy dog \u00fd \u2602";
        ContentType.ContentTypes contentType = ContentType.ContentTypes.TEXT_XML;
        Charset encoding = StandardCharsets.UTF_16LE;
        ArrayListMultimap headers = ArrayListMultimap.create();
        headers.put((Object)"Date".toLowerCase(), (Object)"tomorrow");
        headers.put((Object)"Content-Type".toLowerCase(), (Object)(contentType.getContentType() + "; charset=" + encoding.displayName()));
        RequestResponseServerHttpHandler reqResServer = (RequestResponseServerHttpHandler)this.injector.getInstance(RequestResponseServerHttpHandler.class);
        CommunicationContext mockContext = (CommunicationContext)Mockito.mock(CommunicationContext.class);
        HttpApplicationInfo applicationInfo = new HttpApplicationInfo((ListMultimap)headers, DUMMY_TRANSACTION_ID, DUMMY_REQUEST_URI);
        Mockito.when((Object)mockContext.getApplicationInfo()).thenReturn((Object)applicationInfo);
        ByteArrayInputStream requestStream = new ByteArrayInputStream("The quick brown fox jumps over the lazy dog \u00fd \u2602".getBytes(encoding));
        ByteArrayOutputStream responseStream = new ByteArrayOutputStream();
        reqResServer.handle((InputStream)requestStream, (OutputStream)responseStream, mockContext);
        ArgumentCaptor readerCaptor = ArgumentCaptor.forClass(Reader.class);
        ((MarshallingService)Mockito.verify((Object)this.mockMarshalling, (VerificationMode)Mockito.times((int)1))).unmarshal((Reader)readerCaptor.capture());
        Reader reader = (Reader)readerCaptor.getValue();
        String content = CharStreams.toString((Readable)reader);
        Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog \u00fd \u2602", (Object)content, (String)"Reader content does not match input");
    }

    @Test
    @DisplayName(value="RequestResponseServerHttpHandler shall let JAXB handle encoding for application/xml")
    void testMarshallWithoutReader() throws Exception {
        String expectedString = "The quick brown fox jumps over the lazy dog \u00fd \u2602";
        ContentType.ContentTypes contentType = ContentType.ContentTypes.APPLICATION_XML;
        Charset encoding = StandardCharsets.UTF_8;
        ArrayListMultimap headers = ArrayListMultimap.create();
        headers.put((Object)"Date".toLowerCase(), (Object)"tomorrow");
        headers.put((Object)"Content-Type".toLowerCase(), (Object)contentType.getContentType());
        RequestResponseServerHttpHandler reqResServer = (RequestResponseServerHttpHandler)this.injector.getInstance(RequestResponseServerHttpHandler.class);
        CommunicationContext mockContext = (CommunicationContext)Mockito.mock(CommunicationContext.class);
        HttpApplicationInfo applicationInfo = new HttpApplicationInfo((ListMultimap)headers, DUMMY_TRANSACTION_ID, DUMMY_REQUEST_URI);
        Mockito.when((Object)mockContext.getApplicationInfo()).thenReturn((Object)applicationInfo);
        ByteArrayInputStream requestStream = new ByteArrayInputStream("The quick brown fox jumps over the lazy dog \u00fd \u2602".getBytes(encoding));
        ByteArrayOutputStream responseStream = new ByteArrayOutputStream();
        reqResServer.handle((InputStream)requestStream, (OutputStream)responseStream, mockContext);
        ArgumentCaptor inputStreamCaptor = ArgumentCaptor.forClass(InputStream.class);
        ((MarshallingService)Mockito.verify((Object)this.mockMarshalling, (VerificationMode)Mockito.times((int)1))).unmarshal((InputStream)inputStreamCaptor.capture());
        ((MarshallingService)Mockito.verify((Object)this.mockMarshalling, (VerificationMode)Mockito.times((int)0))).unmarshal((Reader)ArgumentMatchers.isA(Reader.class));
        InputStream inputStream = (InputStream)inputStreamCaptor.getValue();
        String content = new String(inputStream.readAllBytes(), encoding);
        Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog \u00fd \u2602", (Object)content, (String)"InputStream passed for marshalling was modified");
    }
}

