/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap;

import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.helper.JaxbMarshalling;
import org.somda.sdc.dpws.soap.NotificationSource;
import org.somda.sdc.dpws.soap.SoapMarshalling;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.factory.NotificationSourceFactory;
import org.somda.sdc.dpws.soap.factory.SoapMessageFactory;
import org.somda.sdc.dpws.soap.interception.Direction;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.NotificationObject;
import org.somda.sdc.dpws.soap.interception.RequestObject;
import org.somda.sdc.dpws.soap.model.Envelope;

class NotificationSourceImplTest
extends DpwsTest {
    private List<String> dispatchedSequence;

    NotificationSourceImplTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        ((JaxbMarshalling)this.getInjector().getInstance(JaxbMarshalling.class)).startAsync().awaitRunning();
        ((SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class)).startAsync().awaitRunning();
        this.dispatchedSequence = new ArrayList<String>();
    }

    @Test
    void sendNotification() throws Exception {
        SoapMarshalling unmarshaller = (SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class);
        Envelope soapEnv = unmarshaller.unmarshal(this.getClass().getResourceAsStream("soap-envelope.xml"));
        SoapMessageFactory soapMessageFactory = (SoapMessageFactory)this.getInjector().getInstance(SoapMessageFactory.class);
        SoapMessage notification = soapMessageFactory.createSoapMessage(soapEnv);
        NotificationSourceFactory clientFactory = (NotificationSourceFactory)this.getInjector().getInstance(NotificationSourceFactory.class);
        NotificationSource nSource = clientFactory.createNotificationSource(not -> this.dispatchedSequence.add("NETWORK"));
        nSource.register(new Interceptor(){

            @MessageInterceptor(direction=Direction.NOTIFICATION)
            void onDelete(NotificationObject nInfo) {
                NotificationSourceImplTest.this.dispatchedSequence.add("NOTIFICATION(MAX)");
            }
        });
        nSource.register(new Interceptor(){

            @MessageInterceptor(direction=Direction.NOTIFICATION, sequenceNumber=5)
            void onDelete(NotificationObject nInfo) {
                NotificationSourceImplTest.this.dispatchedSequence.add("NOTIFICATION(5)");
            }
        });
        nSource.register(new Interceptor(){

            @MessageInterceptor(value="http://example.com/fabrikam/mail/Delete", direction=Direction.NOTIFICATION)
            void onDelete(NotificationObject nInfo) {
                NotificationSourceImplTest.this.dispatchedSequence.add("NOTIFICATION(ACTION, MAX)");
            }
        });
        nSource.register(new Interceptor(){

            @MessageInterceptor(value="http://example.com/fabrikam/mail/Delete", direction=Direction.NOTIFICATION)
            void onDelete() {
                NotificationSourceImplTest.this.dispatchedSequence.add("INVALID NOTIFICATION(ACTION, MAX)");
            }
        });
        nSource.register(new Interceptor(){

            @MessageInterceptor(value="http://example.com/fabrikam/mail/Delete", direction=Direction.NOTIFICATION)
            void onDelete(RequestObject rInfo) {
                NotificationSourceImplTest.this.dispatchedSequence.add("INVALID NOTIFICATION(ACTION, MAX)");
            }
        });
        nSource.register(new Interceptor(){

            @MessageInterceptor(value="http://example.com/fabrikam/mail/Delete", direction=Direction.REQUEST)
            void onDelete(NotificationObject nInfo) {
                NotificationSourceImplTest.this.dispatchedSequence.add("INVALID NOTIFICATION(ACTION, MAX)");
            }
        });
        nSource.sendNotification(notification);
        Assertions.assertEquals((int)4, (int)this.dispatchedSequence.size());
        Assertions.assertEquals((Object)"NOTIFICATION(5)", (Object)this.dispatchedSequence.get(0));
        Assertions.assertEquals((Object)"NOTIFICATION(MAX)", (Object)this.dispatchedSequence.get(1));
        Assertions.assertEquals((Object)"NOTIFICATION(ACTION, MAX)", (Object)this.dispatchedSequence.get(2));
        Assertions.assertEquals((Object)"NETWORK", (Object)this.dispatchedSequence.get(3));
    }
}

