/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.wsdl;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.util.concurrent.Futures;
import com.google.inject.AbstractModule;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.xml.bind.JAXBElement;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.helper.JaxbMarshalling;
import org.somda.sdc.dpws.http.ContentType;
import org.somda.sdc.dpws.http.HttpClient;
import org.somda.sdc.dpws.http.HttpResponse;
import org.somda.sdc.dpws.http.factory.HttpClientFactory;
import org.somda.sdc.dpws.soap.RequestResponseClient;
import org.somda.sdc.dpws.soap.SoapMarshalling;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.model.Envelope;
import org.somda.sdc.dpws.soap.wsaddressing.model.ReferenceParametersType;
import org.somda.sdc.dpws.soap.wsmetadataexchange.model.Metadata;
import org.somda.sdc.dpws.soap.wstransfer.TransferGetClient;
import org.somda.sdc.dpws.wsdl.WsdlMarshalling;
import org.somda.sdc.dpws.wsdl.WsdlRetriever;

class WsdlRetrieverTest
extends DpwsTest {
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(10L);
    private static final String METADATA_TEMPLATE;
    private static final String METADATA_SECTION_WSDL = "<mex:MetadataSection Dialect='http://schemas.xmlsoap.org/wsdl/'>%s</mex:MetadataSection>";
    private static final String METADATA_WSDL_LOCATION = "<mex:Location>%s</mex:Location>";
    private static final String METADATA_REFERENCE_ADDRESS = "<mex:MetadataReference><wsa10:Address>%s</wsa10:Address><wsa10:ReferenceParameters><wse:Identifier>%s</wse:Identifier></wsa10:ReferenceParameters></mex:MetadataReference>";
    private static final String METADATA_REFERENCE_ADDRESS_NO_REF_PARM = "<mex:MetadataReference><wsa10:Address>%s</wsa10:Address></mex:MetadataReference>";
    private SoapMarshalling marshalling;
    private WsdlRetriever testClass;
    private WsdlMarshalling wsdlMarshalling;
    private JaxbMarshalling baseMarshalling;
    private HttpClient mockHttpClient;
    private TransferGetClient mockTransferGetClient;
    private SoapUtil soapUtil;

    WsdlRetrieverTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        final HttpClientFactory mockFactory = (HttpClientFactory)Mockito.mock(HttpClientFactory.class);
        this.mockTransferGetClient = (TransferGetClient)Mockito.mock(TransferGetClient.class);
        AbstractModule override = new AbstractModule(){

            protected void configure() {
                super.configure();
                this.bind(HttpClientFactory.class).toInstance((Object)mockFactory);
                this.bind(TransferGetClient.class).toInstance((Object)WsdlRetrieverTest.this.mockTransferGetClient);
            }
        };
        this.overrideBindings(override);
        super.setUp();
        this.mockHttpClient = (HttpClient)Mockito.mock(HttpClient.class);
        Mockito.when((Object)mockFactory.createHttpClient()).thenReturn((Object)this.mockHttpClient);
        this.baseMarshalling = (JaxbMarshalling)this.getInjector().getInstance(JaxbMarshalling.class);
        this.baseMarshalling.startAsync().awaitRunning(DEFAULT_TIMEOUT);
        this.marshalling = (SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class);
        this.marshalling.startAsync().awaitRunning(DEFAULT_TIMEOUT);
        this.wsdlMarshalling = (WsdlMarshalling)this.getInjector().getInstance(WsdlMarshalling.class);
        this.wsdlMarshalling.startAsync().awaitRunning(DEFAULT_TIMEOUT);
        this.soapUtil = (SoapUtil)this.getInjector().getInstance(SoapUtil.class);
        this.testClass = (WsdlRetriever)this.getInjector().getInstance(WsdlRetriever.class);
    }

    @AfterEach
    void tearDown() throws TimeoutException {
        this.marshalling.stopAsync().awaitTerminated(DEFAULT_TIMEOUT);
        this.wsdlMarshalling.stopAsync().awaitTerminated(DEFAULT_TIMEOUT);
        this.baseMarshalling.stopAsync().awaitTerminated(DEFAULT_TIMEOUT);
    }

    @Test
    void testWsdlEmbedded() throws Exception {
        Envelope message;
        try (InputStream messageStream = WsdlRetrieverTest.class.getResourceAsStream("WsdlRetrieverTest/MetadataWsdlEmbedded.xml");){
            message = this.marshalling.unmarshal(messageStream);
        }
        Metadata metadata = (Metadata)message.getBody().getAny().get(0);
        List wsdls = this.testClass.retrieveWsdlFromMetadata(metadata);
        Assertions.assertEquals((int)1, (int)wsdls.size());
        String wsdl = (String)wsdls.get(0);
        Assertions.assertNotNull((Object)wsdl);
        Assertions.assertFalse((boolean)wsdl.isBlank());
        this.extractWsdl(wsdl);
    }

    @Test
    void testWsdlLocation() throws Exception {
        String testResponseContent = "Huhuhihihaha";
        String testLocation = "ftp://some.place/somewhere?overtherainbow";
        HttpResponse testResponse = (HttpResponse)Mockito.mock(HttpResponse.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)testResponse.getBody()).thenReturn((Object)testResponseContent.getBytes(StandardCharsets.UTF_8));
        Mockito.when((Object)this.mockHttpClient.sendGet((String)ArgumentMatchers.any())).thenReturn((Object)testResponse);
        String locationMessage = String.format(METADATA_TEMPLATE, String.format(METADATA_SECTION_WSDL, String.format(METADATA_WSDL_LOCATION, testLocation)));
        Envelope message = this.marshalling.unmarshal((InputStream)new ByteArrayInputStream(locationMessage.getBytes(StandardCharsets.UTF_8)));
        Metadata metadata = (Metadata)message.getBody().getAny().get(0);
        List wsdl = this.testClass.retrieveWsdlFromMetadata(metadata);
        Assertions.assertEquals(List.of(testResponseContent), (Object)wsdl);
        ArgumentCaptor captor = ArgumentCaptor.forClass(String.class);
        ((HttpClient)Mockito.verify((Object)this.mockHttpClient)).sendGet((String)captor.capture());
        Assertions.assertEquals((Object)testLocation, (Object)captor.getValue());
    }

    @Test
    void testLocationEprRequest() throws Exception {
        SoapMessage embeddedWsdlMessage;
        String testLocation = "http://mahnamahna.dododododo";
        String testIdentifier = "Rubber duckie you're the one, you make bath time lots of fun";
        String referenceMessageData = String.format(METADATA_TEMPLATE, String.format(METADATA_SECTION_WSDL, String.format(METADATA_REFERENCE_ADDRESS, testLocation, testIdentifier)));
        Envelope eprMessage = this.marshalling.unmarshal((InputStream)new ByteArrayInputStream(referenceMessageData.getBytes(StandardCharsets.UTF_8)));
        try (InputStream messageStream = WsdlRetrieverTest.class.getResourceAsStream("WsdlRetrieverTest/MetadataWsdlEmbedded.xml");){
            embeddedWsdlMessage = this.soapUtil.createMessage(this.marshalling.unmarshal(messageStream));
        }
        Mockito.when((Object)this.mockTransferGetClient.sendTransferGet((RequestResponseClient)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (ReferenceParametersType)ArgumentMatchers.any())).thenReturn((Object)Futures.immediateFuture((Object)embeddedWsdlMessage));
        Metadata metadata = (Metadata)eprMessage.getBody().getAny().get(0);
        List wsdls = this.testClass.retrieveWsdlFromMetadata(metadata);
        Assertions.assertEquals((int)1, (int)wsdls.size());
        String wsdl = (String)wsdls.get(0);
        Assertions.assertNotNull((Object)wsdl);
        Assertions.assertFalse((boolean)wsdl.isBlank());
        this.extractWsdl(wsdl);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ReferenceParametersType.class);
        ((TransferGetClient)Mockito.verify((Object)this.mockTransferGetClient)).sendTransferGet((RequestResponseClient)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (ReferenceParametersType)captor.capture());
        Object identifier = ((ReferenceParametersType)captor.getValue()).getAny().get(0);
        JAXBElement castIdentifier = (JAXBElement)identifier;
        Assertions.assertEquals((Object)testIdentifier, (Object)castIdentifier.getValue());
    }

    @Test
    void testLocationEprRequestNoRefParm() throws Exception {
        SoapMessage embeddedWsdlMessage;
        String testLocation = "http://mahnamahna.dododododo";
        String referenceMessageData = String.format(METADATA_TEMPLATE, String.format(METADATA_SECTION_WSDL, String.format(METADATA_REFERENCE_ADDRESS_NO_REF_PARM, testLocation)));
        Envelope eprMessage = this.marshalling.unmarshal((InputStream)new ByteArrayInputStream(referenceMessageData.getBytes(StandardCharsets.UTF_8)));
        try (InputStream messageStream = WsdlRetrieverTest.class.getResourceAsStream("WsdlRetrieverTest/MetadataWsdlEmbedded.xml");){
            embeddedWsdlMessage = this.soapUtil.createMessage(this.marshalling.unmarshal(messageStream));
        }
        Mockito.when((Object)this.mockTransferGetClient.sendTransferGet((RequestResponseClient)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)Futures.immediateFuture((Object)embeddedWsdlMessage));
        Metadata metadata = (Metadata)eprMessage.getBody().getAny().get(0);
        List wsdls = this.testClass.retrieveWsdlFromMetadata(metadata);
        Assertions.assertEquals((int)1, (int)wsdls.size());
        String wsdl = (String)wsdls.get(0);
        Assertions.assertNotNull((Object)wsdl);
        Assertions.assertFalse((boolean)wsdl.isBlank());
        this.extractWsdl(wsdl);
    }

    @Test
    void testConvertResponseToStringHttpHeader() {
        String testString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><dang>\u00e5</dang>";
        Charset charset = StandardCharsets.UTF_16LE;
        ArrayListMultimap headers = ArrayListMultimap.create();
        headers.put((Object)"Content-Type".toLowerCase(), (Object)("text/xml; charset=" + charset.displayName()));
        HttpResponse response = new HttpResponse(200, testString.getBytes(charset), (ListMultimap)headers);
        String result = this.testClass.convertResponseToString(response);
        Assertions.assertEquals((Object)testString, (Object)result);
        charset = StandardCharsets.UTF_8;
        headers = ArrayListMultimap.create();
        headers.put((Object)"Content-Type".toLowerCase(), (Object)("text/xml; charset=" + charset.displayName()));
        response = new HttpResponse(200, testString.getBytes(charset), (ListMultimap)headers);
        result = this.testClass.convertResponseToString(response);
        Assertions.assertEquals((Object)testString, (Object)result);
        charset = StandardCharsets.ISO_8859_1;
        headers = ArrayListMultimap.create();
        headers.put((Object)"Content-Type".toLowerCase(), (Object)"text/xml");
        response = new HttpResponse(200, testString.getBytes(charset), (ListMultimap)headers);
        result = this.testClass.convertResponseToString(response);
        Assertions.assertEquals((Object)testString, (Object)result);
    }

    @Test
    void testConvertResponseToStringProlog() {
        String testString = "<?xml version=\"1.0\" encoding=\"UTF-16LE\"?><dang>\u00e5</dang>";
        Charset charset = StandardCharsets.UTF_16LE;
        ArrayListMultimap headers = ArrayListMultimap.create();
        headers.put((Object)"Content-Type".toLowerCase(), (Object)"application/xml");
        HttpResponse response = new HttpResponse(200, testString.getBytes(charset), (ListMultimap)headers);
        String result = this.testClass.convertResponseToString(response);
        Assertions.assertEquals((Object)testString, (Object)result);
        testString = "<?xml version=\"1.0\" encoding=\"UTF-16BE\"?><dang>\u00e5</dang>";
        charset = StandardCharsets.UTF_16BE;
        headers = ArrayListMultimap.create();
        headers.put((Object)"Content-Type".toLowerCase(), (Object)"application/xml");
        response = new HttpResponse(200, testString.getBytes(charset), (ListMultimap)headers);
        result = this.testClass.convertResponseToString(response);
        Assertions.assertEquals((Object)testString, (Object)result);
        testString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><dang>\u00e5</dang>";
        charset = StandardCharsets.UTF_8;
        headers = ArrayListMultimap.create();
        headers.put((Object)"Content-Type".toLowerCase(), (Object)"application/xml");
        response = new HttpResponse(200, testString.getBytes(charset), (ListMultimap)headers);
        result = this.testClass.convertResponseToString(response);
        Assertions.assertEquals((Object)testString, (Object)result);
        testString = "<dang>\u2602</dang>";
        ContentType.ContentTypes contentType = ContentType.ContentTypes.APPLICATION_XML;
        Assertions.assertNull((Object)contentType.getDefaultEncoding());
        Charset charset2 = StandardCharsets.UTF_8;
        ArrayListMultimap headers2 = ArrayListMultimap.create();
        headers2.put((Object)"Content-Type".toLowerCase(), (Object)contentType.getContentType());
        HttpResponse response2 = new HttpResponse(200, testString.getBytes(charset2), (ListMultimap)headers2);
        String result2 = this.testClass.convertResponseToString(response2);
        Assertions.assertEquals((Object)testString, (Object)result2);
    }

    private void extractWsdl(String wsdlString) throws Exception {
        this.wsdlMarshalling.unmarshal((InputStream)new ByteArrayInputStream(wsdlString.getBytes(StandardCharsets.UTF_8)));
    }

    static {
        try (InputStream stream = WsdlRetrieverTest.class.getResourceAsStream("WsdlRetrieverTest/MetadataWsdlTemplate.xml");){
            METADATA_TEMPLATE = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

