/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import org.somda.sdc.dpws.model.LocalizedStringType;
import org.somda.sdc.dpws.model.ObjectFactory;

public class LocalizedStringsBuilder {
    private static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    private static final String XML_LANG = "lang";
    private final ObjectFactory objectFactory = new ObjectFactory();
    private final List<LocalizedStringType> localizedStringTypes = new ArrayList<LocalizedStringType>(3);

    public LocalizedStringsBuilder() {
    }

    public LocalizedStringsBuilder(String text) {
        this(null, text);
    }

    public LocalizedStringsBuilder(@Nullable String locale, String text) {
        this();
        this.add(locale, text);
    }

    public LocalizedStringsBuilder add(String text) {
        return this.add(null, text);
    }

    public LocalizedStringsBuilder add(@Nullable String lang, String text) {
        LocalizedStringType localizedStringType = this.objectFactory.createLocalizedStringType();
        Optional.ofNullable(lang).ifPresent(s -> localizedStringType.getOtherAttributes().put(new QName(XML_NAMESPACE, XML_LANG), s));
        localizedStringType.setValue(text);
        this.localizedStringTypes.add(localizedStringType);
        return this;
    }

    public List<LocalizedStringType> get() {
        return new ArrayList<LocalizedStringType>(this.localizedStringTypes);
    }

    public LocalizedStringsBuilder clear() {
        this.localizedStringTypes.clear();
        return this;
    }
}

