/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.helper;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.somda.sdc.dpws.soap.CommunicationContext;

public class CommunicationLogFileName {
    private static final String SEPARATOR = "_";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH-mm-ss-SSS");

    public static String create(String direction, CommunicationContext communicationContext) {
        String destAddr = communicationContext.getTransportInfo().getRemoteAddress().orElse("[unk-addr]");
        Integer destPort = communicationContext.getTransportInfo().getRemotePort().orElse(-1);
        LocalTime date = LocalTime.now();
        return System.nanoTime() + SEPARATOR + date.format(DATE_TIME_FORMATTER) + SEPARATOR + direction + SEPARATOR + destAddr + SEPARATOR + destPort;
    }

    public static String append(String prefix, String appendix) {
        return prefix + SEPARATOR + appendix;
    }

    public static String appendSoapSuffix(String name) {
        return name + ".xml";
    }

    public static String appendHttpHeaderSuffix(String name) {
        return name + ".txt";
    }
}

