/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.http.apache;

import com.google.common.collect.ListMultimap;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.net.SocketException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.http.HttpClient;
import org.somda.sdc.dpws.http.HttpResponse;
import org.somda.sdc.dpws.http.apache.helper.ApacheClientHelper;
import org.somda.sdc.dpws.soap.exception.TransportException;

public class ApacheHttpClient
implements HttpClient {
    private static final Logger LOG = LogManager.getLogger();
    private final org.apache.http.client.HttpClient client;
    private final Logger instanceLogger;

    @AssistedInject
    ApacheHttpClient(@Assisted org.apache.http.client.HttpClient client, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.client = client;
    }

    @Override
    public HttpResponse sendGet(String url) throws TransportException {
        HttpGet get = new HttpGet(url);
        this.instanceLogger.debug("Sending GET request to {}", (Object)url);
        org.apache.http.HttpResponse response = this.executeRequest(this.client, (HttpRequestBase)get, url);
        return this.parseResponse(response, url);
    }

    private HttpResponse parseResponse(org.apache.http.HttpResponse response, String url) throws TransportException {
        byte[] content;
        int statusCode = response.getStatusLine().getStatusCode();
        try {
            content = response.getEntity().getContent().readAllBytes();
        }
        catch (IOException e) {
            this.instanceLogger.error("Error while reading response from {}. Message: {}", (Object)url, (Object)e.getMessage());
            this.instanceLogger.trace("Error while reading response from {}", (Object)url, (Object)e);
            throw new TransportException("Error while reading response", e);
        }
        ListMultimap<String, String> headers = ApacheClientHelper.allHeadersToMultimap(response.getAllHeaders());
        try {
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            this.instanceLogger.error("Error while consuming response entity from {}. Message: {}", (Object)url, (Object)e.getMessage());
            this.instanceLogger.trace("Error while consuming response entity from {}", (Object)url, (Object)e);
            throw new TransportException("Error while consuming response entity", e);
        }
        return new HttpResponse(statusCode, content, headers);
    }

    private org.apache.http.HttpResponse executeRequest(org.apache.http.client.HttpClient client, HttpRequestBase request, String endpoint) throws TransportException {
        try {
            return client.execute((HttpUriRequest)request);
        }
        catch (SocketException e) {
            this.instanceLogger.error("Unexpected SocketException on request to {}. Message: {}", (Object)endpoint, (Object)e.getMessage());
            this.instanceLogger.trace("Unexpected SocketException on request to {}", (Object)endpoint, (Object)e);
            throw new TransportException("Unexpected SocketException on request", e);
        }
        catch (IOException e) {
            this.instanceLogger.error("Unexpected IOException on request to {}. Message: {}", (Object)endpoint, (Object)e.getMessage());
            this.instanceLogger.trace("Unexpected IOException on request to {}", (Object)endpoint, (Object)e);
            throw new TransportException("Unexpected IOException on request", e);
        }
    }
}

