/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.factory;

import com.google.inject.Inject;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import org.somda.sdc.dpws.soap.SoapConstants;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.model.Detail;
import org.somda.sdc.dpws.soap.model.Fault;
import org.somda.sdc.dpws.soap.model.Faultcode;
import org.somda.sdc.dpws.soap.model.Faultreason;
import org.somda.sdc.dpws.soap.model.ObjectFactory;
import org.somda.sdc.dpws.soap.model.Reasontext;
import org.somda.sdc.dpws.soap.model.Subcode;

public class SoapFaultFactory {
    private final ObjectFactory soapFactory;
    private final SoapUtil soapUtil;

    @Inject
    SoapFaultFactory(ObjectFactory soapFactory, SoapUtil soapUtil) {
        this.soapFactory = soapFactory;
        this.soapUtil = soapUtil;
    }

    public SoapMessage createFault(String actionUri, QName code, QName subcode, String reasonText, @Nullable Object detail) {
        Subcode scObj = new Subcode();
        scObj.setValue(subcode);
        Faultcode fcObj = new Faultcode();
        fcObj.setValue(code);
        fcObj.setSubcode(scObj);
        Reasontext rtObj = new Reasontext();
        rtObj.setValue(reasonText);
        rtObj.setLang("en");
        ArrayList<Reasontext> rtListObj = new ArrayList<Reasontext>();
        rtListObj.add(rtObj);
        Faultreason frObj = new Faultreason();
        frObj.setText(rtListObj);
        Fault f = new Fault();
        f.setCode(fcObj);
        f.setReason(frObj);
        if (detail != null) {
            ArrayList<Object> anyObjList = new ArrayList<Object>();
            anyObjList.add(detail);
            Detail dObj = new Detail();
            dObj.setAny(anyObjList);
            f.setDetail(dObj);
        }
        return this.soapUtil.createMessage(actionUri, this.soapFactory.createFault(f));
    }

    public SoapMessage createFault(String actionUri, QName code, QName subcode, String reasonText) {
        return this.createFault(actionUri, code, subcode, reasonText, null);
    }

    public SoapMessage createFault(String actionUri, QName code, QName subcode) {
        return this.createFault(actionUri, code, subcode, "", null);
    }

    public SoapMessage createReceiverFault(String reasonText) {
        return this.createFault("http://www.w3.org/2005/08/addressing/fault", SoapConstants.RECEIVER, SoapConstants.DEFAULT_SUBCODE, reasonText);
    }

    public SoapMessage createSenderFault(String reasonText) {
        return this.createFault("http://www.w3.org/2005/08/addressing/fault", SoapConstants.SENDER, SoapConstants.DEFAULT_SUBCODE, reasonText);
    }
}

