/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.interception;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.soap.interception.Direction;
import org.somda.sdc.dpws.soap.interception.InterceptorCallbackType;
import org.somda.sdc.dpws.soap.interception.InterceptorException;
import org.somda.sdc.dpws.soap.interception.InterceptorInfo;
import org.somda.sdc.dpws.soap.interception.InterceptorRegistry;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;

class InterceptorProcessor {
    private static final Logger LOG = LogManager.getLogger(InterceptorProcessor.class);
    private final Logger instanceLogger;

    @Inject
    InterceptorProcessor(@Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
    }

    void dispatch(Direction direction, InterceptorRegistry interceptorRegistry, @Nullable String action, InterceptorCallbackType callbackData) throws InterceptorException {
        if (action == null) {
            this.instanceLogger.debug("Try to dispatch without action, cancel");
            return;
        }
        this.invokeInterceptors(direction, callbackData, interceptorRegistry.getDefaultInterceptors());
        List<InterceptorInfo> interceptors = interceptorRegistry.getInterceptors(action);
        this.invokeInterceptors(direction, callbackData, interceptors);
    }

    private void invokeInterceptors(Direction direction, InterceptorCallbackType callbackParam, Collection<InterceptorInfo> interceptors) throws InterceptorException {
        for (InterceptorInfo interceptorInfo : interceptors) {
            Method callbackMethod = interceptorInfo.getCallbackMethod();
            try {
                Direction directionFromAnnotation;
                if (callbackMethod.getParameterCount() != 1 || !callbackMethod.getParameterTypes()[0].isAssignableFrom(callbackParam.getClass()) || (directionFromAnnotation = callbackMethod.getDeclaredAnnotation(MessageInterceptor.class).direction()) != Direction.ANY && direction != directionFromAnnotation) continue;
                callbackMethod.invoke((Object)interceptorInfo.getCallbackObject(), callbackParam);
            }
            catch (IllegalAccessException e) {
                this.instanceLogger.warn(e.getMessage());
                this.instanceLogger.trace("Error while calling interceptor", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                this.instanceLogger.trace("Error while calling interceptor", (Throwable)e);
                throw new InterceptorException("Exception thrown by interceptor " + interceptorInfo.getCallbackObject().toString(), interceptorInfo.getCallbackObject(), e.getTargetException());
            }
        }
    }
}

