/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wsaddressing.factory;

import com.google.inject.Inject;
import javax.xml.namespace.QName;
import org.somda.sdc.dpws.soap.SoapConstants;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.factory.SoapFaultFactory;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingConstants;

public class WsAddressingFaultFactory {
    private final SoapFaultFactory soapFaultFactory;

    @Inject
    WsAddressingFaultFactory(SoapFaultFactory soapFaultFactory) {
        this.soapFaultFactory = soapFaultFactory;
    }

    public SoapMessage createActionNotSupported(String action) {
        return this.soapFaultFactory.createFault("http://www.w3.org/2005/08/addressing/fault", SoapConstants.RECEIVER, WsAddressingConstants.ACTION_NOT_SUPPORTED, String.format("The %s cannot be processed at the receiver", action), action);
    }

    public SoapMessage createMessageInformationHeaderRequired(QName missingHeaderQName) {
        return this.soapFaultFactory.createFault("http://www.w3.org/2005/08/addressing/fault", SoapConstants.RECEIVER, WsAddressingConstants.MESSAGE_ADDRESSING_HEADER_REQUIRED, "A required header representing a Message Addressing Property is not present", missingHeaderQName.toString());
    }
}

