/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wsdiscovery;

import com.google.common.collect.EvictingQueue;
import com.google.common.eventbus.EventBus;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.util.ExecutorWrapperService;
import org.somda.sdc.dpws.guice.WsDiscovery;
import org.somda.sdc.dpws.soap.NotificationSource;
import org.somda.sdc.dpws.soap.RequestResponseClient;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.interception.InterceptorException;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.NotificationObject;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wsdiscovery.HelloByeAndProbeMatchesObserver;
import org.somda.sdc.dpws.soap.wsdiscovery.MatchBy;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryClient;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryUtil;
import org.somda.sdc.dpws.soap.wsdiscovery.event.ByeMessage;
import org.somda.sdc.dpws.soap.wsdiscovery.event.HelloMessage;
import org.somda.sdc.dpws.soap.wsdiscovery.event.ProbeMatchesMessage;
import org.somda.sdc.dpws.soap.wsdiscovery.event.ProbeTimeoutMessage;
import org.somda.sdc.dpws.soap.wsdiscovery.model.AppSequenceType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ByeType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.HelloType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ObjectFactory;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ProbeMatchesType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ProbeType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ResolveMatchesType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ResolveType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ScopesType;

public class WsDiscoveryClientInterceptor
implements WsDiscoveryClient {
    private static final Logger LOG = LogManager.getLogger(WsDiscoveryClientInterceptor.class);
    private final Duration maxWaitForProbeMatches;
    private final Duration maxWaitForResolveMatches;
    private final Integer probeMatchesBufferSize;
    private final Integer resolveMatchesBufferSize;
    private final WsDiscoveryUtil wsdUtil;
    private final UnsignedInteger instanceId;
    private final ExecutorWrapperService<ListeningExecutorService> executorService;
    private final NotificationSource notificationSource;
    private final ObjectFactory wsdFactory;
    private final SoapUtil soapUtil;
    private EvictingQueue<SoapMessage> probeMatchesBuffer;
    private EvictingQueue<SoapMessage> resolveMatchesBuffer;
    private final Lock probeLock;
    private final Lock resolveLock;
    private final Condition probeCondition;
    private final Condition resolveCondition;
    private final EventBus helloByeProbeEvents;
    private final WsAddressingUtil wsaUtil;

    @AssistedInject
    WsDiscoveryClientInterceptor(@Assisted NotificationSource notificationSource, @Named(value="WsDiscovery.MaxWaitForProbeMatches") Duration maxWaitForProbeMatches, @Named(value="WsDiscovery.MaxWaitForResolveMatches") Duration maxWaitForResolveMatches, @Named(value="WsDiscovery.MaxProbeMatchesBufferSize") Integer probeMatchesBufferSize, @Named(value="WsDiscovery.MaxResolveMatchesBufferSize") Integer resolveMatchesBufferSize, WsDiscoveryUtil wsdUtil, @WsDiscovery ExecutorWrapperService<ListeningExecutorService> executorService, ObjectFactory wsdFactory, SoapUtil soapUtil, EventBus helloByeProbeEvents, WsAddressingUtil wsaUtil) {
        this.maxWaitForProbeMatches = maxWaitForProbeMatches;
        this.maxWaitForResolveMatches = maxWaitForResolveMatches;
        this.probeMatchesBufferSize = probeMatchesBufferSize;
        this.resolveMatchesBufferSize = resolveMatchesBufferSize;
        this.wsdUtil = wsdUtil;
        this.executorService = executorService;
        this.notificationSource = notificationSource;
        this.wsdFactory = wsdFactory;
        this.soapUtil = soapUtil;
        this.helloByeProbeEvents = helloByeProbeEvents;
        this.wsaUtil = wsaUtil;
        this.instanceId = UnsignedInteger.valueOf((long)(System.currentTimeMillis() / 1000L));
        this.probeLock = new ReentrantLock();
        this.resolveLock = new ReentrantLock();
        this.probeCondition = this.probeLock.newCondition();
        this.resolveCondition = this.resolveLock.newCondition();
    }

    @MessageInterceptor(value="http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Probe")
    void processProbe(NotificationObject nObj) {
        AppSequenceType appSequence = this.wsdUtil.createAppSequence(this.instanceId);
        nObj.getNotification().getWsDiscoveryHeader().setAppSequence(appSequence);
    }

    @MessageInterceptor(value="http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Resolve")
    void processResolve(NotificationObject nObj) {
        nObj.getNotification().getWsDiscoveryHeader().setAppSequence(this.wsdUtil.createAppSequence(this.instanceId));
    }

    @MessageInterceptor(value="http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/ProbeMatches")
    void processProbeMatches(NotificationObject nObj) {
        LOG.trace("processProbeMatches with message {}", (Object)nObj.getNotification());
        try {
            this.probeLock.lock();
            this.getProbeMatchesBuffer().add((Object)nObj.getNotification());
            this.probeCondition.signalAll();
        }
        finally {
            this.probeLock.unlock();
        }
    }

    @MessageInterceptor(value="http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/ResolveMatches")
    void processResolveMatches(NotificationObject nObj) {
        LOG.trace("processResolveMatches with message {}", (Object)nObj.getNotification());
        try {
            this.resolveLock.lock();
            this.getResolveMatchesBuffer().add((Object)nObj.getNotification());
            this.resolveCondition.signalAll();
        }
        finally {
            this.resolveLock.unlock();
        }
    }

    @MessageInterceptor(value="http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Hello")
    void processHello(NotificationObject nObj) {
        Optional<HelloType> body = this.soapUtil.getBody(nObj.getNotification(), HelloType.class);
        body.ifPresent(helloType -> this.helloByeProbeEvents.post((Object)new HelloMessage((HelloType)helloType)));
    }

    @MessageInterceptor(value="http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Bye")
    void processBye(NotificationObject nObj) {
        Optional<ByeType> body = this.soapUtil.getBody(nObj.getNotification(), ByeType.class);
        body.ifPresent(byeType -> this.helloByeProbeEvents.post((Object)new ByeMessage((ByeType)byeType)));
    }

    @Override
    public ListenableFuture<ProbeMatchesType> sendDirectedProbe(RequestResponseClient rrClient, List<QName> types, List<String> scopes, @Nullable MatchBy matchBy) {
        return ((ListeningExecutorService)this.executorService.get()).submit(() -> {
            SoapMessage response = rrClient.sendRequestResponse(this.createProbeMessage(types, scopes, matchBy));
            return this.soapUtil.getBody(response, ProbeMatchesType.class).orElseThrow(SoapMessageBodyMalformedException::new);
        });
    }

    @Override
    public ListenableFuture<Integer> sendProbe(String probeId, Collection<QName> types, Collection<String> scopes, @Nullable MatchBy matchBy) throws MarshallingException, TransportException, InterceptorException {
        return this.sendProbe(probeId, types, scopes, matchBy, Integer.MAX_VALUE);
    }

    @Override
    public ListenableFuture<Integer> sendProbe(String probeId, Collection<QName> types, Collection<String> scopes, @Nullable MatchBy matchBy, Integer maxResults) throws MarshallingException, TransportException, InterceptorException {
        SoapMessage probeMsg = this.createProbeMessage(types, scopes, matchBy);
        String msgIdUri = this.soapUtil.createUriFromUuid(UUID.randomUUID());
        AttributedURIType msgId = this.wsaUtil.createAttributedURIType(msgIdUri);
        probeMsg.getWsAddressingHeader().setMessageId(msgId);
        ListenableFuture future = ((ListeningExecutorService)this.executorService.get()).submit((Callable)new ProbeRunnable(probeId, maxResults, this.maxWaitForProbeMatches, msgIdUri, this.probeLock, this.probeCondition, this.getProbeMatchesBuffer(), this.soapUtil, this.helloByeProbeEvents));
        this.notificationSource.sendNotification(probeMsg);
        return future;
    }

    @Override
    public ListenableFuture<ResolveMatchesType> sendResolve(EndpointReferenceType epr) throws MarshallingException, TransportException, InterceptorException {
        ResolveType resolveType = this.wsdFactory.createResolveType();
        resolveType.setEndpointReference(epr);
        SoapMessage resolveMsg = this.soapUtil.createMessage("http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Resolve", "urn:docs-oasis-open-org:ws-dd:ns:discovery:2009:01", this.wsdFactory.createResolve(resolveType));
        String msgIdUri = this.soapUtil.createUriFromUuid(UUID.randomUUID());
        AttributedURIType msgId = this.wsaUtil.createAttributedURIType(msgIdUri);
        resolveMsg.getWsAddressingHeader().setMessageId(msgId);
        ListenableFuture future = ((ListeningExecutorService)this.executorService.get()).submit((Callable)new ResolveCallable(this.maxWaitForResolveMatches, msgIdUri, this.resolveLock, this.resolveCondition, this.getResolveMatchesBuffer(), this.soapUtil));
        this.notificationSource.sendNotification(resolveMsg);
        return future;
    }

    private SoapMessage createProbeMessage(Collection<QName> types, Collection<String> scopes, @Nullable MatchBy matchBy) {
        ProbeType probeType = this.wsdFactory.createProbeType();
        probeType.setTypes(new ArrayList<QName>(types));
        ScopesType scopesType = this.wsdFactory.createScopesType();
        if (matchBy != null) {
            scopesType.setMatchBy(matchBy.getUri());
        }
        scopesType.setValue(new ArrayList<String>(scopes));
        probeType.setScopes(scopesType);
        return this.soapUtil.createMessage("http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Probe", "urn:docs-oasis-open-org:ws-dd:ns:discovery:2009:01", this.wsdFactory.createProbe(probeType));
    }

    private synchronized EvictingQueue<SoapMessage> getProbeMatchesBuffer() {
        if (this.probeMatchesBuffer == null) {
            this.probeMatchesBuffer = EvictingQueue.create((int)this.probeMatchesBufferSize);
        }
        return this.probeMatchesBuffer;
    }

    private synchronized EvictingQueue<SoapMessage> getResolveMatchesBuffer() {
        if (this.resolveMatchesBuffer == null) {
            this.resolveMatchesBuffer = EvictingQueue.create((int)this.resolveMatchesBufferSize);
        }
        return this.resolveMatchesBuffer;
    }

    private Optional<SoapMessage> popMatches(EvictingQueue<SoapMessage> messageQueue, String messageId) {
        Optional<SoapMessage> item = messageQueue.stream().filter(message -> messageId.equals(message.getWsAddressingHeader().getRelatesTo().orElse(this.wsaUtil.createRelatesToType("http://www.w3.org/2005/08/addressing/unspecified")).getValue())).findFirst();
        item.ifPresent(arg_0 -> messageQueue.remove(arg_0));
        return item;
    }

    @Override
    public void registerHelloByeAndProbeMatchesObserver(HelloByeAndProbeMatchesObserver observer) {
        this.helloByeProbeEvents.register((Object)observer);
    }

    @Override
    public void unregisterHelloByeAndProbeMatchesObserver(HelloByeAndProbeMatchesObserver observer) {
        this.helloByeProbeEvents.unregister((Object)observer);
    }

    private class ProbeRunnable
    implements Callable<Integer> {
        private final String wsaRelatesTo;
        private final SoapUtil soapUtil;
        private final EventBus helloByeProbeEvents;
        private final Lock lock;
        private final String probeId;
        private final Integer maxResults;
        private final long maxWaitInMillis;
        private final Condition condition;
        private final EvictingQueue<SoapMessage> messageQueue;

        public ProbeRunnable(String probeId, Integer maxResults, Duration maxWait, String wsaRelatesTo, Lock lock, Condition condition, EvictingQueue<SoapMessage> messageQueue, SoapUtil soapUtil, EventBus helloByeProbeEvents) {
            this.probeId = probeId;
            this.maxResults = maxResults;
            this.maxWaitInMillis = maxWait.toMillis();
            this.messageQueue = messageQueue;
            this.wsaRelatesTo = wsaRelatesTo;
            this.lock = lock;
            this.condition = condition;
            this.soapUtil = soapUtil;
            this.helloByeProbeEvents = helloByeProbeEvents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer call() throws Exception {
            Integer probeMatchesCount = 0;
            try {
                long tStartInMillis;
                this.lock.lock();
                for (long wait = this.maxWaitInMillis; wait > 0L; wait -= System.currentTimeMillis() - tStartInMillis) {
                    LOG.trace("ProbeRunnable.call() for wsaRelatesTo {}, wait: {}", (Object)this.wsaRelatesTo, (Object)wait);
                    tStartInMillis = System.currentTimeMillis();
                    probeMatchesCount = this.fetchData(probeMatchesCount);
                    if (probeMatchesCount.equals(this.maxResults)) {
                        LOG.trace("break ProbeRunnable.call() due to maxResults");
                    } else {
                        if (this.condition.await(wait, TimeUnit.MILLISECONDS)) continue;
                        LOG.trace("break ProbeRunnable.call() due to await");
                    }
                    break;
                }
            }
            finally {
                this.lock.unlock();
            }
            LOG.trace("announcing ProbeTimeoutMessage");
            this.helloByeProbeEvents.post((Object)new ProbeTimeoutMessage(probeMatchesCount, this.probeId));
            return probeMatchesCount;
        }

        private Integer fetchData(Integer probeMatchesCount) {
            Integer copyProbeMatchesCount = probeMatchesCount;
            Optional<SoapMessage> msg = WsDiscoveryClientInterceptor.this.popMatches(this.messageQueue, this.wsaRelatesTo);
            if (msg.isPresent()) {
                ProbeMatchesType pMatches = this.soapUtil.getBody(msg.get(), ProbeMatchesType.class).orElseThrow(SoapMessageBodyMalformedException::new);
                LOG.trace("announcing ProbeMatchesMessage");
                this.helloByeProbeEvents.post((Object)new ProbeMatchesMessage(this.probeId, pMatches));
                Integer n = copyProbeMatchesCount;
                copyProbeMatchesCount = copyProbeMatchesCount + 1;
            }
            return copyProbeMatchesCount;
        }
    }

    private class ResolveCallable
    implements Callable<ResolveMatchesType> {
        private final String wsaRelatesTo;
        private final SoapUtil soapUtil;
        private final Lock lock;
        private final long maxWaitInMillis;
        private final Condition condition;
        private final EvictingQueue<SoapMessage> messageQueue;

        public ResolveCallable(Duration maxWait, String wsaRelatesTo, Lock lock, Condition condition, EvictingQueue<SoapMessage> messageQueue, SoapUtil soapUtil) {
            this.maxWaitInMillis = maxWait.toMillis();
            this.messageQueue = messageQueue;
            this.wsaRelatesTo = wsaRelatesTo;
            this.lock = lock;
            this.condition = condition;
            this.soapUtil = soapUtil;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResolveMatchesType call() throws Exception {
            try {
                long tStartInMillis;
                this.lock.lock();
                for (long wait = this.maxWaitInMillis; wait > 0L; wait -= System.currentTimeMillis() - tStartInMillis) {
                    tStartInMillis = System.currentTimeMillis();
                    Optional<SoapMessage> msg = WsDiscoveryClientInterceptor.this.popMatches(this.messageQueue, this.wsaRelatesTo);
                    if (msg.isPresent()) {
                        ResolveMatchesType resolveMatchesType = this.soapUtil.getBody(msg.get(), ResolveMatchesType.class).orElseThrow(SoapMessageBodyMalformedException::new);
                        return resolveMatchesType;
                    }
                    if (!this.condition.await(wait, TimeUnit.MILLISECONDS)) {
                        break;
                    }
                    msg = WsDiscoveryClientInterceptor.this.popMatches(this.messageQueue, this.wsaRelatesTo);
                    if (!msg.isPresent()) continue;
                    ResolveMatchesType resolveMatchesType = this.soapUtil.getBody(msg.get(), ResolveMatchesType.class).orElseThrow(SoapMessageBodyMalformedException::new);
                    return resolveMatchesType;
                }
            }
            finally {
                this.lock.unlock();
            }
            throw new RuntimeException(String.format("No ResolveMatches message received in %s milliseconds, Resolve MessageID was %s", this.maxWaitInMillis, this.wsaRelatesTo));
        }
    }

    private static class SoapMessageBodyMalformedException
    extends RuntimeException {
        public SoapMessageBodyMalformedException() {
            super("SOAP message body malformed");
        }
    }
}

