/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wsdiscovery;

import com.google.common.primitives.UnsignedInteger;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.inject.name.Named;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.soap.NotificationSource;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.factory.SoapFaultFactory;
import org.somda.sdc.dpws.soap.interception.Direction;
import org.somda.sdc.dpws.soap.interception.InterceptorException;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.RequestResponseObject;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingHeader;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wsdiscovery.MatchBy;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryTargetService;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryUtil;
import org.somda.sdc.dpws.soap.wsdiscovery.factory.WsDiscoveryFaultFactory;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ByeType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.HelloType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ObjectFactory;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ProbeMatchType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ProbeMatchesType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ProbeType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ResolveMatchType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ResolveMatchesType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ResolveType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ScopesType;

public class WsDiscoveryTargetServiceInterceptor
implements WsDiscoveryTargetService {
    private static final Logger LOG = LogManager.getLogger(WsDiscoveryTargetServiceInterceptor.class);
    private final ObjectFactory wsdFactory;
    private final SoapFaultFactory soapFaultFactory;
    private final WsDiscoveryFaultFactory wsdFaultFactory;
    private final SoapUtil soapUtil;
    private final WsAddressingUtil wsaUtil;
    private final WsDiscoveryUtil wsdUtil;
    private final EndpointReferenceType targetServiceEpr;
    private final NotificationSource notificationSource;
    private final UnsignedInteger instanceId;
    private final Logger instanceLogger;
    private List<QName> types;
    private List<String> scopes;
    private List<String> xAddrs;
    private final AtomicBoolean metadataModified;
    private UnsignedInteger metadataVersion;
    private final Lock lock;

    @AssistedInject
    WsDiscoveryTargetServiceInterceptor(@Assisted EndpointReferenceType targetServiceEpr, @Assisted NotificationSource notificationSource, ObjectFactory wsdFactory, SoapFaultFactory soapFaultFactory, SoapUtil soapUtil, WsDiscoveryFaultFactory wsdFaultFactory, WsAddressingUtil wsaUtil, WsDiscoveryUtil wsdUtil, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.targetServiceEpr = targetServiceEpr;
        this.notificationSource = notificationSource;
        this.instanceId = UnsignedInteger.valueOf((long)(System.currentTimeMillis() / 1000L));
        this.wsdFactory = wsdFactory;
        this.soapFaultFactory = soapFaultFactory;
        this.soapUtil = soapUtil;
        this.wsdFaultFactory = wsdFaultFactory;
        this.wsaUtil = wsaUtil;
        this.wsdUtil = wsdUtil;
        this.lock = new ReentrantLock();
        this.metadataModified = new AtomicBoolean(false);
        this.metadataVersion = this.getNewMetadataVersion(null);
        this.types = new ArrayList<QName>();
        this.scopes = new ArrayList<String>();
        this.xAddrs = new ArrayList<String>();
    }

    @MessageInterceptor(value="http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Probe", direction=Direction.REQUEST)
    void processProbe(RequestResponseObject rrObj) throws SoapFaultException {
        SoapMessage inMsg = rrObj.getRequest();
        ProbeType probe = this.validateIncomingMessage(inMsg, ProbeType.class);
        ScopesType scopesFromProbe = Optional.ofNullable(probe.getScopes()).orElse(this.wsdFactory.createScopesType());
        List typesFromProbe = Optional.ofNullable(probe.getTypes()).orElse(new ArrayList());
        String requestMatchBy = Optional.ofNullable(scopesFromProbe.getMatchBy()).orElse(MatchBy.RFC3986.getUri());
        MatchBy matcher = Arrays.stream(MatchBy.values()).filter(item -> item.getUri().equals(requestMatchBy)).findAny().orElseThrow(() -> new SoapFaultException(this.wsdFaultFactory.createMatchingRuleNotSupported(), rrObj.getRequest().getWsAddressingHeader().getMessageId().orElse(null)));
        EndpointReferenceType endpointReference = this.getEndpointReference();
        List<String> copyScopes = this.getScopes();
        List<QName> copyTypes = this.getTypes();
        List<String> copyXAddrs = this.getXAddrs();
        UnsignedInteger copyMetadataVersion = this.getMetadataVersion();
        if (!this.wsdUtil.isScopesMatching(copyScopes, scopesFromProbe.getValue(), matcher) || !this.wsdUtil.isTypesMatching(this.types, typesFromProbe)) {
            throw new RuntimeException("Scopes and Types do not match in incoming Probe.");
        }
        ProbeMatchType probeMatchType = this.wsdFactory.createProbeMatchType();
        probeMatchType.setEndpointReference(endpointReference);
        ScopesType scopesType = this.wsdFactory.createScopesType();
        scopesType.setValue(copyScopes);
        probeMatchType.setScopes(scopesType);
        probeMatchType.setTypes(copyTypes);
        probeMatchType.setXAddrs(copyXAddrs);
        probeMatchType.setMetadataVersion(copyMetadataVersion.longValue());
        ProbeMatchesType probeMatchesType = this.wsdFactory.createProbeMatchesType();
        ArrayList<ProbeMatchType> probeMatchTypeList = new ArrayList<ProbeMatchType>();
        probeMatchTypeList.add(probeMatchType);
        probeMatchesType.setProbeMatch(probeMatchTypeList);
        SoapMessage probeMatchesMsg = rrObj.getResponse();
        WsAddressingHeader wsaHeader = probeMatchesMsg.getWsAddressingHeader();
        wsaHeader.setAction(this.wsaUtil.createAttributedURIType("http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/ProbeMatches"));
        wsaHeader.setTo(this.wsaUtil.createAttributedURIType("urn:docs-oasis-open-org:ws-dd:ns:discovery:2009:01"));
        probeMatchesMsg.getWsDiscoveryHeader().setAppSequence(this.wsdUtil.createAppSequence(this.instanceId));
        this.soapUtil.setBody(this.wsdFactory.createProbeMatches(probeMatchesType), probeMatchesMsg);
    }

    @MessageInterceptor(value="http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Resolve", direction=Direction.REQUEST)
    void processResolve(RequestResponseObject rrObj) throws SoapFaultException {
        SoapMessage inMsg = rrObj.getRequest();
        ResolveType resolveType = this.validateIncomingMessage(inMsg, ResolveType.class);
        Optional.ofNullable(resolveType.getEndpointReference()).orElseThrow(() -> new SoapFaultException(this.soapFaultFactory.createSenderFault("Missing Endpoint Reference"), inMsg.getWsAddressingHeader().getMessageId().orElse(null)));
        Optional.ofNullable(resolveType.getEndpointReference().getAddress()).orElseThrow(() -> new SoapFaultException(this.soapFaultFactory.createSenderFault("Missing Endpoint Reference Address"), inMsg.getWsAddressingHeader().getMessageId().orElse(null)));
        EndpointReferenceType endpointReference = this.getEndpointReference();
        List<String> copyScopes = this.getScopes();
        List<QName> copyTypes = this.getTypes();
        List<String> copyXAddrs = this.getXAddrs();
        UnsignedInteger copyMetadataVersion = this.getMetadataVersion();
        if (!URI.create(resolveType.getEndpointReference().getAddress().getValue()).equals(URI.create(endpointReference.getAddress().getValue()))) {
            this.instanceLogger.debug("Incoming ResolveMatches message had an EPR address not matching this device. Message EPR address is {}, device EPR address is {}", (Object)resolveType.getEndpointReference().getAddress().getValue(), (Object)endpointReference.getAddress().getValue());
            return;
        }
        ResolveMatchType resolveMatchType = this.wsdFactory.createResolveMatchType();
        resolveMatchType.setEndpointReference(endpointReference);
        ScopesType scopesType = this.wsdFactory.createScopesType();
        scopesType.setValue(copyScopes);
        resolveMatchType.setScopes(scopesType);
        resolveMatchType.setTypes(copyTypes);
        resolveMatchType.setXAddrs(copyXAddrs);
        resolveMatchType.setMetadataVersion(copyMetadataVersion.longValue());
        ResolveMatchesType resolveMatchesType = this.wsdFactory.createResolveMatchesType();
        resolveMatchesType.setResolveMatch(resolveMatchType);
        SoapMessage resolveMatchesMsg = rrObj.getResponse();
        WsAddressingHeader wsaHeader = resolveMatchesMsg.getWsAddressingHeader();
        wsaHeader.setAction(this.wsaUtil.createAttributedURIType("http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/ResolveMatches"));
        wsaHeader.setTo(this.wsaUtil.createAttributedURIType("urn:docs-oasis-open-org:ws-dd:ns:discovery:2009:01"));
        resolveMatchesMsg.getWsDiscoveryHeader().setAppSequence(this.wsdUtil.createAppSequence(this.instanceId));
        this.soapUtil.setBody(this.wsdFactory.createResolveMatches(resolveMatchesType), resolveMatchesMsg);
    }

    @Override
    public EndpointReferenceType getEndpointReference() {
        return this.targetServiceEpr;
    }

    @Override
    public void setTypes(List<QName> qNames) {
        try {
            this.lock.lock();
            this.types = this.cloneQNames(qNames);
            this.metadataModified.set(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<QName> getTypes() {
        try {
            this.lock.lock();
            List<QName> list = this.cloneQNames(this.types);
            return list;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setScopes(List<String> uris) {
        try {
            this.lock.lock();
            this.scopes = new ArrayList<String>(uris);
            this.metadataModified.set(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<String> getScopes() {
        try {
            this.lock.lock();
            ArrayList<String> arrayList = new ArrayList<String>(this.scopes);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setXAddrs(List<String> xAddrs) {
        try {
            this.lock.lock();
            this.xAddrs = new ArrayList<String>(xAddrs);
            this.metadataModified.set(true);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<String> getXAddrs() {
        try {
            this.lock.lock();
            ArrayList<String> arrayList = new ArrayList<String>(this.xAddrs);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setMetadataModified() {
        this.metadataModified.set(true);
    }

    @Override
    public UnsignedInteger getMetadataVersion() {
        try {
            this.lock.lock();
            UnsignedInteger unsignedInteger = UnsignedInteger.valueOf((long)this.metadataVersion.longValue());
            return unsignedInteger;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public UnsignedInteger sendHello() throws MarshallingException, TransportException, InterceptorException {
        return this.sendHello(false);
    }

    @Override
    public UnsignedInteger sendHello(boolean forceNewMetadataVersion) throws MarshallingException, TransportException, InterceptorException {
        UnsignedInteger currentMetadataVersion = forceNewMetadataVersion ? this.incMetadataVersionAndGet() : this.incMetadataVersionIfModifiedAndGet();
        HelloType helloType = this.wsdFactory.createHelloType();
        helloType.setXAddrs(this.getXAddrs());
        ScopesType scopesType = this.wsdFactory.createScopesType();
        scopesType.setValue(this.getScopes());
        helloType.setScopes(scopesType);
        helloType.setTypes(this.getTypes());
        helloType.setMetadataVersion(currentMetadataVersion.longValue());
        helloType.setEndpointReference(this.getEndpointReference());
        this.sendMulticast("http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Hello", this.wsdFactory.createHello(helloType));
        this.metadataModified.set(false);
        return currentMetadataVersion;
    }

    @Override
    public void sendBye() throws MarshallingException, TransportException, InterceptorException {
        ByeType byeType = this.wsdFactory.createByeType();
        byeType.setXAddrs(this.getXAddrs());
        ScopesType scopesType = this.wsdFactory.createScopesType();
        scopesType.setValue(this.getScopes());
        byeType.setScopes(scopesType);
        byeType.setTypes(this.getTypes());
        byeType.setEndpointReference(this.getEndpointReference());
        this.sendMulticast("http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01/Bye", this.wsdFactory.createBye(byeType));
    }

    public UnsignedInteger incMetadataVersionAndGet() {
        try {
            this.lock.lock();
            this.metadataVersion = this.getNewMetadataVersion(this.metadataVersion);
            UnsignedInteger unsignedInteger = UnsignedInteger.valueOf((long)this.metadataVersion.longValue());
            return unsignedInteger;
        }
        finally {
            this.lock.unlock();
        }
    }

    public UnsignedInteger incMetadataVersionIfModifiedAndGet() {
        try {
            this.lock.lock();
            if (this.metadataModified.get()) {
                this.metadataVersion = this.getNewMetadataVersion(this.metadataVersion);
            }
            UnsignedInteger unsignedInteger = UnsignedInteger.valueOf((long)this.metadataVersion.longValue());
            return unsignedInteger;
        }
        finally {
            this.lock.unlock();
        }
    }

    private UnsignedInteger getNewMetadataVersion(@Nullable UnsignedInteger currentVersion) {
        UnsignedInteger newVersion = UnsignedInteger.valueOf((long)(Instant.now().toEpochMilli() / 1000L));
        if (currentVersion == null) {
            return newVersion;
        }
        if (newVersion.compareTo(currentVersion) <= 0) {
            return currentVersion.plus(UnsignedInteger.ONE);
        }
        return newVersion;
    }

    private void sendMulticast(String action, JAXBElement<?> body) throws MarshallingException, TransportException, InterceptorException {
        SoapMessage soapMessage = this.soapUtil.createMessage(action, "urn:docs-oasis-open-org:ws-dd:ns:discovery:2009:01", body);
        soapMessage.getWsDiscoveryHeader().setAppSequence(this.wsdUtil.createAppSequence(this.instanceId));
        this.notificationSource.sendNotification(soapMessage);
    }

    private <T> T validateIncomingMessage(SoapMessage request, Class<T> bodyType) throws SoapFaultException {
        String to = request.getWsAddressingHeader().getTo().orElseThrow(() -> new SoapFaultException(this.soapFaultFactory.createSenderFault(String.format("wsa:To field is invalid. Expected '%s', but none found ", "urn:docs-oasis-open-org:ws-dd:ns:discovery:2009:01")), request.getWsAddressingHeader().getMessageId().orElse(null))).getValue();
        if (!to.equals("urn:docs-oasis-open-org:ws-dd:ns:discovery:2009:01")) {
            throw new SoapFaultException(this.soapFaultFactory.createSenderFault(String.format("wsa:To field is invalid. Expected '%s', but actual is '%s'", "urn:docs-oasis-open-org:ws-dd:ns:discovery:2009:01", to)), request.getWsAddressingHeader().getMessageId().orElse(null));
        }
        return this.soapUtil.getBody(request, bodyType).orElseThrow(() -> new SoapFaultException(this.soapFaultFactory.createSenderFault("Body type is invalid"), request.getWsAddressingHeader().getMessageId().orElse(null)));
    }

    private List<QName> cloneQNames(List<QName> qNames) {
        return qNames.stream().map(qName -> new QName(qName.getNamespaceURI(), qName.getLocalPart(), qName.getPrefix())).collect(Collectors.toList());
    }
}

