/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.http.jetty;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.CommunicationLog;
import org.somda.sdc.dpws.CommunicationLogContext;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.HttpApplicationInfo;
import org.somda.sdc.dpws.soap.TransportInfo;

public class CommunicationLogOutputInterceptor
implements HttpOutput.Interceptor {
    private static final Logger LOG = LogManager.getLogger(CommunicationLogOutputInterceptor.class);
    private final HttpChannel channel;
    private final CommunicationLog communicationLog;
    private final TransportInfo transportInfo;
    private final Logger instanceLogger;
    private OutputStream commlogStream;
    private HttpOutput.Interceptor nextInterceptor;
    private String currentTransactionId;
    @Nullable
    private CommunicationLogContext communicationLogContext;

    CommunicationLogOutputInterceptor(HttpChannel channel, HttpOutput.Interceptor nextInterceptor, CommunicationLog communicationLog, @Nullable CommunicationLogContext communicationLogContext, TransportInfo transportInfo, String frameworkIdentifier, String currentTransactionId) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.channel = channel;
        this.communicationLog = communicationLog;
        this.nextInterceptor = nextInterceptor;
        this.transportInfo = transportInfo;
        this.commlogStream = null;
        this.currentTransactionId = currentTransactionId;
        this.communicationLogContext = communicationLogContext;
    }

    public void close() {
        try {
            if (this.commlogStream != null) {
                this.commlogStream.close();
            }
        }
        catch (IOException e) {
            this.instanceLogger.error("Error while closing communication log stream", (Throwable)e);
        }
    }

    public void write(ByteBuffer content, boolean last, Callback callback) {
        if (content == null) {
            this.nextInterceptor.write(content, last, callback);
            return;
        }
        if (this.commlogStream == null) {
            this.commlogStream = this.getCommlogStream();
        }
        int oldPosition = content.position();
        try {
            WritableByteChannel writableByteChannel = Channels.newChannel(this.commlogStream);
            writableByteChannel.write(content);
            if (last) {
                this.close();
            }
        }
        catch (IOException e) {
            this.instanceLogger.error("Error while writing to commlog", (Throwable)e);
        }
        content.position(oldPosition);
        this.nextInterceptor.write(content, last, callback);
    }

    private OutputStream getCommlogStream() {
        Response response = this.channel.getResponse();
        ArrayListMultimap responseHeaderMap = ArrayListMultimap.create();
        response.getHeaderNames().stream().map(String::toLowerCase).distinct().forEach(arg_0 -> CommunicationLogOutputInterceptor.lambda$getCommlogStream$1(response, (ListMultimap)responseHeaderMap, arg_0));
        HttpApplicationInfo responseHttpApplicationInfo = new HttpApplicationInfo((ListMultimap<String, String>)responseHeaderMap, this.currentTransactionId, null);
        CommunicationContext responseCommContext = new CommunicationContext(responseHttpApplicationInfo, this.transportInfo, this.communicationLogContext);
        return this.communicationLog.logMessage(CommunicationLog.Direction.OUTBOUND, CommunicationLog.TransportType.HTTP, CommunicationLog.MessageType.RESPONSE, responseCommContext);
    }

    public HttpOutput.Interceptor getNextInterceptor() {
        return this.nextInterceptor;
    }

    private static /* synthetic */ void lambda$getCommlogStream$1(Response response, ListMultimap responseHeaderMap, String headerName) {
        Collection headers = response.getHeaders(headerName);
        headers.forEach(header -> responseHeaderMap.put((Object)headerName, header));
    }
}

