/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap;

import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.somda.sdc.dpws.soap.SoapConstants;
import org.somda.sdc.dpws.soap.SoapDebug;
import org.somda.sdc.dpws.soap.factory.EnvelopeFactory;
import org.somda.sdc.dpws.soap.model.Envelope;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingHeader;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingMapper;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryHeader;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryMapper;

public class SoapMessage {
    private final WsDiscoveryHeader wsdHeader;
    private final WsAddressingHeader wsaHeader;
    private final Envelope envelope;
    private final WsAddressingMapper wsaMapper;
    private final WsDiscoveryMapper wsdMapper;
    private final EnvelopeFactory envelopeFactory;

    @AssistedInject
    SoapMessage(@Assisted Envelope envelope, Provider<WsAddressingHeader> wsaHeaderProvider, WsAddressingMapper wsaMapper, Provider<WsDiscoveryHeader> wsdHeaderProvider, WsDiscoveryMapper wsdMapper, EnvelopeFactory envelopeFactory) {
        this.envelope = envelope;
        this.wsaMapper = wsaMapper;
        this.wsdMapper = wsdMapper;
        this.envelopeFactory = envelopeFactory;
        List<Object> tmpHeaderList = new ArrayList<Object>();
        if (envelope.getHeader() != null && envelope.getHeader().getAny() != null) {
            tmpHeaderList = envelope.getHeader().getAny();
        }
        this.wsaHeader = (WsAddressingHeader)wsaHeaderProvider.get();
        wsaMapper.mapFromJaxbSoapHeader(tmpHeaderList, this.wsaHeader);
        this.wsdHeader = (WsDiscoveryHeader)wsdHeaderProvider.get();
        wsdMapper.mapFromJaxbSoapHeader(tmpHeaderList, this.wsdHeader);
    }

    public WsAddressingHeader getWsAddressingHeader() {
        return this.wsaHeader;
    }

    public WsDiscoveryHeader getWsDiscoveryHeader() {
        return this.wsdHeader;
    }

    public Envelope getOriginalEnvelope() {
        return this.envelope;
    }

    public Envelope getEnvelopeWithMappedHeaders() {
        Envelope mappedEnv = this.envelopeFactory.createEnvelopeFromBody(this.envelope.getBody());
        List tmpHeaderList = mappedEnv.getHeader().getAny();
        mappedEnv.getHeader().getAny().addAll(this.envelope.getHeader().getAny());
        this.wsaMapper.mapToJaxbSoapHeader(this.wsaHeader, tmpHeaderList);
        this.wsdMapper.mapToJaxbSoapHeader(this.wsdHeader, tmpHeaderList);
        return mappedEnv;
    }

    public boolean isFault() {
        Object obj;
        if (this.getOriginalEnvelope().getBody().getAny().size() == 1 && JAXBElement.class.isAssignableFrom((obj = this.getOriginalEnvelope().getBody().getAny().get(0)).getClass())) {
            JAXBElement jaxbElem = (JAXBElement)obj;
            return jaxbElem.getName().equals(SoapConstants.FAULT);
        }
        return false;
    }

    public String toString() {
        return SoapDebug.getBrief(this);
    }
}

