/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.interception;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.factory.SoapFaultFactory;
import org.somda.sdc.dpws.soap.interception.Direction;
import org.somda.sdc.dpws.soap.interception.InterceptorCallbackType;
import org.somda.sdc.dpws.soap.interception.InterceptorException;
import org.somda.sdc.dpws.soap.interception.InterceptorProcessor;
import org.somda.sdc.dpws.soap.interception.InterceptorRegistry;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;

public class ServerDispatcher {
    private static final Logger LOG = LogManager.getLogger(ServerDispatcher.class);
    private final InterceptorProcessor interceptorProcessor;
    private final SoapFaultFactory soapFaultFactory;
    private final Logger instanceLogger;

    @Inject
    public ServerDispatcher(InterceptorProcessor interceptorProcessor, SoapFaultFactory soapFaultFactory, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.interceptorProcessor = interceptorProcessor;
        this.soapFaultFactory = soapFaultFactory;
    }

    public void invokeDispatcher(Direction direction, InterceptorRegistry registry, SoapMessage soapMessage, InterceptorCallbackType interceptorCallbackObject) throws SoapFaultException {
        Optional<AttributedURIType> action = soapMessage.getWsAddressingHeader().getAction();
        String actionUri = null;
        if (action.isPresent()) {
            actionUri = action.get().getValue();
        }
        try {
            this.interceptorProcessor.dispatch(direction, registry, actionUri, interceptorCallbackObject);
        }
        catch (InterceptorException e) {
            this.instanceLogger.debug("Caught interceptor exception from {} with message: {}", (Object)e.getInterceptor(), (Object)e.getMessage());
            if (e.getCause() instanceof SoapFaultException) {
                throw (SoapFaultException)e.getCause();
            }
            throw new SoapFaultException(this.soapFaultFactory.createReceiverFault(String.format("Server fault information: %s", e.getCause().getMessage())), soapMessage.getWsAddressingHeader().getMessageId().orElse(null));
        }
        catch (Exception e) {
            this.instanceLogger.warn("Unexpected exception thrown during dispatcher invocation routine: {}", (Object)e.getMessage());
            throw new SoapFaultException(this.soapFaultFactory.createReceiverFault(String.format("Server fault information: %s", e.getMessage())), soapMessage.getWsAddressingHeader().getMessageId().orElse(null));
        }
    }
}

