/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wsaddressing;

import com.google.common.collect.EvictingQueue;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.common.logging.InstanceLogger;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.factory.SoapFaultFactory;
import org.somda.sdc.dpws.soap.interception.Direction;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.NotificationObject;
import org.somda.sdc.dpws.soap.interception.RequestResponseObject;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.factory.WsAddressingFaultFactory;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;

public class WsAddressingServerInterceptor
implements Interceptor {
    private static final Logger LOG = LogManager.getLogger(WsAddressingServerInterceptor.class);
    private final Boolean ignoreMessageIds;
    private final WsAddressingFaultFactory addressingFaultFactory;
    private final WsAddressingUtil wsaUtil;
    private final SoapUtil soapUtil;
    private final EvictingQueue<String> messageIdCache;
    private final SoapFaultFactory soapFaultFactory;
    private final Logger instanceLogger;

    @Inject
    WsAddressingServerInterceptor(@Named(value="WsAddressing.MessageIdCacheSize") Integer messageIdCacheSize, @Named(value="WsAddressing.IgnoreMessageIds") Boolean ignoreMessageIds, WsAddressingFaultFactory addressingFaultFactory, SoapFaultFactory soapFaultFactory, WsAddressingUtil wsaUtil, SoapUtil soapUtil, @Named(value="Common.InstanceIdentifier") String frameworkIdentifier) {
        this.instanceLogger = InstanceLogger.wrapLogger((Logger)LOG, (String)frameworkIdentifier);
        this.messageIdCache = EvictingQueue.create((int)messageIdCacheSize);
        this.ignoreMessageIds = ignoreMessageIds;
        this.addressingFaultFactory = addressingFaultFactory;
        this.soapFaultFactory = soapFaultFactory;
        this.wsaUtil = wsaUtil;
        this.soapUtil = soapUtil;
    }

    @MessageInterceptor(direction=Direction.REQUEST)
    void processMessage(RequestResponseObject rrInfo) throws SoapFaultException {
        Consumer<SoapMessage> logMissingMessageId = this.resolveLogCallForMissingMessageIds(rrInfo.getCommunicationContext());
        this.processMessage(rrInfo.getRequest(), logMissingMessageId);
        rrInfo.getResponse().getWsAddressingHeader().setRelatesTo(this.wsaUtil.createRelatesToType((AttributedURIType)rrInfo.getRequest().getWsAddressingHeader().getMessageId().orElse(null)));
        rrInfo.getResponse().getWsAddressingHeader().setMessageId(this.wsaUtil.createAttributedURIType(this.soapUtil.createRandomUuidUri()));
    }

    @MessageInterceptor
    void processMessage(NotificationObject nInfo) throws SoapFaultException {
        Consumer<SoapMessage> logMissingMessageId = this.resolveLogCallForMissingMessageIds(nInfo.getCommunicationContext().orElse(null));
        this.processMessage(nInfo.getNotification(), logMissingMessageId);
    }

    private void processMessage(SoapMessage msg, Consumer<SoapMessage> logMissingMessageId) throws SoapFaultException {
        this.processAction(msg);
        this.processMessageId(msg, logMissingMessageId);
    }

    private void processAction(SoapMessage msg) throws SoapFaultException {
        Optional<AttributedURIType> action = msg.getWsAddressingHeader().getAction();
        if (action.isEmpty() || Optional.ofNullable(action.get().getValue()).isEmpty()) {
            throw new SoapFaultException(this.soapFaultFactory.createSenderFault("WS-Addressing header 'Action' required, but not given"), msg.getWsAddressingHeader().getMessageId().orElse(null));
        }
        if (action.get().getValue().isEmpty()) {
            throw new SoapFaultException(this.soapFaultFactory.createSenderFault("WS-Addressing header 'Action' given, but empty"), msg.getWsAddressingHeader().getMessageId().orElse(null));
        }
    }

    private synchronized void processMessageId(SoapMessage msg, Consumer<SoapMessage> logMissingMessageId) {
        if (this.ignoreMessageIds.booleanValue()) {
            return;
        }
        Optional<AttributedURIType> messageId = msg.getWsAddressingHeader().getMessageId();
        if (messageId.isEmpty()) {
            logMissingMessageId.accept(msg);
            return;
        }
        Optional<String> foundMessageId = this.messageIdCache.stream().filter(s -> ((AttributedURIType)messageId.get()).getValue().equals(s)).findFirst();
        if (foundMessageId.isPresent()) {
            String actionUri = "unknown action";
            if (msg.getWsAddressingHeader().getAction().isPresent()) {
                actionUri = msg.getWsAddressingHeader().getAction().get().getValue();
            }
            String faultMsg = String.format("Found message duplicate: %s (message: %s). Skip processing.", foundMessageId.get(), actionUri);
            this.instanceLogger.debug(faultMsg);
            throw new RuntimeException(faultMsg);
        }
        this.messageIdCache.add((Object)messageId.get().getValue());
    }

    private Consumer<SoapMessage> resolveLogCallForMissingMessageIds(CommunicationContext communicationContext) {
        String logMsg = "Incoming message {} had no MessageID element in its header";
        Consumer<SoapMessage> logCall = soapMessage -> this.instanceLogger.debug(logMsg, soapMessage);
        if (communicationContext.getTransportInfo().getScheme().equalsIgnoreCase("soap.udp")) {
            logCall = soapMessage -> this.instanceLogger.warn(logMsg, soapMessage);
        }
        return logCall;
    }
}

