/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wseventing.factory;

import com.google.inject.Inject;
import org.somda.sdc.dpws.soap.SoapConstants;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.factory.SoapFaultFactory;
import org.somda.sdc.dpws.soap.model.Envelope;
import org.somda.sdc.dpws.soap.model.ObjectFactory;
import org.somda.sdc.dpws.soap.wseventing.WsEventingConstants;

public class WsEventingFaultFactory {
    private final SoapFaultFactory soapFaultFactory;
    private final org.somda.sdc.dpws.soap.wseventing.model.ObjectFactory wseFactory;
    private final ObjectFactory soapFactory;

    @Inject
    WsEventingFaultFactory(SoapFaultFactory soapFaultFactory, org.somda.sdc.dpws.soap.wseventing.model.ObjectFactory wseFactory, ObjectFactory soapFactory) {
        this.soapFaultFactory = soapFaultFactory;
        this.wseFactory = wseFactory;
        this.soapFactory = soapFactory;
    }

    public SoapMessage createDeliveryModeRequestedUnavailable() {
        return this.soapFaultFactory.createFault("http://www.w3.org/2005/08/addressing/fault", SoapConstants.SENDER, WsEventingConstants.DELIVERY_MODE_REQUESTED_UNAVAILABLE, "The requested delivery mode is not supported.", this.wseFactory.createSupportedDeliveryMode("http://schemas.xmlsoap.org/ws/2004/08/eventing/DeliveryModes/Push"));
    }

    public SoapMessage createInvalidExpirationTime() {
        return this.soapFaultFactory.createFault("http://www.w3.org/2005/08/addressing/fault", SoapConstants.SENDER, WsEventingConstants.INVALID_EXPIRATION_TIME, "The expiration time requested is invalid.");
    }

    public SoapMessage createUnsupportedExpirationType() {
        return this.soapFaultFactory.createFault("http://www.w3.org/2005/08/addressing/fault", SoapConstants.SENDER, WsEventingConstants.UNSUPPORTED_EXPIRATION_TYPE, "Only expiration durations are supported.");
    }

    public SoapMessage createFilteringNotSupported() {
        return this.soapFaultFactory.createFault("http://www.w3.org/2005/08/addressing/fault", SoapConstants.SENDER, WsEventingConstants.FILTERING_NOT_SUPPORTED, "Filtering is not supported.");
    }

    public SoapMessage createFilteringRequestedUnavailable() {
        return this.soapFaultFactory.createFault("http://www.w3.org/2005/08/addressing/fault", SoapConstants.SENDER, WsEventingConstants.FILTERING_REQUESTED_UNAVAILABLE, "The requested filter dialect is not supported", this.wseFactory.createSupportedDialect("http://docs.oasis-open.org/ws-dd/ns/dpws/2009/01/Action"));
    }

    public SoapMessage createEventSourceUnableToProcess(String reason) {
        return this.soapFaultFactory.createFault("http://www.w3.org/2005/08/addressing/fault", SoapConstants.SENDER, WsEventingConstants.EVENT_SOURCE_UNABLE_TO_PROCESS, reason);
    }

    public SoapMessage createUnableToRenew(String reason) {
        return this.soapFaultFactory.createFault("http://www.w3.org/2005/08/addressing/fault", SoapConstants.RECEIVER, WsEventingConstants.UNABLE_TO_RENEW, reason);
    }

    public SoapMessage createInvalidMessage(String reason, Envelope invalidMessage) {
        return this.soapFaultFactory.createFault("http://www.w3.org/2005/08/addressing/fault", SoapConstants.RECEIVER, WsEventingConstants.INVALID_MESSAGE, "The message is not valid and cannot be processed.", this.soapFactory.createEnvelope(invalidMessage));
    }
}

