/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wseventing.helper;

import com.google.common.eventbus.EventBus;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.somda.sdc.dpws.soap.wseventing.EventSourceDialectHandler;
import org.somda.sdc.dpws.soap.wseventing.SourceSubscriptionManager;
import org.somda.sdc.dpws.soap.wseventing.Subscriptions;
import org.somda.sdc.dpws.soap.wseventing.event.SubscriptionAddedMessage;
import org.somda.sdc.dpws.soap.wseventing.event.SubscriptionRemovedMessage;
import org.somda.sdc.dpws.soap.wseventing.helper.EventSourceUtil;

public class SubscriptionRegistry
implements Subscriptions {
    private static final Logger LOG = LogManager.getLogger(SubscriptionRegistry.class);
    private final EventSourceDialectHandler customStaleCallback;
    private final EventSourceUtil eventSourceUtil;
    private final EventBus eventBus;
    private final Map<String, SourceSubscriptionManager> subscriptionManagers;

    @AssistedInject
    SubscriptionRegistry(@Assisted EventSourceDialectHandler customStaleCallback, EventSourceUtil eventSourceUtil, EventBus eventBus) {
        this.customStaleCallback = customStaleCallback;
        this.eventSourceUtil = eventSourceUtil;
        this.eventBus = eventBus;
        this.subscriptionManagers = new ConcurrentHashMap<String, SourceSubscriptionManager>();
    }

    @Inject
    SubscriptionRegistry(EventSourceUtil eventSourceUtil, EventBus eventBus) {
        this.customStaleCallback = null;
        this.eventSourceUtil = eventSourceUtil;
        this.eventBus = eventBus;
        this.subscriptionManagers = new ConcurrentHashMap<String, SourceSubscriptionManager>();
    }

    public void addSubscription(SourceSubscriptionManager subscriptionManager) {
        this.subscriptionManagers.put(subscriptionManager.getSubscriptionId(), subscriptionManager);
        this.eventBus.post((Object)new SubscriptionAddedMessage(subscriptionManager));
    }

    public Optional<SourceSubscriptionManager> removeSubscription(String subscriptionId) {
        SourceSubscriptionManager removedSub = this.subscriptionManagers.remove(subscriptionId);
        if (removedSub != null) {
            this.eventSourceUtil.unregisterHttpHandler(removedSub);
            this.eventBus.post((Object)new SubscriptionRemovedMessage(removedSub));
        }
        return Optional.ofNullable(removedSub);
    }

    public Optional<SourceSubscriptionManager> getSubscription(String subscriptionId) {
        return Optional.ofNullable(this.removeStaleSubscriptions().get(subscriptionId));
    }

    public Map<String, SourceSubscriptionManager> getSubscriptions() {
        return this.removeStaleSubscriptions();
    }

    public void registerObserver(Object observer) {
        this.eventBus.register(observer);
    }

    public void unregisterObserver(Object observer) {
        this.eventBus.unregister(observer);
    }

    private Map<String, SourceSubscriptionManager> removeStaleSubscriptions() {
        return new HashMap<String, SourceSubscriptionManager>(this.subscriptionManagers).entrySet().stream().filter(it -> {
            String key = (String)it.getKey();
            SourceSubscriptionManager subMan = (SourceSubscriptionManager)it.getValue();
            if (!subMan.isRunning() || this.isSubscriptionExpired(subMan)) {
                this.removeSubscription(key);
                if (this.customStaleCallback != null) {
                    this.customStaleCallback.setStale(subMan);
                }
                subMan.stopAsync().awaitTerminated();
                LOG.info("Removed expired subscription: {}", (Object)key);
                return false;
            }
            return true;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private boolean isSubscriptionExpired(SourceSubscriptionManager subMan) {
        Duration expires = Duration.between(Instant.now(), subMan.getExpiresTimeout());
        return expires.isZero() || expires.isNegative();
    }

    @Override
    public Optional<SourceSubscriptionManager> get(String subscriptionId) {
        return this.getSubscription(subscriptionId);
    }

    @Override
    public Map<String, SourceSubscriptionManager> getAll() {
        return this.getSubscriptions();
    }
}

