/*
 * Decompiled with CFR 0.152.
 */
package it.org.somda.sdc.dpws;

import com.google.common.collect.ListMultimap;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.sun.net.httpserver.HttpServer;
import it.org.somda.sdc.dpws.HttpServerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.somda.sdc.dpws.CommunicationLog;
import org.somda.sdc.dpws.CommunicationLogContext;
import org.somda.sdc.dpws.CommunicationLogImpl;
import org.somda.sdc.dpws.CommunicationLogSink;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.TransportBinding;
import org.somda.sdc.dpws.factory.CommunicationLogFactory;
import org.somda.sdc.dpws.factory.TransportBindingFactory;
import org.somda.sdc.dpws.guice.DefaultDpwsConfigModule;
import org.somda.sdc.dpws.helper.JaxbMarshalling;
import org.somda.sdc.dpws.http.HttpHandler;
import org.somda.sdc.dpws.http.jetty.JettyHttpServerRegistry;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.HttpApplicationInfo;
import org.somda.sdc.dpws.soap.SoapMarshalling;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.factory.EnvelopeFactory;
import org.somda.sdc.dpws.soap.factory.SoapMessageFactory;

class CommunicationLogIT
extends DpwsTest {
    private TransportBindingFactory transportBindingFactory;
    private SoapMessageFactory soapMessageFactory;
    private EnvelopeFactory envelopeFactory;
    private SoapMarshalling marshalling;
    private TestCommLogSink logSink;
    private JettyHttpServerRegistry httpServerRegistry;

    CommunicationLogIT() {
    }

    void setUp(final boolean commlogInHandler) throws Exception {
        DefaultDpwsConfigModule dpwsOverride = new DefaultDpwsConfigModule(){

            public void customConfigure() {
                this.bind("Dpws.GzipCompression", Boolean.class, true);
                this.bind("Dpws.ServerCommlogInHandler", Boolean.class, commlogInHandler);
            }
        };
        AbstractModule override = new AbstractModule(){

            protected void configure() {
                this.bind(CommunicationLogSink.class).to(TestCommLogSink.class).asEagerSingleton();
                this.install(new FactoryModuleBuilder().implement(CommunicationLog.class, CommunicationLogImpl.class).build(CommunicationLogFactory.class));
            }
        };
        this.overrideBindings(List.of(dpwsOverride, override));
        super.setUp();
        this.httpServerRegistry = (JettyHttpServerRegistry)this.getInjector().getInstance(JettyHttpServerRegistry.class);
        this.transportBindingFactory = (TransportBindingFactory)this.getInjector().getInstance(TransportBindingFactory.class);
        this.soapMessageFactory = (SoapMessageFactory)this.getInjector().getInstance(SoapMessageFactory.class);
        this.envelopeFactory = (EnvelopeFactory)this.getInjector().getInstance(EnvelopeFactory.class);
        ((JaxbMarshalling)this.getInjector().getInstance(JaxbMarshalling.class)).startAsync().awaitRunning();
        this.marshalling = (SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class);
        this.logSink = (TestCommLogSink)this.getInjector().getInstance(CommunicationLogSink.class);
        this.marshalling.startAsync().awaitRunning();
    }

    @AfterEach
    void tearDown() {
        this.marshalling.stopAsync().awaitTerminated();
        this.logSink.clear();
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    void testClientCommlog(boolean commLogInHandler) throws Exception {
        this.setUp(commLogInHandler);
        URI baseUri = URI.create("http://127.0.0.1:0/");
        String expectedResponse = "Sehr geehrter Kaliba, netter Versuch\nKritische Texte, Weltverbesserer-Blues;";
        JAXBElement jaxbElement = new JAXBElement(new QName("root-element"), String.class, (Object)expectedResponse);
        SoapMessage responseEnvelope = this.createASoapMessage();
        responseEnvelope.getOriginalEnvelope().getBody().getAny().add(jaxbElement);
        CloseableByteArrayOutputStream expectedResponseStream = new CloseableByteArrayOutputStream();
        this.marshalling.marshal(responseEnvelope.getEnvelopeWithMappedHeaders(), (OutputStream)expectedResponseStream);
        byte[] responseBytes = expectedResponseStream.toByteArray();
        HttpServerUtil.GzipResponseHandler handler = new HttpServerUtil.GzipResponseHandler(responseBytes);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(baseUri.getHost(), baseUri.getPort());
        HttpServer server = HttpServerUtil.spawnHttpServer(inetSocketAddress, handler);
        baseUri = new URI(baseUri.getScheme(), baseUri.getUserInfo(), baseUri.getHost(), server.getAddress().getPort(), baseUri.getPath(), baseUri.getQuery(), baseUri.getFragment());
        CommunicationLogContext commLogContext = new CommunicationLogContext("txetnoCgoLnoitacinummoC" + UUID.randomUUID());
        TransportBinding httpBinding1 = this.transportBindingFactory.createHttpBinding(baseUri.toString(), commLogContext);
        for (int i = 0; i < 100; ++i) {
            SoapMessage requestMessage = this.createASoapMessage();
            CloseableByteArrayOutputStream actualRequestStream = new CloseableByteArrayOutputStream();
            this.marshalling.marshal(requestMessage.getEnvelopeWithMappedHeaders(), (OutputStream)actualRequestStream);
            SoapMessage response = httpBinding1.onRequestResponse(requestMessage);
            CloseableByteArrayOutputStream actualResponseStream = new CloseableByteArrayOutputStream();
            this.marshalling.marshal(response.getEnvelopeWithMappedHeaders(), (OutputStream)actualResponseStream);
            Assertions.assertArrayEquals((byte[])expectedResponseStream.toByteArray(), (byte[])actualResponseStream.toByteArray());
            CloseableByteArrayOutputStream req = this.logSink.getOutbound().get(0);
            CloseableByteArrayOutputStream resp = this.logSink.getInbound().get(0);
            Assertions.assertArrayEquals((byte[])actualRequestStream.toByteArray(), (byte[])req.toByteArray());
            Assertions.assertArrayEquals((byte[])expectedResponseStream.toByteArray(), (byte[])resp.toByteArray());
            Assertions.assertTrue((boolean)req.isClosed());
            Assertions.assertTrue((boolean)resp.isClosed());
            Assertions.assertTrue((boolean)this.logSink.getOutboundHeaders().get(0).get((Object)"X-User-Agent".toLowerCase()).contains("SDCri"));
            Assertions.assertTrue((boolean)this.logSink.getInboundHeaders().get(0).get((Object)"SDCriTestHeader".toLowerCase()).contains("anAmazingValue"));
            Assertions.assertFalse((boolean)this.logSink.getOutboundHeaders().get(0).get((Object)"X-User-Agent").contains("SDCri"));
            Assertions.assertFalse((boolean)this.logSink.getInboundHeaders().get(0).get((Object)"SDCriTestHeader").contains("anAmazingValue"));
            Assertions.assertEquals((Object)commLogContext, (Object)this.logSink.getOutboundCommunicationContexts().get(0).getCommunicationLogContext());
            Assertions.assertEquals((Object)commLogContext, (Object)this.logSink.getInboundCommunicationContexts().get(0).getCommunicationLogContext());
            Assertions.assertEquals((Object)CommunicationLog.MessageType.RESPONSE, (Object)this.logSink.getInboundMessageType());
            Assertions.assertEquals((Object)CommunicationLog.MessageType.REQUEST, (Object)this.logSink.getOutboundMessageType());
            this.compareTransactionIds(this.logSink.getInboundTransactionIds(), this.logSink.getOutboundTransactionIds());
            this.logSink.clear();
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    void testServerCommlogStreamedRequest(boolean commLogInHandler) throws Exception {
        this.setUp(commLogInHandler);
        String baseUri = "http://127.0.0.1:0";
        String contextPath = "/ctxt/path1";
        String baseRequest = "The quick brown fox jumps over the lazy dog";
        String expectedResponse = "Franz jagt im komplett verwahrlosten Taxi quer durch Bayern";
        final AtomicReference resultString = new AtomicReference();
        this.httpServerRegistry.startAsync().awaitRunning();
        String srvUri1 = this.httpServerRegistry.registerContext(baseUri, true, contextPath, null, null, new HttpHandler(){

            public void handle(InputStream inStream, OutputStream outStream, CommunicationContext communicationContext) {
                try {
                    byte[] bytes = inStream.readAllBytes();
                    resultString.set(new String(bytes));
                    outStream.write("Franz jagt im komplett verwahrlosten Taxi quer durch Bayern".getBytes());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        CloseableHttpClient client = HttpClients.custom().setMaxConnPerRoute(1).build();
        HttpPost post = new HttpPost(srvUri1);
        String customHeaderKey = "thecustomheader";
        String customHeaderValue = "theCUSTOMvalue";
        post.setHeader(customHeaderKey, customHeaderValue);
        String expectedRequest = "The quick brown fox jumps over the lazy dog".repeat(100000);
        InputStreamEntity requestEntity = new InputStreamEntity((InputStream)new SlowInputStream(expectedRequest.getBytes(), 50));
        requestEntity.setChunked(true);
        post.setEntity((HttpEntity)requestEntity);
        for (int i = 0; i < 1; ++i) {
            HttpResponse response = client.execute((HttpUriRequest)post);
            byte[] responseBytes = response.getEntity().getContent().readAllBytes();
            EntityUtils.consume((HttpEntity)response.getEntity());
            Assertions.assertEquals((Object)expectedRequest, resultString.get());
            Assertions.assertArrayEquals((byte[])"Franz jagt im komplett verwahrlosten Taxi quer durch Bayern".getBytes(), (byte[])responseBytes);
            CloseableByteArrayOutputStream req = this.logSink.getInbound().get(0);
            CloseableByteArrayOutputStream resp = this.logSink.getOutbound().get(0);
            Assertions.assertArrayEquals((byte[])expectedRequest.getBytes(), (byte[])req.toByteArray());
            Assertions.assertArrayEquals((byte[])"Franz jagt im komplett verwahrlosten Taxi quer durch Bayern".getBytes(), (byte[])resp.toByteArray());
            Assertions.assertTrue((boolean)req.isClosed());
            Assertions.assertTrue((boolean)resp.isClosed());
            Assertions.assertTrue((boolean)this.logSink.getInboundHeaders().get(0).get((Object)customHeaderKey).contains(customHeaderValue));
            Assertions.assertTrue((boolean)this.logSink.getOutboundHeaders().get(0).get((Object)"X-Server".toLowerCase()).contains("SDCri"));
            Assertions.assertFalse((boolean)this.logSink.getInboundHeaders().get(0).get((Object)customHeaderKey.toUpperCase()).contains(customHeaderValue));
            Assertions.assertFalse((boolean)this.logSink.getOutboundHeaders().get(0).get((Object)"X-Server").contains("SDCri"));
            Assertions.assertEquals((Object)CommunicationLog.MessageType.REQUEST, (Object)this.logSink.getInboundMessageType());
            Assertions.assertEquals((Object)CommunicationLog.MessageType.RESPONSE, (Object)this.logSink.getOutboundMessageType());
            this.compareTransactionIds(this.logSink.getInboundTransactionIds(), this.logSink.getOutboundTransactionIds());
            this.logSink.clear();
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    void testServerCommlog(boolean commLogInHandler) throws Exception {
        this.setUp(commLogInHandler);
        String baseUri = "http://127.0.0.1:0";
        String contextPath = "/ctxt/path1";
        String expectedRequest = "The quick brown fox jumps over the lazy dog";
        String expectedResponse = "Franz jagt im komplett verwahrlosten Taxi quer durch Bayern";
        final AtomicReference resultString = new AtomicReference();
        final AtomicReference commLogContextPresent = new AtomicReference();
        CommunicationLogContext commLogContext = new CommunicationLogContext("txetnoCgoLnoitacinummoC" + UUID.randomUUID());
        this.httpServerRegistry.startAsync().awaitRunning();
        String srvUri1 = this.httpServerRegistry.registerContext(baseUri, true, contextPath, null, commLogContext, new HttpHandler(){

            public void handle(InputStream inStream, OutputStream outStream, CommunicationContext communicationContext) {
                try {
                    byte[] bytes = inStream.readAllBytes();
                    resultString.set(new String(bytes));
                    if (communicationContext.getCommunicationLogContext() != null) {
                        commLogContextPresent.set(communicationContext.getCommunicationLogContext());
                    }
                    outStream.write("Franz jagt im komplett verwahrlosten Taxi quer durch Bayern".getBytes());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        CloseableHttpClient client = HttpClients.custom().setMaxConnPerRoute(1).build();
        HttpPost post = new HttpPost(srvUri1);
        String customHeaderKey = "thecustomheader";
        String customHeaderValue = "theCUSTOMvalue";
        post.setHeader(customHeaderKey, customHeaderValue);
        ByteArrayEntity requestEntity = new ByteArrayEntity("The quick brown fox jumps over the lazy dog".getBytes());
        requestEntity.setChunked(true);
        post.setEntity((HttpEntity)requestEntity);
        for (int i = 0; i < 10; ++i) {
            HttpResponse response = client.execute((HttpUriRequest)post);
            byte[] responseBytes = response.getEntity().getContent().readAllBytes();
            Thread.sleep(100L);
            EntityUtils.consume((HttpEntity)response.getEntity());
            Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog", resultString.get());
            Assertions.assertArrayEquals((byte[])"Franz jagt im komplett verwahrlosten Taxi quer durch Bayern".getBytes(), (byte[])responseBytes);
            Assertions.assertEquals((Object)commLogContext, commLogContextPresent.get());
            CloseableByteArrayOutputStream req = this.logSink.getInbound().get(0);
            CloseableByteArrayOutputStream resp = this.logSink.getOutbound().get(0);
            Assertions.assertArrayEquals((byte[])"The quick brown fox jumps over the lazy dog".getBytes(), (byte[])req.toByteArray());
            Assertions.assertArrayEquals((byte[])"Franz jagt im komplett verwahrlosten Taxi quer durch Bayern".getBytes(), (byte[])resp.toByteArray());
            Assertions.assertTrue((boolean)req.isClosed());
            Assertions.assertTrue((boolean)resp.isClosed());
            Assertions.assertTrue((boolean)this.logSink.getInboundHeaders().get(0).get((Object)customHeaderKey).contains(customHeaderValue));
            Assertions.assertTrue((boolean)this.logSink.getOutboundHeaders().get(0).get((Object)"X-Server".toLowerCase()).contains("SDCri"));
            Assertions.assertFalse((boolean)this.logSink.getInboundHeaders().get(0).get((Object)customHeaderKey.toUpperCase()).contains(customHeaderValue));
            Assertions.assertFalse((boolean)this.logSink.getOutboundHeaders().get(0).get((Object)"X-Server").contains("SDCri"));
            Assertions.assertEquals((Object)CommunicationLog.MessageType.REQUEST, (Object)this.logSink.getInboundMessageType());
            Assertions.assertEquals((Object)CommunicationLog.MessageType.RESPONSE, (Object)this.logSink.getOutboundMessageType());
            if (commLogInHandler) {
                Assertions.assertNotNull((Object)this.logSink.getInboundCommunicationContexts().get(0).getCommunicationLogContext());
                Assertions.assertNotNull((Object)this.logSink.getOutboundCommunicationContexts().get(0).getCommunicationLogContext());
            } else {
                Assertions.assertNull((Object)this.logSink.getInboundCommunicationContexts().get(0).getCommunicationLogContext());
                Assertions.assertNull((Object)this.logSink.getOutboundCommunicationContexts().get(0).getCommunicationLogContext());
            }
            this.compareTransactionIds(this.logSink.getInboundTransactionIds(), this.logSink.getOutboundTransactionIds());
            this.logSink.clear();
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    void testServerCommlogDuplicateKeys(boolean commLogInHandler) throws Exception {
        this.setUp(commLogInHandler);
        String baseUri = "http://127.0.0.1:0";
        String contextPath = "/ctxt/path1";
        String expectedRequest = "The quick brown fox jumps over the lazy dog";
        String expectedResponse = "Franz jagt im komplett verwahrlosten Taxi quer durch Bayern";
        final AtomicReference resultString = new AtomicReference();
        this.httpServerRegistry.startAsync().awaitRunning();
        String srvUri1 = this.httpServerRegistry.registerContext(baseUri, true, contextPath, null, null, new HttpHandler(){

            public void handle(InputStream inStream, OutputStream outStream, CommunicationContext communicationContext) {
                try {
                    byte[] bytes = inStream.readAllBytes();
                    resultString.set(new String(bytes));
                    outStream.write("Franz jagt im komplett verwahrlosten Taxi quer durch Bayern".getBytes());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        CloseableHttpClient client = HttpClients.custom().setMaxConnPerRoute(1).build();
        HttpPost post = new HttpPost(srvUri1);
        String customHeaderKey = "thecustomheader";
        String customHeaderValue = "theCUSTOMvalue";
        String customHeaderValue2 = "theCUSTOMvalue2";
        post.setHeader(customHeaderKey, customHeaderValue);
        post.addHeader(customHeaderKey.toUpperCase(), customHeaderValue2);
        ByteArrayEntity requestEntity = new ByteArrayEntity("The quick brown fox jumps over the lazy dog".getBytes());
        post.setEntity((HttpEntity)requestEntity);
        for (int i = 0; i < 100; ++i) {
            HttpResponse response = client.execute((HttpUriRequest)post);
            byte[] responseBytes = response.getEntity().getContent().readAllBytes();
            EntityUtils.consume((HttpEntity)response.getEntity());
            Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog", resultString.get());
            Assertions.assertArrayEquals((byte[])"Franz jagt im komplett verwahrlosten Taxi quer durch Bayern".getBytes(), (byte[])responseBytes);
            CloseableByteArrayOutputStream req = this.logSink.getInbound().get(0);
            CloseableByteArrayOutputStream resp = this.logSink.getOutbound().get(0);
            Assertions.assertArrayEquals((byte[])"The quick brown fox jumps over the lazy dog".getBytes(), (byte[])req.toByteArray());
            Assertions.assertArrayEquals((byte[])"Franz jagt im komplett verwahrlosten Taxi quer durch Bayern".getBytes(), (byte[])resp.toByteArray());
            Assertions.assertEquals((int)2, (int)this.logSink.getInboundHeaders().get(0).get((Object)customHeaderKey).size());
            Assertions.assertTrue((boolean)this.logSink.getInboundHeaders().get(0).get((Object)customHeaderKey).contains(customHeaderValue));
            Assertions.assertTrue((boolean)this.logSink.getInboundHeaders().get(0).get((Object)customHeaderKey).contains(customHeaderValue2));
            this.logSink.clear();
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    void testDuplicateTransactionIds(boolean commLogInHandler) throws Exception {
        this.setUp(commLogInHandler);
        Injector secondInjector = CommunicationLogIT.configureInjector(List.of(new DefaultDpwsConfigModule(){

            public void customConfigure() {
                this.bind("Dpws.GzipCompression", Boolean.class, true);
            }
        }, new AbstractModule(){

            protected void configure() {
                this.bind(CommunicationLogSink.class).toInstance((Object)CommunicationLogIT.this.logSink);
                this.install(new FactoryModuleBuilder().implement(CommunicationLog.class, CommunicationLogImpl.class).build(CommunicationLogFactory.class));
            }
        }));
        TransportBindingFactory secondTransportBindingFactory = (TransportBindingFactory)secondInjector.getInstance(TransportBindingFactory.class);
        ((JaxbMarshalling)secondInjector.getInstance(JaxbMarshalling.class)).startAsync().awaitRunning();
        TestCommLogSink secondLogSink = (TestCommLogSink)secondInjector.getInstance(CommunicationLogSink.class);
        SoapMarshalling secondMarshalling = (SoapMarshalling)secondInjector.getInstance(SoapMarshalling.class);
        secondMarshalling.startAsync().awaitRunning();
        URI baseUri = URI.create("http://127.0.0.1:0/");
        String expectedResponse = "Sehr geehrter Kaliba, netter Versuch\nKritische Texte, Weltverbesserer-Blues;";
        JAXBElement jaxbElement = new JAXBElement(new QName("root-element"), String.class, (Object)expectedResponse);
        SoapMessage responseEnvelope = this.createASoapMessage();
        responseEnvelope.getOriginalEnvelope().getBody().getAny().add(jaxbElement);
        CloseableByteArrayOutputStream expectedResponseStream = new CloseableByteArrayOutputStream();
        this.marshalling.marshal(responseEnvelope.getEnvelopeWithMappedHeaders(), (OutputStream)expectedResponseStream);
        byte[] responseBytes = expectedResponseStream.toByteArray();
        HttpServerUtil.GzipResponseHandler handler = new HttpServerUtil.GzipResponseHandler(responseBytes);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(baseUri.getHost(), baseUri.getPort());
        HttpServer server = HttpServerUtil.spawnHttpServer(inetSocketAddress, handler);
        baseUri = new URI(baseUri.getScheme(), baseUri.getUserInfo(), baseUri.getHost(), server.getAddress().getPort(), baseUri.getPath(), baseUri.getQuery(), baseUri.getFragment());
        TransportBinding httpBinding1 = this.transportBindingFactory.createHttpBinding(baseUri.toString(), null);
        TransportBinding httpBinding2 = secondTransportBindingFactory.createHttpBinding(baseUri.toString(), null);
        for (int i = 0; i < 100; ++i) {
            this.testSharedLogSink(this.marshalling, httpBinding1, this.logSink, expectedResponseStream);
            this.testSharedLogSink(secondMarshalling, httpBinding2, secondLogSink, expectedResponseStream);
            Assertions.assertEquals((Object)CommunicationLog.MessageType.RESPONSE, (Object)this.logSink.getInboundMessageType());
            Assertions.assertEquals((Object)CommunicationLog.MessageType.REQUEST, (Object)this.logSink.getOutboundMessageType());
            this.compareTransactionIds(this.logSink.getInboundTransactionIds(), this.logSink.getOutboundTransactionIds());
            this.logSink.clear();
        }
    }

    private void testSharedLogSink(SoapMarshalling soapMarshalling, TransportBinding httpBinding, TestCommLogSink logSink, ByteArrayOutputStream expectedResponseStream) throws Exception {
        SoapMessage requestMessage2 = this.createASoapMessage();
        CloseableByteArrayOutputStream actualRequestStream2 = new CloseableByteArrayOutputStream();
        soapMarshalling.marshal(requestMessage2.getEnvelopeWithMappedHeaders(), (OutputStream)actualRequestStream2);
        SoapMessage response2 = httpBinding.onRequestResponse(requestMessage2);
        CloseableByteArrayOutputStream actualResponseStream2 = new CloseableByteArrayOutputStream();
        soapMarshalling.marshal(response2.getEnvelopeWithMappedHeaders(), (OutputStream)actualResponseStream2);
        Assertions.assertArrayEquals((byte[])expectedResponseStream.toByteArray(), (byte[])actualResponseStream2.toByteArray());
        CloseableByteArrayOutputStream req2 = logSink.getOutbound().get(0);
        CloseableByteArrayOutputStream resp2 = logSink.getInbound().get(0);
        Assertions.assertArrayEquals((byte[])actualRequestStream2.toByteArray(), (byte[])req2.toByteArray());
        Assertions.assertArrayEquals((byte[])expectedResponseStream.toByteArray(), (byte[])resp2.toByteArray());
        Assertions.assertTrue((boolean)logSink.getOutboundHeaders().get(0).get((Object)"X-User-Agent".toLowerCase()).contains("SDCri"));
        Assertions.assertTrue((boolean)logSink.getInboundHeaders().get(0).get((Object)"SDCriTestHeader".toLowerCase()).contains("anAmazingValue"));
        Assertions.assertFalse((boolean)logSink.getOutboundHeaders().get(0).get((Object)"X-User-Agent").contains("SDCri"));
        Assertions.assertFalse((boolean)logSink.getInboundHeaders().get(0).get((Object)"SDCriTestHeader").contains("anAmazingValue"));
    }

    private void compareTransactionIds(ArrayList<String> inboundTransactionIds, ArrayList<String> outboundTransactionIds) {
        HashSet<String> inboundSet = new HashSet<String>(inboundTransactionIds);
        HashSet<String> outboundSet = new HashSet<String>(outboundTransactionIds);
        Assertions.assertEquals((int)inboundTransactionIds.size(), (int)inboundSet.size(), (String)"Duplicate Inbound TransactionIds.");
        Assertions.assertEquals((int)outboundTransactionIds.size(), (int)outboundSet.size(), (String)"Duplicate Outbound TransactionIds.");
        Assertions.assertEquals(inboundSet, outboundSet, (String)"Not all responses are associated with a request.");
    }

    private SoapMessage createASoapMessage() {
        return this.soapMessageFactory.createSoapMessage(this.envelopeFactory.createEnvelope());
    }

    static class TestCommLogSink
    implements CommunicationLogSink {
        private final ArrayList<CloseableByteArrayOutputStream> inbound = new ArrayList();
        private final ArrayList<CloseableByteArrayOutputStream> outbound = new ArrayList();
        private final ArrayList<ListMultimap<String, String>> inboundHeaders = new ArrayList();
        private final ArrayList<ListMultimap<String, String>> outboundHeaders = new ArrayList();
        private CommunicationLog.MessageType inboundMessageType;
        private CommunicationLog.MessageType outboundMessageType;
        private final ArrayList<String> inboundTransactionIds = new ArrayList();
        private final ArrayList<String> outboundTransactionIds = new ArrayList();
        private final ArrayList<CommunicationContext> inboundCommunicationContexts = new ArrayList();
        private final ArrayList<CommunicationContext> outboundCommunicationContexts = new ArrayList();

        TestCommLogSink() {
        }

        public OutputStream createTargetStream(CommunicationLog.TransportType path, CommunicationLog.Direction direction, CommunicationLog.MessageType messageType, CommunicationContext communicationContext) {
            CloseableByteArrayOutputStream os = new CloseableByteArrayOutputStream();
            HttpApplicationInfo appInfo = (HttpApplicationInfo)communicationContext.getApplicationInfo();
            if (CommunicationLog.Direction.INBOUND.equals((Object)direction)) {
                this.inbound.add(os);
                this.inboundHeaders.add((ListMultimap<String, String>)appInfo.getHeaders());
                this.inboundMessageType = messageType;
                this.inboundTransactionIds.add(((HttpApplicationInfo)communicationContext.getApplicationInfo()).getTransactionId());
                this.inboundCommunicationContexts.add(communicationContext);
            } else {
                this.outbound.add(os);
                this.outboundHeaders.add((ListMultimap<String, String>)appInfo.getHeaders());
                this.outboundMessageType = messageType;
                this.outboundTransactionIds.add(((HttpApplicationInfo)communicationContext.getApplicationInfo()).getTransactionId());
                this.outboundCommunicationContexts.add(communicationContext);
            }
            return os;
        }

        public ArrayList<CloseableByteArrayOutputStream> getInbound() {
            return this.inbound;
        }

        public ArrayList<CloseableByteArrayOutputStream> getOutbound() {
            return this.outbound;
        }

        public ArrayList<ListMultimap<String, String>> getInboundHeaders() {
            return this.inboundHeaders;
        }

        public ArrayList<ListMultimap<String, String>> getOutboundHeaders() {
            return this.outboundHeaders;
        }

        public void clear() {
            this.outbound.clear();
            this.inbound.clear();
            this.inboundHeaders.clear();
            this.outboundHeaders.clear();
            this.inboundCommunicationContexts.clear();
            this.outboundCommunicationContexts.clear();
        }

        public CommunicationLog.MessageType getOutboundMessageType() {
            return this.outboundMessageType;
        }

        public CommunicationLog.MessageType getInboundMessageType() {
            return this.inboundMessageType;
        }

        public ArrayList<String> getInboundTransactionIds() {
            return this.inboundTransactionIds;
        }

        public ArrayList<String> getOutboundTransactionIds() {
            return this.outboundTransactionIds;
        }

        public ArrayList<CommunicationContext> getInboundCommunicationContexts() {
            return this.inboundCommunicationContexts;
        }

        public ArrayList<CommunicationContext> getOutboundCommunicationContexts() {
            return this.outboundCommunicationContexts;
        }
    }

    static class CloseableByteArrayOutputStream
    extends ByteArrayOutputStream {
        private boolean closed = false;

        CloseableByteArrayOutputStream() {
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.closed = true;
        }

        private void ensureNotClosed() {
            if (this.closed) {
                throw new RuntimeException("Stream closed");
            }
        }

        @Override
        public synchronized void write(int b) {
            this.ensureNotClosed();
            super.write(b);
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) {
            this.ensureNotClosed();
            super.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.ensureNotClosed();
            super.write(b);
        }

        public boolean isClosed() {
            return this.closed;
        }
    }

    static class SlowInputStream
    extends InputStream {
        private final byte[] payload;
        private final long delayMs;
        private int nextIndex;

        SlowInputStream(byte[] payload, int sleep) {
            this.payload = payload;
            this.delayMs = sleep;
            this.nextIndex = 0;
        }

        @Override
        public int read() throws IOException {
            if (this.nextIndex % 10000 == 0) {
                try {
                    Thread.sleep(this.delayMs);
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            }
            if (this.payload.length <= this.nextIndex) {
                return -1;
            }
            return this.payload[this.nextIndex++];
        }
    }
}

