/*
 * Decompiled with CFR 0.152.
 */
package it.org.somda.sdc.dpws.soap;

import com.google.common.io.ByteStreams;
import com.google.inject.AbstractModule;
import it.org.somda.sdc.dpws.soap.DevicePeer;
import it.org.somda.sdc.dpws.soap.DpwsTestService1;
import it.org.somda.sdc.dpws.soap.DpwsTestService2;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import org.somda.sdc.dpws.DpwsFramework;
import org.somda.sdc.dpws.DpwsUtil;
import org.somda.sdc.dpws.device.DeviceSettings;
import org.somda.sdc.dpws.device.WebService;
import org.somda.sdc.dpws.guice.DefaultDpwsConfigModule;
import org.somda.sdc.dpws.service.factory.HostedServiceFactory;
import org.somda.sdc.dpws.soap.TransportInfo;

public class BasicPopulatedDevice
extends DevicePeer {
    public static final String SCOPE_1 = "http://integration-test-scope1";
    public static final String SCOPE_2 = "http://integration-test-scope2";
    public static final QName QNAME_1 = new QName("http://type-ns", "integration-test-type1");
    public static final QName QNAME_2 = new QName("http://type-ns", "integration-test-type2");
    private final DpwsFramework dpwsFramework;
    private DpwsTestService1 service1;
    private DpwsTestService2 service2;
    List<TransportInfo> transportInfos;

    public BasicPopulatedDevice() {
        this(null, null);
    }

    public BasicPopulatedDevice(@Nullable DeviceSettings deviceSettings, @Nullable AbstractModule overridingModule) {
        this.setup(new DefaultDpwsConfigModule(){

            public void customConfigure() {
                this.bind("SoapConfig.JaxbContextPath", String.class, "dpws_test_service.messages._2017._05._10");
            }
        }, deviceSettings, overridingModule);
        this.dpwsFramework = (DpwsFramework)this.getInjector().getInstance(DpwsFramework.class);
        this.transportInfos = new ArrayList<TransportInfo>();
        this.service1 = (DpwsTestService1)((Object)this.getInjector().getInstance(DpwsTestService1.class));
        this.service2 = (DpwsTestService2)((Object)this.getInjector().getInstance(DpwsTestService2.class));
    }

    public BasicPopulatedDevice(@Nullable AbstractModule overridingModule) {
        this(null, overridingModule);
    }

    public BasicPopulatedDevice(@Nullable DeviceSettings deviceSettings, DefaultDpwsConfigModule configModule, @Nullable AbstractModule overridingModule) {
        configModule.bind("SoapConfig.JaxbContextPath", String.class, (Object)"dpws_test_service.messages._2017._05._10");
        this.setup(configModule, deviceSettings, overridingModule);
        this.dpwsFramework = (DpwsFramework)this.getInjector().getInstance(DpwsFramework.class);
        this.transportInfos = new ArrayList<TransportInfo>();
        this.service1 = (DpwsTestService1)((Object)this.getInjector().getInstance(DpwsTestService1.class));
        this.service2 = (DpwsTestService2)((Object)this.getInjector().getInstance(DpwsTestService2.class));
    }

    public DpwsTestService1 getService1() {
        return this.service1;
    }

    public DpwsTestService2 getService2() {
        return this.service2;
    }

    public List<TransportInfo> getTransportInfosReceivedFromService1() {
        return this.transportInfos;
    }

    protected void startUp() throws IOException {
        this.getDevice().getDiscoveryAccess().setScopes(Arrays.asList(SCOPE_1, SCOPE_2));
        this.getDevice().getDiscoveryAccess().setTypes(Arrays.asList(QNAME_1, QNAME_2));
        DpwsUtil dpwsUtil = (DpwsUtil)this.getInjector().getInstance(DpwsUtil.class);
        this.getDevice().getHostingServiceAccess().setThisDevice(dpwsUtil.createThisDevice(dpwsUtil.createLocalizedStrings("en", "BasicPopulatedDevice peer").get(), null, null));
        HostedServiceFactory hostedServiceFactory = (HostedServiceFactory)this.getInjector().getInstance(HostedServiceFactory.class);
        this.service1.setTransportInfoCallback(this.transportInfos::add);
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        InputStream wsdlResource1 = classLoader.getResourceAsStream("it/org/somda/sdc/dpws/TestService1.wsdl");
        InputStream wsdlResource2 = classLoader.getResourceAsStream("it/org/somda/sdc/dpws/TestService2.wsdl");
        assert (wsdlResource1 != null);
        this.getDevice().getHostingServiceAccess().addHostedService(hostedServiceFactory.createHostedService("TestService1", Arrays.asList(new QName("http://dpws-test-service/2017/05/10", "TestPortType1"), new QName("http://dpws-test-service/2017/05/10", "TestPortType2")), (WebService)this.service1, ByteStreams.toByteArray((InputStream)wsdlResource1)));
        assert (wsdlResource2 != null);
        this.getDevice().getHostingServiceAccess().addHostedService(hostedServiceFactory.createHostedService("TestService2", Collections.singletonList(new QName("http://dpws-test-service/2017/05/10", "TestPortType3")), (WebService)this.service2, ByteStreams.toByteArray((InputStream)wsdlResource2)));
        this.dpwsFramework.startAsync().awaitRunning();
        this.getDevice().startAsync().awaitRunning();
    }

    protected void shutDown() {
        this.getDevice().stopAsync().awaitTerminated();
        this.dpwsFramework.stopAsync().awaitTerminated();
    }
}

