/*
 * Decompiled with CFR 0.152.
 */
package it.org.somda.sdc.dpws.soap;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.AbstractModule;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import dpws_test_service.messages._2017._05._10.ObjectFactory;
import dpws_test_service.messages._2017._05._10.TestNotification;
import dpws_test_service.messages._2017._05._10.TestOperationRequest;
import it.org.somda.sdc.dpws.IntegrationTestUtil;
import it.org.somda.sdc.dpws.MockedUdpBindingModule;
import it.org.somda.sdc.dpws.soap.BasicPopulatedDevice;
import it.org.somda.sdc.dpws.soap.ClientPeer;
import it.org.somda.sdc.dpws.soap.Ssl;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.somda.sdc.dpws.CommunicationLog;
import org.somda.sdc.dpws.CommunicationLogImpl;
import org.somda.sdc.dpws.CommunicationLogSink;
import org.somda.sdc.dpws.client.DiscoveredDevice;
import org.somda.sdc.dpws.crypto.CryptoSettings;
import org.somda.sdc.dpws.device.DeviceSettings;
import org.somda.sdc.dpws.factory.CommunicationLogFactory;
import org.somda.sdc.dpws.guice.DefaultDpwsConfigModule;
import org.somda.sdc.dpws.service.HostedServiceProxy;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.TransportInfo;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.NotificationObject;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ProbeMatchType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ProbeMatchesType;
import test.org.somda.common.LoggingTestWatcher;

@ExtendWith(value={LoggingTestWatcher.class})
class CryptoIT {
    private static final Duration MAX_WAIT_TIME = Duration.ofMinutes(3L);
    private final IntegrationTestUtil IT = new IntegrationTestUtil();
    private final SoapUtil soapUtil = (SoapUtil)this.IT.getInjector().getInstance(SoapUtil.class);
    private final WsAddressingUtil wsaUtil = (WsAddressingUtil)this.IT.getInjector().getInstance(WsAddressingUtil.class);
    private BasicPopulatedDevice devicePeer;
    private ClientPeer clientPeer;
    private HostnameVerifier verifier;
    private TestCommLogSink logSink;
    private X509Certificate clientCertificate;
    private X509Certificate serverCertificate;

    CryptoIT() {
        IntegrationTestUtil.preferIpV4Usage();
    }

    @BeforeEach
    void setUp() {
        final CryptoSettings serverCryptoSettings = Ssl.setupServer();
        this.verifier = (HostnameVerifier)Mockito.mock(HostnameVerifier.class);
        Mockito.when((Object)this.verifier.verify(ArgumentMatchers.anyString(), (SSLSession)ArgumentMatchers.any())).thenReturn((Object)true);
        this.devicePeer = new BasicPopulatedDevice(new DeviceSettings(){
            final EndpointReferenceType epr;
            {
                this.epr = CryptoIT.this.wsaUtil.createEprWithAddress(CryptoIT.this.soapUtil.createUriFromUuid(UUID.randomUUID()));
            }

            public EndpointReferenceType getEndpointReference() {
                return this.epr;
            }

            public NetworkInterface getNetworkInterface() {
                try {
                    return NetworkInterface.getByInetAddress(InetAddress.getLoopbackAddress());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, new DefaultDpwsConfigModule(){

            public void customConfigure() {
                this.bind("Dpws.Crypto.Settings", CryptoSettings.class, serverCryptoSettings);
                this.bind("Dpws.EnableHttp", Boolean.class, false);
                this.bind("Dpws.EnableHttps", Boolean.class, true);
                this.bind("Dpws.Crypto.DeviceHostnameVerifier", HostnameVerifier.class, CryptoIT.this.verifier);
                this.bind("Dpws.Crypto.TlsEnabledVersions", String[].class, new String[]{"TLSv1.3"});
                this.bind("Dpws.Crypto.TlsEnabledCiphers", String[].class, new String[]{"TLS_AES_128_GCM_SHA256"});
            }
        }, new MockedUdpBindingModule());
        final CryptoSettings clientCryptoSettings = Ssl.setupClient();
        try {
            this.clientPeer = new ClientPeer(new DefaultDpwsConfigModule(){

                public void customConfigure() {
                    this.bind("WsDiscovery.MaxWaitForProbeMatches", Duration.class, Duration.ofSeconds(MAX_WAIT_TIME.getSeconds() / 2L));
                    this.bind("Dpws.Crypto.Settings", CryptoSettings.class, clientCryptoSettings);
                    this.bind("SoapConfig.JaxbContextPath", String.class, "dpws_test_service.messages._2017._05._10");
                    this.bind("Dpws.Crypto.TlsEnabledVersions", String[].class, new String[]{"TLSv1.3"});
                    this.bind("Dpws.Crypto.TlsEnabledCiphers", String[].class, new String[]{"TLS_AES_128_GCM_SHA256"});
                    this.bind("Dpws.EnableHttp", Boolean.class, false);
                    this.bind("Dpws.EnableHttps", Boolean.class, true);
                }
            }, new MockedUdpBindingModule(), new AbstractModule(){

                protected void configure() {
                    this.bind(CommunicationLogSink.class).to(TestCommLogSink.class).asEagerSingleton();
                    this.install(new FactoryModuleBuilder().implement(CommunicationLog.class, CommunicationLogImpl.class).build(CommunicationLogFactory.class));
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logSink = (TestCommLogSink)this.clientPeer.getInjector().getInstance(CommunicationLogSink.class);
        this.clientCertificate = Ssl.getClientCertificate();
        this.serverCertificate = Ssl.getServerCertificate();
    }

    @AfterEach
    void tearDown() {
        this.devicePeer.stopAsync().awaitTerminated();
        this.clientPeer.stopAsync().awaitTerminated();
        this.logSink.clear();
    }

    @Test
    void testDirectedProbeSecured() throws Exception {
        this.devicePeer.startAsync().awaitRunning();
        this.clientPeer.startAsync().awaitRunning();
        DiscoveredDevice discoveredDevice = (DiscoveredDevice)this.clientPeer.getClient().resolve(this.devicePeer.getEprAddress()).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        List xAddrs = discoveredDevice.getXAddrs();
        Assertions.assertFalse((boolean)xAddrs.isEmpty());
        String uri = (String)xAddrs.get(0);
        String expectedEprAddress = this.devicePeer.getEprAddress();
        Assertions.assertEquals((Object)expectedEprAddress, (Object)((ProbeMatchType)((ProbeMatchesType)this.clientPeer.getClient().directedProbe(uri).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS)).getProbeMatch().get(0)).getEndpointReference().getAddress().getValue());
    }

    @Test
    void testTransportInfoInRequestResponse() throws Exception {
        this.devicePeer.startAsync().awaitRunning();
        this.clientPeer.startAsync().awaitRunning();
        ListenableFuture connectFuture = this.clientPeer.getClient().connect(this.devicePeer.getEprAddress());
        HostingServiceProxy hostingServiceProxy = (HostingServiceProxy)connectFuture.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        HostedServiceProxy hostedServiceProxy = (HostedServiceProxy)hostingServiceProxy.getHostedServices().get("TestService1");
        Assertions.assertNotNull((Object)hostedServiceProxy);
        TestOperationRequest request = new TestOperationRequest();
        request.setParam1("testString");
        request.setParam2(11);
        SoapMessage reqMsg = ((SoapUtil)this.clientPeer.getInjector().getInstance(SoapUtil.class)).createMessage("http://dpws-test-service/2017/05/10/TestPortType1/TestOperationRequest", (Object)request);
        hostedServiceProxy.getRequestResponseClient().sendRequestResponse(reqMsg);
        Assertions.assertEquals((int)1, (int)this.devicePeer.getTransportInfosReceivedFromService1().size());
        Assertions.assertFalse((boolean)this.devicePeer.getTransportInfosReceivedFromService1().get(0).getX509Certificates().isEmpty());
    }

    @Test
    void testTransportInfoInRequestResponseServer() throws Exception {
        this.devicePeer.startAsync().awaitRunning();
        this.clientPeer.startAsync().awaitRunning();
        ListenableFuture connectFuture = this.clientPeer.getClient().connect(this.devicePeer.getEprAddress());
        HostingServiceProxy hostingServiceProxy = (HostingServiceProxy)connectFuture.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        HostedServiceProxy hostedServiceProxy = (HostedServiceProxy)hostingServiceProxy.getHostedServices().get("TestService1");
        Assertions.assertNotNull((Object)hostedServiceProxy);
        TestOperationRequest request = new TestOperationRequest();
        request.setParam1("testString");
        request.setParam2(11);
        SoapMessage reqMsg = ((SoapUtil)this.clientPeer.getInjector().getInstance(SoapUtil.class)).createMessage("http://dpws-test-service/2017/05/10/TestPortType1/TestOperationRequest", (Object)request);
        long numberBeforeRR = this.logSink.getInboundTransportInfos().stream().filter(info -> info.getX509Certificates().size() > 0).count();
        hostedServiceProxy.getRequestResponseClient().sendRequestResponse(reqMsg);
        long numberAfterRR = this.logSink.getInboundTransportInfos().stream().filter(info -> info.getX509Certificates().size() > 0).count();
        Assertions.assertEquals((long)1L, (long)(numberAfterRR - numberBeforeRR));
        for (X509Certificate certificate : this.logSink.getInboundTransportInfos().stream().map(TransportInfo::getX509Certificates).flatMap(Collection::stream).collect(Collectors.toList())) {
            Assertions.assertEquals((Object)this.serverCertificate, (Object)certificate);
        }
    }

    @Test
    void testTransportInfoInRequestResponseClient() throws Exception {
        this.devicePeer.startAsync().awaitRunning();
        this.clientPeer.startAsync().awaitRunning();
        ListenableFuture connectFuture = this.clientPeer.getClient().connect(this.devicePeer.getEprAddress());
        HostingServiceProxy hostingServiceProxy = (HostingServiceProxy)connectFuture.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        HostedServiceProxy hostedServiceProxy = (HostedServiceProxy)hostingServiceProxy.getHostedServices().get("TestService1");
        Assertions.assertNotNull((Object)hostedServiceProxy);
        TestOperationRequest request = new TestOperationRequest();
        request.setParam1("testString");
        request.setParam2(11);
        SoapMessage reqMsg = ((SoapUtil)this.clientPeer.getInjector().getInstance(SoapUtil.class)).createMessage("http://dpws-test-service/2017/05/10/TestPortType1/TestOperationRequest", (Object)request);
        long numberBeforeRR = this.logSink.getOutboundTransportInfos().stream().filter(info -> info.getX509Certificates().size() > 0).count();
        hostedServiceProxy.getRequestResponseClient().sendRequestResponse(reqMsg);
        long numberAfterRR = this.logSink.getOutboundTransportInfos().stream().filter(info -> info.getX509Certificates().size() > 0).count();
        Assertions.assertEquals((long)1L, (long)(numberAfterRR - numberBeforeRR));
        for (X509Certificate certificate : this.logSink.getOutboundTransportInfos().stream().map(TransportInfo::getX509Certificates).flatMap(Collection::stream).collect(Collectors.toList())) {
            Assertions.assertEquals((Object)this.clientCertificate, (Object)certificate);
        }
    }

    @Test
    void testNotificationSecured() throws Exception {
        this.devicePeer.startAsync().awaitRunning();
        this.clientPeer.startAsync().awaitRunning();
        HostingServiceProxy hostingServiceProxy = (HostingServiceProxy)this.clientPeer.getClient().connect(this.devicePeer.getEprAddress()).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        int COUNT = 100;
        final SettableFuture notificationFuture = SettableFuture.create();
        HostedServiceProxy srv1 = (HostedServiceProxy)hostingServiceProxy.getHostedServices().get("TestService1");
        ListenableFuture subscribe = srv1.getEventSinkAccess().subscribe(Collections.singletonList("http://dpws-test-service/2017/05/10/TestPortType1/TestNotification"), Duration.ofMinutes(1L), new Interceptor(){
            private final List<TestNotification> receivedNotifications = new ArrayList<TestNotification>();

            @MessageInterceptor(value="http://dpws-test-service/2017/05/10/TestPortType1/TestNotification")
            void onNotification(NotificationObject message) {
                Assertions.assertTrue((boolean)message.getCommunicationContext().isPresent());
                Assertions.assertFalse((boolean)((CommunicationContext)message.getCommunicationContext().get()).getTransportInfo().getX509Certificates().isEmpty());
                this.receivedNotifications.add((TestNotification)CryptoIT.this.soapUtil.getBody(message.getNotification(), TestNotification.class).orElseThrow(() -> new RuntimeException("TestNotification could not be converted")));
                if (this.receivedNotifications.size() == 100) {
                    notificationFuture.set(this.receivedNotifications);
                }
            }
        });
        subscribe.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        ObjectFactory factory = (ObjectFactory)this.IT.getInjector().getInstance(ObjectFactory.class);
        for (int i = 0; i < 100; ++i) {
            TestNotification testNotification = factory.createTestNotification();
            testNotification.setParam1(Integer.toString(i));
            testNotification.setParam2(i);
            this.devicePeer.getService1().sendNotification(testNotification);
        }
        List notifications = (List)notificationFuture.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        Assertions.assertEquals((int)100, (int)notifications.size());
        for (int i = 0; i < 100; ++i) {
            TestNotification notification = (TestNotification)notifications.get(i);
            Assertions.assertEquals((Object)Integer.toString(i), (Object)notification.getParam1());
            Assertions.assertEquals((int)i, (int)notification.getParam2());
        }
    }

    @Test
    void testDeviceHostnameVerifierCalled() throws Exception {
        this.devicePeer.startAsync().awaitRunning();
        this.clientPeer.startAsync().awaitRunning();
        DiscoveredDevice discoveredDevice = (DiscoveredDevice)this.clientPeer.getClient().resolve(this.devicePeer.getEprAddress()).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        List xAddrs = discoveredDevice.getXAddrs();
        Assertions.assertFalse((boolean)xAddrs.isEmpty());
        String uri = (String)xAddrs.get(0);
        String expectedEprAddress = this.devicePeer.getEprAddress();
        for (int i = 0; i < 5; ++i) {
            Assertions.assertEquals((Object)expectedEprAddress, (Object)((ProbeMatchType)((ProbeMatchesType)this.clientPeer.getClient().directedProbe(uri).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS)).getProbeMatch().get(0)).getEndpointReference().getAddress().getValue());
        }
        ((HostnameVerifier)Mockito.verify((Object)this.verifier, (VerificationMode)Mockito.times((int)2))).verify((String)ArgumentMatchers.any(), (SSLSession)ArgumentMatchers.any());
    }

    @Test
    void testConfigureTlsVersionServer() throws Exception {
        final CryptoSettings clientCryptoSettings = Ssl.setupClient();
        this.clientPeer = new ClientPeer(new DefaultDpwsConfigModule(){

            public void customConfigure() {
                this.bind("WsDiscovery.MaxWaitForProbeMatches", Duration.class, Duration.ofSeconds(MAX_WAIT_TIME.getSeconds() / 2L));
                this.bind("Dpws.Crypto.Settings", CryptoSettings.class, clientCryptoSettings);
                this.bind("Dpws.EnableHttp", Boolean.class, false);
                this.bind("Dpws.EnableHttps", Boolean.class, true);
                this.bind("SoapConfig.JaxbContextPath", String.class, "dpws_test_service.messages._2017._05._10");
                this.bind("Dpws.Crypto.TlsEnabledVersions", String[].class, new String[]{"TLSv1.2"});
            }
        }, new MockedUdpBindingModule());
        this.devicePeer.startAsync().awaitRunning();
        this.clientPeer.startAsync().awaitRunning();
        DiscoveredDevice discoveredDevice = (DiscoveredDevice)this.clientPeer.getClient().resolve(this.devicePeer.getEprAddress()).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        List xAddrs = discoveredDevice.getXAddrs();
        Assertions.assertFalse((boolean)xAddrs.isEmpty());
        String uri = (String)xAddrs.get(0);
        Assertions.assertThrows(ExecutionException.class, () -> ((ProbeMatchType)((ProbeMatchesType)this.clientPeer.getClient().directedProbe(uri).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS)).getProbeMatch().get(0)).getEndpointReference().getAddress().getValue());
    }

    @Test
    void testConfigureTlsCiphers() throws Exception {
        final CryptoSettings clientCryptoSettings = Ssl.setupClient();
        this.clientPeer = new ClientPeer(new DefaultDpwsConfigModule(){

            public void customConfigure() {
                this.bind("WsDiscovery.MaxWaitForProbeMatches", Duration.class, Duration.ofSeconds(MAX_WAIT_TIME.getSeconds() / 2L));
                this.bind("Dpws.Crypto.Settings", CryptoSettings.class, clientCryptoSettings);
                this.bind("SoapConfig.JaxbContextPath", String.class, "dpws_test_service.messages._2017._05._10");
                this.bind("Dpws.EnableHttp", Boolean.class, false);
                this.bind("Dpws.EnableHttps", Boolean.class, true);
                this.bind("Dpws.Crypto.TlsEnabledVersions", String[].class, new String[]{"TLSv1.3"});
                this.bind("Dpws.Crypto.TlsEnabledCiphers", String[].class, new String[]{"TLS_AES_256_GCM_SHA384"});
            }
        }, new MockedUdpBindingModule());
        this.devicePeer.startAsync().awaitRunning();
        this.clientPeer.startAsync().awaitRunning();
        DiscoveredDevice discoveredDevice = (DiscoveredDevice)this.clientPeer.getClient().resolve(this.devicePeer.getEprAddress()).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        List xAddrs = discoveredDevice.getXAddrs();
        Assertions.assertFalse((boolean)xAddrs.isEmpty());
        String uri = (String)xAddrs.get(0);
        Assertions.assertThrows(ExecutionException.class, () -> ((ProbeMatchType)((ProbeMatchesType)this.clientPeer.getClient().directedProbe(uri).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS)).getProbeMatch().get(0)).getEndpointReference().getAddress().getValue());
    }

    @Test
    void testClientPlainServerEncrypted() throws Exception {
        final CryptoSettings clientCryptoSettings = Ssl.setupClient();
        this.clientPeer = new ClientPeer(new DefaultDpwsConfigModule(){

            public void customConfigure() {
                this.bind("WsDiscovery.MaxWaitForProbeMatches", Duration.class, Duration.ofSeconds(MAX_WAIT_TIME.getSeconds() / 2L));
                this.bind("Dpws.Crypto.Settings", CryptoSettings.class, clientCryptoSettings);
                this.bind("SoapConfig.JaxbContextPath", String.class, "dpws_test_service.messages._2017._05._10");
                this.bind("Dpws.EnableHttp", Boolean.class, true);
                this.bind("Dpws.EnableHttps", Boolean.class, false);
                this.bind("Dpws.Crypto.TlsEnabledVersions", String[].class, new String[]{"TLSv1.3"});
                this.bind("Dpws.Crypto.TlsEnabledCiphers", String[].class, new String[]{"TLS_AES_256_GCM_SHA384"});
            }
        }, new MockedUdpBindingModule());
        this.devicePeer.startAsync().awaitRunning();
        this.clientPeer.startAsync().awaitRunning();
        DiscoveredDevice discoveredDevice = (DiscoveredDevice)this.clientPeer.getClient().resolve(this.devicePeer.getEprAddress()).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        List xAddrs = discoveredDevice.getXAddrs();
        Assertions.assertFalse((boolean)xAddrs.isEmpty());
        String uri = (String)xAddrs.get(0);
        Assertions.assertThrows(ExecutionException.class, () -> ((ProbeMatchType)((ProbeMatchesType)this.clientPeer.getClient().directedProbe(uri).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS)).getProbeMatch().get(0)).getEndpointReference().getAddress().getValue());
    }

    @Test
    void testNotificationSecuredMixedModeClient() throws Exception {
        this.clientPeer = new ClientPeer(new DefaultDpwsConfigModule(){

            public void customConfigure() {
                this.bind("WsDiscovery.MaxWaitForProbeMatches", Duration.class, Duration.ofSeconds(MAX_WAIT_TIME.getSeconds() / 2L));
                this.bind("Dpws.Crypto.Settings", CryptoSettings.class, Ssl.setupClient());
                this.bind("SoapConfig.JaxbContextPath", String.class, "dpws_test_service.messages._2017._05._10");
                this.bind("Dpws.Crypto.TlsEnabledVersions", String[].class, new String[]{"TLSv1.3"});
                this.bind("Dpws.Crypto.TlsEnabledCiphers", String[].class, new String[]{"TLS_AES_128_GCM_SHA256"});
                this.bind("Dpws.EnableHttp", Boolean.class, true);
                this.bind("Dpws.EnableHttps", Boolean.class, true);
            }
        }, new MockedUdpBindingModule());
        this.testNotificationSecured();
    }

    @Test
    void testNotificationSecuredMixedModeServer() throws Exception {
        this.devicePeer = new BasicPopulatedDevice(new DeviceSettings(){
            final EndpointReferenceType epr;
            {
                this.epr = CryptoIT.this.wsaUtil.createEprWithAddress(CryptoIT.this.soapUtil.createUriFromUuid(UUID.randomUUID()));
            }

            public EndpointReferenceType getEndpointReference() {
                return this.epr;
            }

            public NetworkInterface getNetworkInterface() {
                try {
                    return NetworkInterface.getByInetAddress(InetAddress.getLoopbackAddress());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, new DefaultDpwsConfigModule(){

            public void customConfigure() {
                this.bind("Dpws.Crypto.Settings", CryptoSettings.class, Ssl.setupServer());
                this.bind("Dpws.EnableHttp", Boolean.class, true);
                this.bind("Dpws.EnableHttps", Boolean.class, true);
                this.bind("Dpws.Crypto.DeviceHostnameVerifier", HostnameVerifier.class, CryptoIT.this.verifier);
                this.bind("Dpws.Crypto.TlsEnabledVersions", String[].class, new String[]{"TLSv1.3"});
                this.bind("Dpws.Crypto.TlsEnabledCiphers", String[].class, new String[]{"TLS_AES_128_GCM_SHA256"});
            }
        }, new MockedUdpBindingModule());
        this.testNotificationSecured();
    }

    static class TestCommLogSink
    implements CommunicationLogSink {
        private final ArrayList<TransportInfo> inboundTransportInfos = new ArrayList();
        private final ArrayList<TransportInfo> outboundTransportInfos = new ArrayList();

        TestCommLogSink() {
        }

        public OutputStream createTargetStream(CommunicationLog.TransportType path, CommunicationLog.Direction direction, CommunicationLog.MessageType messageType, CommunicationContext communicationContext) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            if (CommunicationLog.Direction.INBOUND.equals((Object)direction)) {
                this.inboundTransportInfos.add(communicationContext.getTransportInfo());
            } else {
                this.outboundTransportInfos.add(communicationContext.getTransportInfo());
            }
            return os;
        }

        public void clear() {
            this.inboundTransportInfos.clear();
            this.outboundTransportInfos.clear();
        }

        public ArrayList<TransportInfo> getInboundTransportInfos() {
            return this.inboundTransportInfos;
        }

        public ArrayList<TransportInfo> getOutboundTransportInfos() {
            return this.outboundTransportInfos;
        }
    }
}

