/*
 * Decompiled with CFR 0.152.
 */
package it.org.somda.sdc.dpws.soap;

import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import dpws_test_service.messages._2017._05._10.TestNotification;
import dpws_test_service.messages._2017._05._10.TestOperationRequest;
import dpws_test_service.messages._2017._05._10.TestOperationResponse;
import it.org.somda.sdc.dpws.IntegrationTestPeer;
import it.org.somda.sdc.dpws.MockedUdpBindingModule;
import it.org.somda.sdc.dpws.soap.DpwsTestService1;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.somda.sdc.dpws.DpwsFramework;
import org.somda.sdc.dpws.DpwsUtil;
import org.somda.sdc.dpws.client.Client;
import org.somda.sdc.dpws.device.Device;
import org.somda.sdc.dpws.device.DeviceSettings;
import org.somda.sdc.dpws.device.WebService;
import org.somda.sdc.dpws.device.factory.DeviceFactory;
import org.somda.sdc.dpws.guice.DefaultDpwsConfigModule;
import org.somda.sdc.dpws.service.HostedServiceProxy;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.dpws.service.factory.HostedServiceFactory;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.NotificationObject;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wseventing.SubscribeResult;
import test.org.somda.common.TimedWait;

public class DeviceAndClientPeer
extends IntegrationTestPeer {
    public static final String SCOPE_1 = "http://integration-test-scope1";
    public static final String SCOPE_2 = "http://integration-test-scope2";
    public static final QName QNAME_1 = new QName("http://type-ns", "integration-test-type1");
    public static final QName QNAME_2 = new QName("http://type-ns", "integration-test-type2");
    public static final int NOTIFICATION_COUNT = 3;
    private ListeningExecutorService executorService;
    private Device device;
    private Client client;
    private DpwsFramework dpwsFramework;
    private DpwsTestService1 service1;
    private final Duration defaultMaxWait = Duration.ofSeconds(10L);
    private final SoapUtil soapUtil;
    private Thread notificationThread;

    public DeviceAndClientPeer(String localDeviceEprAddress) {
        this.setupInjector(new DefaultDpwsConfigModule(){

            public void customConfigure() {
                this.bind("SoapConfig.JaxbContextPath", String.class, "dpws_test_service.messages._2017._05._10");
            }
        }, new MockedUdpBindingModule());
        this.soapUtil = (SoapUtil)this.getInjector().getInstance(SoapUtil.class);
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(10));
        WsAddressingUtil wsaUtil = (WsAddressingUtil)this.getInjector().getInstance(WsAddressingUtil.class);
        final EndpointReferenceType epr = wsaUtil.createEprWithAddress(localDeviceEprAddress);
        DeviceSettings deviceSettings = new DeviceSettings(){

            public EndpointReferenceType getEndpointReference() {
                return epr;
            }

            public NetworkInterface getNetworkInterface() {
                try {
                    return NetworkInterface.getByInetAddress(InetAddress.getLoopbackAddress());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.dpwsFramework = (DpwsFramework)this.getInjector().getInstance(DpwsFramework.class);
        this.client = (Client)this.getInjector().getInstance(Client.class);
        this.device = ((DeviceFactory)this.getInjector().getInstance(DeviceFactory.class)).createDevice(deviceSettings);
    }

    protected void startUp() throws Exception {
        this.device.getDiscoveryAccess().setScopes(Arrays.asList(SCOPE_1, SCOPE_2));
        this.device.getDiscoveryAccess().setTypes(Arrays.asList(QNAME_1, QNAME_2));
        DpwsUtil dpwsUtil = (DpwsUtil)this.getInjector().getInstance(DpwsUtil.class);
        this.device.getHostingServiceAccess().setThisDevice(dpwsUtil.createThisDevice(dpwsUtil.createLocalizedStrings("en", "Peer with device and client").get(), null, null));
        HostedServiceFactory hostedServiceFactory = (HostedServiceFactory)this.getInjector().getInstance(HostedServiceFactory.class);
        this.service1 = (DpwsTestService1)((Object)this.getInjector().getInstance(DpwsTestService1.class));
        ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        InputStream wsdlResource1 = classLoader.getResourceAsStream("it/org/somda/sdc/dpws/TestService1.wsdl");
        assert (wsdlResource1 != null);
        this.device.getHostingServiceAccess().addHostedService(hostedServiceFactory.createHostedService("TestService1", Arrays.asList(new QName("http://dpws-test-service/2017/05/10", "TestPortType1"), new QName("http://dpws-test-service/2017/05/10", "TestPortType2")), (WebService)this.service1, ByteStreams.toByteArray((InputStream)wsdlResource1)));
        this.dpwsFramework.startAsync().awaitRunning();
        this.device.startAsync().awaitRunning();
        this.client.startAsync().awaitRunning();
        this.notificationThread = new Thread(() -> {
            while (!Thread.interrupted()) {
                try {
                    TestNotification notification = new TestNotification();
                    notification.setParam1("notification");
                    notification.setParam2(100);
                    this.service1.sendNotification(notification);
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (MarshallingException | TransportException e) {
                    e.printStackTrace();
                }
            }
        });
        this.notificationThread.start();
    }

    protected void shutDown() throws Exception {
        this.notificationThread.interrupt();
        this.device.stopAsync().awaitTerminated();
        this.client.stopAsync().awaitTerminated();
        this.dpwsFramework.stopAsync().awaitTerminated();
        this.executorService.shutdown();
        this.executorService.awaitTermination(this.defaultMaxWait.toSeconds(), TimeUnit.SECONDS);
    }

    public void startInteraction(String remoteEprAddress) throws Exception {
        ListenableFuture future = this.client.connect(remoteEprAddress);
        HostingServiceProxy hostingServiceProxy = (HostingServiceProxy)future.get(this.defaultMaxWait.toSeconds(), TimeUnit.SECONDS);
        HostedServiceProxy hostedServiceProxy = (HostedServiceProxy)hostingServiceProxy.getHostedServices().get("TestService1");
        assert (hostedServiceProxy != null);
        ListenableFuture requestResponseFuture = this.executorService.submit((Runnable)new DoRequestResponse(hostedServiceProxy));
        ListenableFuture notificationFuture = this.executorService.submit((Runnable)new DoNotification(hostedServiceProxy));
        requestResponseFuture.get(this.defaultMaxWait.toSeconds(), TimeUnit.SECONDS);
        notificationFuture.get(this.defaultMaxWait.toSeconds() * 3L, TimeUnit.SECONDS);
    }

    private class DoNotification
    implements Runnable {
        private final HostedServiceProxy hostedServiceProxy;

        DoNotification(HostedServiceProxy hostedServiceProxy) {
            this.hostedServiceProxy = hostedServiceProxy;
        }

        @Override
        public void run() {
            try {
                NotificationSink interceptor = new NotificationSink();
                ListenableFuture subscribe = this.hostedServiceProxy.getEventSinkAccess().subscribe(Collections.singletonList("http://dpws-test-service/2017/05/10/TestPortType1/TestNotification"), Duration.ofMinutes(1L), (Interceptor)interceptor);
                SubscribeResult subscribeResult = (SubscribeResult)subscribe.get(DeviceAndClientPeer.this.defaultMaxWait.toSeconds(), TimeUnit.SECONDS);
                assert (interceptor.waitForMessages(3, DeviceAndClientPeer.this.defaultMaxWait));
                ListenableFuture unsubscribe = this.hostedServiceProxy.getEventSinkAccess().unsubscribe(subscribeResult.getSubscriptionId());
                unsubscribe.get(DeviceAndClientPeer.this.defaultMaxWait.toSeconds(), TimeUnit.SECONDS);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private class NotificationSink
        implements Interceptor {
            private TimedWait<List<TestNotification>> timedWait = new TimedWait(ArrayList::new);

            private NotificationSink() {
            }

            @MessageInterceptor(value="http://dpws-test-service/2017/05/10/TestPortType1/TestNotification")
            void onNotification(NotificationObject message) {
                TestNotification notification = (TestNotification)DeviceAndClientPeer.this.soapUtil.getBody(message.getNotification(), TestNotification.class).orElseThrow(() -> new RuntimeException("TestNotification could not be converted"));
                this.timedWait.modifyData(testNotifications -> testNotifications.add(notification));
            }

            boolean waitForMessages(int messageCount, Duration wait) {
                return this.timedWait.waitForData(testNotifications -> testNotifications.size() >= messageCount, wait);
            }
        }
    }

    private class DoRequestResponse
    implements Runnable {
        private final HostedServiceProxy hostedServiceProxy;

        DoRequestResponse(HostedServiceProxy hostedServiceProxy) {
            this.hostedServiceProxy = hostedServiceProxy;
        }

        @Override
        public void run() {
            try {
                SoapMessage request = DeviceAndClientPeer.this.soapUtil.createMessage("http://dpws-test-service/2017/05/10/TestPortType1/TestOperationRequest");
                TestOperationRequest requestBody = new TestOperationRequest();
                requestBody.setParam1("ThisIsSomeRandomContent");
                requestBody.setParam2(10);
                DeviceAndClientPeer.this.soapUtil.setBody((Object)requestBody, request);
                SoapMessage response = this.hostedServiceProxy.getRequestResponseClient().sendRequestResponse(request);
                DeviceAndClientPeer.this.soapUtil.getBody(response, TestOperationResponse.class).orElseThrow(() -> new RuntimeException("Response message body is invalid."));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

