/*
 * Decompiled with CFR 0.152.
 */
package it.org.somda.sdc.dpws.soap;

import com.google.inject.AbstractModule;
import it.org.somda.sdc.dpws.IntegrationTestPeer;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.UUID;
import javax.annotation.Nullable;
import org.somda.sdc.dpws.device.Device;
import org.somda.sdc.dpws.device.DeviceSettings;
import org.somda.sdc.dpws.device.factory.DeviceFactory;
import org.somda.sdc.dpws.guice.DefaultDpwsConfigModule;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;

public abstract class DevicePeer
extends IntegrationTestPeer {
    private String eprAddress;
    private Device device;
    private boolean isSetup = false;

    void setup(DefaultDpwsConfigModule configModule, @Nullable DeviceSettings deviceSettings, @Nullable AbstractModule overridingModule) {
        this.setupInjector(configModule, overridingModule);
        if (deviceSettings == null) {
            this.eprAddress = ((SoapUtil)this.getInjector().getInstance(SoapUtil.class)).createUriFromUuid(UUID.randomUUID());
            WsAddressingUtil wsaUtil = (WsAddressingUtil)this.getInjector().getInstance(WsAddressingUtil.class);
            final EndpointReferenceType epr = wsaUtil.createEprWithAddress(this.eprAddress);
            deviceSettings = new DeviceSettings(){

                public EndpointReferenceType getEndpointReference() {
                    return epr;
                }

                public NetworkInterface getNetworkInterface() {
                    try {
                        return NetworkInterface.getByInetAddress(InetAddress.getLoopbackAddress());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        } else {
            this.eprAddress = deviceSettings.getEndpointReference().getAddress().getValue();
        }
        this.device = ((DeviceFactory)this.getInjector().getInstance(DeviceFactory.class)).createDevice(deviceSettings);
        this.isSetup = true;
    }

    public String getEprAddress() {
        this.checkSetup();
        return this.eprAddress;
    }

    public Device getDevice() {
        this.checkSetup();
        return this.device;
    }

    private void checkSetup() {
        if (!this.isSetup) {
            throw new RuntimeException("Call setup() before access getter method");
        }
    }
}

