/*
 * Decompiled with CFR 0.152.
 */
package it.org.somda.sdc.dpws.soap;

import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import it.org.somda.sdc.dpws.IntegrationTestUtil;
import it.org.somda.sdc.dpws.MockedUdpBindingModule;
import it.org.somda.sdc.dpws.soap.BasicPopulatedDevice;
import it.org.somda.sdc.dpws.soap.ClientPeer;
import it.org.somda.sdc.dpws.soap.DevicePeer;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.somda.sdc.dpws.client.DiscoveredDevice;
import org.somda.sdc.dpws.client.DiscoveryFilterBuilder;
import org.somda.sdc.dpws.client.DiscoveryObserver;
import org.somda.sdc.dpws.client.event.DeviceEnteredMessage;
import org.somda.sdc.dpws.client.event.DeviceProbeTimeoutMessage;
import org.somda.sdc.dpws.client.event.ProbedDeviceFoundMessage;
import org.somda.sdc.dpws.guice.DefaultDpwsConfigModule;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ProbeMatchType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ProbeMatchesType;
import test.org.somda.common.LoggingTestWatcher;

@ExtendWith(value={LoggingTestWatcher.class})
class DiscoveryIT {
    private static final Duration MAX_WAIT_TIME = IntegrationTestUtil.MAX_WAIT_TIME;
    private DevicePeer devicePeer;
    private ClientPeer clientPeer;

    public DiscoveryIT() {
        IntegrationTestUtil.preferIpV4Usage();
    }

    @BeforeEach
    public void setUp() {
        this.devicePeer = new BasicPopulatedDevice(new MockedUdpBindingModule());
        this.clientPeer = new ClientPeer(new DefaultDpwsConfigModule(){

            public void customConfigure() {
                this.bind("WsDiscovery.MaxWaitForProbeMatches", Duration.class, Duration.ofSeconds(MAX_WAIT_TIME.getSeconds() / 2L));
                this.bind("SoapConfig.JaxbContextPath", String.class, "dpws_test_service.messages._2017._05._10");
            }
        }, new MockedUdpBindingModule());
    }

    @AfterEach
    public void tearDown() {
        this.devicePeer.stopAsync().awaitTerminated();
        this.clientPeer.stopAsync().awaitTerminated();
    }

    @Test
    void explicitDeviceDiscovery() throws Exception {
        this.devicePeer.startAsync().awaitRunning();
        this.clientPeer.startAsync().awaitRunning();
        SettableFuture actualDeviceFoundCount = SettableFuture.create();
        final SettableFuture actualEpr = SettableFuture.create();
        DiscoveryObserver obs = new DiscoveryObserver(){

            @Subscribe
            void deviceFound(ProbedDeviceFoundMessage message) {
                if (DiscoveryIT.this.devicePeer.getEprAddress().equals(((DiscoveredDevice)message.getPayload()).getEprAddress())) {
                    actualEpr.set((Object)((DiscoveredDevice)message.getPayload()).getEprAddress());
                }
            }

            @Subscribe
            void timeout(DeviceProbeTimeoutMessage message) {
            }
        };
        this.clientPeer.getClient().registerDiscoveryObserver(obs);
        DiscoveryFilterBuilder discoveryFilterBuilder = new DiscoveryFilterBuilder();
        this.clientPeer.getClient().probe(discoveryFilterBuilder.get());
        String expectedEprAddress = this.devicePeer.getEprAddress();
        Assertions.assertEquals((Object)expectedEprAddress, (Object)actualEpr.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS));
        Assertions.assertEquals((Object)expectedEprAddress, (Object)((DiscoveredDevice)this.clientPeer.getClient().resolve(this.devicePeer.getEprAddress()).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS)).getEprAddress());
    }

    @Test
    void implicitDeviceDiscovery() throws Exception {
        this.clientPeer.startAsync().awaitRunning();
        final SettableFuture actualEpr = SettableFuture.create();
        DiscoveryObserver obs = new DiscoveryObserver(){

            @Subscribe
            void deviceFound(DeviceEnteredMessage message) {
                if (DiscoveryIT.this.devicePeer.getEprAddress().equals(((DiscoveredDevice)message.getPayload()).getEprAddress())) {
                    actualEpr.set((Object)((DiscoveredDevice)message.getPayload()).getEprAddress());
                }
            }
        };
        this.clientPeer.getClient().registerDiscoveryObserver(obs);
        this.devicePeer.startAsync().awaitRunning();
        String expectedEprAddress = this.devicePeer.getEprAddress();
        Assertions.assertEquals((Object)expectedEprAddress, (Object)actualEpr.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS));
        Assertions.assertEquals((Object)expectedEprAddress, (Object)((DiscoveredDevice)this.clientPeer.getClient().resolve(this.devicePeer.getEprAddress()).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS)).getEprAddress());
    }

    @Test
    void directedProbe() throws Exception {
        this.devicePeer.startAsync().awaitRunning();
        this.clientPeer.startAsync().awaitRunning();
        DiscoveredDevice discoveredDevice = (DiscoveredDevice)this.clientPeer.getClient().resolve(this.devicePeer.getEprAddress()).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        List xAddrs = discoveredDevice.getXAddrs();
        Assertions.assertFalse((boolean)xAddrs.isEmpty());
        String uri = (String)xAddrs.get(0);
        String expectedEprAddress = this.devicePeer.getEprAddress();
        Assertions.assertEquals((Object)expectedEprAddress, (Object)((ProbeMatchType)((ProbeMatchesType)this.clientPeer.getClient().directedProbe(uri).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS)).getProbeMatch().get(0)).getEndpointReference().getAddress().getValue());
    }

    @Test
    void connectWithDiscoveredDevice() throws Exception {
        this.devicePeer.startAsync().awaitRunning();
        this.clientPeer.startAsync().awaitRunning();
        DiscoveredDevice discoveredDevice = (DiscoveredDevice)this.clientPeer.getClient().resolve(this.devicePeer.getEprAddress()).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        ListenableFuture hostingServiceProxyFuture = this.clientPeer.getClient().connect(discoveredDevice);
        String expectedEprAddress = this.devicePeer.getEprAddress();
        HostingServiceProxy hostingServiceProxy = (HostingServiceProxy)hostingServiceProxyFuture.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        String actualEprAddress = hostingServiceProxy.getEndpointReferenceAddress();
        Assertions.assertEquals((Object)expectedEprAddress, (Object)actualEprAddress);
    }

    @Test
    void connectWithEprAddress() throws Exception {
        this.devicePeer.startAsync().awaitRunning();
        this.clientPeer.startAsync().awaitRunning();
        ListenableFuture hostingServiceProxyFuture = this.clientPeer.getClient().connect(this.devicePeer.getEprAddress());
        String expectedEprAddress = this.devicePeer.getEprAddress();
        HostingServiceProxy hostingServiceProxy = (HostingServiceProxy)hostingServiceProxyFuture.get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        String actualEprAddress = hostingServiceProxy.getEndpointReferenceAddress();
        Assertions.assertEquals((Object)expectedEprAddress, (Object)actualEprAddress);
    }

    public void sample() throws Exception {
        this.devicePeer.startAsync().awaitRunning();
        Thread.sleep(100000000L);
    }
}

