/*
 * Decompiled with CFR 0.152.
 */
package it.org.somda.sdc.dpws.soap;

import com.google.inject.Inject;
import dpws_test_service.messages._2017._05._10.ObjectFactory;
import dpws_test_service.messages._2017._05._10.TestNotification;
import dpws_test_service.messages._2017._05._10.TestOperationRequest;
import dpws_test_service.messages._2017._05._10.TestOperationResponse;
import org.somda.sdc.dpws.device.WebService;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.exception.MarshallingException;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.exception.TransportException;
import org.somda.sdc.dpws.soap.factory.SoapFaultFactory;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.RequestResponseObject;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;
import org.somda.sdc.dpws.soap.wseventing.ActionBasedEventSource;
import org.somda.sdc.dpws.soap.wseventing.EventSourceDialectHandler;

public class DpwsTestService2
extends WebService {
    private final WsAddressingUtil wsaUtil;
    private final SoapUtil soapUtil;
    private final SoapFaultFactory soapFaultFactory;
    private final ObjectFactory objectFactory;
    private final ActionBasedEventSource actionBasedEventSource;

    @Inject
    DpwsTestService2(WsAddressingUtil wsaUtil, SoapUtil soapUtil, SoapFaultFactory soapFaultFactory, ObjectFactory objectFactory, ActionBasedEventSource actionBasedEventSource) {
        this.wsaUtil = wsaUtil;
        this.actionBasedEventSource = actionBasedEventSource;
        this.soapUtil = soapUtil;
        this.soapFaultFactory = soapFaultFactory;
        this.objectFactory = objectFactory;
        this.registerEventSource((EventSourceDialectHandler)actionBasedEventSource);
    }

    public void sendNotification(TestNotification notificationToSend) throws MarshallingException, TransportException {
        this.actionBasedEventSource.sendNotification("http://dpws-test-service/2017/05/10/TestPortType3/TestNotification", (Object)notificationToSend);
    }

    @MessageInterceptor(value="http://dpws-test-service/2017/05/10/TestPortType3/TestOperationRequest")
    void onTestOperation(RequestResponseObject rrObj) throws SoapFaultException {
        rrObj.getResponse().getWsAddressingHeader().setAction(this.wsaUtil.createAttributedURIType("http://dpws-test-service/2017/05/10/TestPortType3/TestOperationResponse"));
        TestOperationRequest req = (TestOperationRequest)this.soapUtil.getBody(rrObj.getRequest(), TestOperationRequest.class).orElseThrow(() -> new SoapFaultException(this.soapFaultFactory.createSenderFault("SOAP body is malformed."), (AttributedURIType)rrObj.getRequest().getWsAddressingHeader().getMessageId().orElse(null)));
        TestOperationResponse res = this.objectFactory.createTestOperationResponse();
        res.setResult1(new StringBuilder(req.getParam1()).append(req.getParam1()).reverse().toString());
        res.setResult2(req.getParam2() * 8);
        this.soapUtil.setBody((Object)res, rrObj.getResponse());
    }
}

