/*
 * Decompiled with CFR 0.152.
 */
package it.org.somda.sdc.dpws.soap;

import it.org.somda.sdc.dpws.IntegrationTestUtil;
import it.org.somda.sdc.dpws.MockedUdpBindingModule;
import it.org.somda.sdc.dpws.soap.BasicPopulatedDevice;
import it.org.somda.sdc.dpws.soap.ClientPeer;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBElement;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.somda.sdc.dpws.guice.DefaultDpwsConfigModule;
import org.somda.sdc.dpws.http.HttpException;
import org.somda.sdc.dpws.service.HostedServiceProxy;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.dpws.soap.SoapConstants;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.factory.SoapFaultFactory;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingConstants;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedQNameType;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;
import org.somda.sdc.dpws.soap.wsaddressing.model.ProblemActionType;
import org.somda.sdc.dpws.soap.wsaddressing.model.RelatesToType;
import test.org.somda.common.LoggingTestWatcher;

@ExtendWith(value={LoggingTestWatcher.class})
class FaultIT {
    private static final Duration MAX_WAIT_TIME = IntegrationTestUtil.MAX_WAIT_TIME;
    private final IntegrationTestUtil IT = new IntegrationTestUtil();
    private BasicPopulatedDevice devicePeer;
    private ClientPeer clientPeer;
    private HostingServiceProxy hostingServiceProxy;
    private final SoapUtil soapUtil = (SoapUtil)this.IT.getInjector().getInstance(SoapUtil.class);
    private final SoapFaultFactory soapFaultFactory = (SoapFaultFactory)this.IT.getInjector().getInstance(SoapFaultFactory.class);

    FaultIT() {
        IntegrationTestUtil.preferIpV4Usage();
    }

    @BeforeEach
    void setUp() throws Exception {
        this.devicePeer = new BasicPopulatedDevice(new MockedUdpBindingModule());
        this.clientPeer = new ClientPeer(new DefaultDpwsConfigModule(){

            public void customConfigure() {
                this.bind("SoapConfig.JaxbContextPath", String.class, "dpws_test_service.messages._2017._05._10");
            }
        }, new MockedUdpBindingModule());
        this.devicePeer.startAsync().awaitRunning();
        this.clientPeer.startAsync().awaitRunning();
        this.hostingServiceProxy = (HostingServiceProxy)this.clientPeer.getClient().connect(this.devicePeer.getEprAddress()).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
    }

    @AfterEach
    void tearDown() {
        this.devicePeer.stopAsync().awaitTerminated();
        this.clientPeer.stopAsync().awaitTerminated();
        this.devicePeer = null;
        this.clientPeer = null;
    }

    @Test
    void invalidActions() throws Exception {
        HostedServiceProxy srv1 = (HostedServiceProxy)this.hostingServiceProxy.getHostedServices().get("TestService1");
        Assertions.assertNotNull((Object)srv1);
        SoapMessage reqMsg = this.soapUtil.createMessage();
        try {
            srv1.sendRequestResponse(reqMsg);
            Assertions.fail((String)"Expected a SoapFaultException to be thrown in case of a missing action");
        }
        catch (SoapFaultException e) {
            Assertions.assertEquals((Object)SoapConstants.SENDER, (Object)e.getFault().getCode().getValue());
            Assertions.assertEquals((Object)WsAddressingConstants.MESSAGE_ADDRESSING_HEADER_REQUIRED, (Object)e.getFault().getCode().getSubcode().getValue());
            Assertions.assertEquals((int)1, (int)e.getFault().getDetail().getAny().size());
            JAXBElement detail = (JAXBElement)e.getFault().getDetail().getAny().get(0);
            Assertions.assertEquals((Object)WsAddressingConstants.QNAME_ACTION, (Object)((AttributedQNameType)detail.getValue()).getValue());
            Assertions.assertNotNull((Object)e.getCause());
            Assertions.assertTrue((boolean)(e.getCause() instanceof HttpException));
            Assertions.assertEquals((int)400, (int)((HttpException)e.getCause()).getStatusCode());
        }
        String expectedUnknownAction = "http://unknown-action";
        SoapMessage reqMsg2 = this.soapUtil.createMessage(expectedUnknownAction);
        try {
            srv1.sendRequestResponse(reqMsg2);
            Assertions.fail((String)"Expected a SoapFaultException to be thrown in case of an unknown action");
        }
        catch (SoapFaultException e) {
            Assertions.assertEquals((Object)SoapConstants.SENDER, (Object)e.getFault().getCode().getValue());
            Assertions.assertEquals((Object)WsAddressingConstants.ACTION_NOT_SUPPORTED, (Object)e.getFault().getCode().getSubcode().getValue());
            Assertions.assertEquals((int)1, (int)e.getFault().getDetail().getAny().size());
            JAXBElement detail = (JAXBElement)e.getFault().getDetail().getAny().get(0);
            Assertions.assertEquals((Object)expectedUnknownAction, (Object)((ProblemActionType)detail.getValue()).getAction().getValue());
            Assertions.assertNotNull((Object)e.getCause());
            Assertions.assertTrue((boolean)(e.getCause() instanceof HttpException));
            Assertions.assertEquals((int)400, (int)((HttpException)e.getCause()).getStatusCode());
        }
    }

    @Test
    void faultMessageContainsRelatesTo() throws Exception {
        HostedServiceProxy srv1 = (HostedServiceProxy)this.hostingServiceProxy.getHostedServices().get("TestService1");
        Assertions.assertNotNull((Object)srv1);
        SoapMessage reqMsg = this.soapUtil.createMessage();
        try {
            srv1.sendRequestResponse(reqMsg);
            Assertions.fail((String)"Expected a SoapFaultException to be thrown in case of a missing action");
        }
        catch (SoapFaultException e) {
            Optional relatesTo = e.getFaultMessage().getWsAddressingHeader().getRelatesTo();
            Assertions.assertTrue((boolean)relatesTo.isPresent());
            Assertions.assertEquals((Object)"http://www.w3.org/2005/08/addressing/unspecified", (Object)((RelatesToType)relatesTo.get()).getValue());
        }
        reqMsg = this.soapUtil.createMessage();
        AttributedURIType msgId = new AttributedURIType();
        msgId.setValue(this.soapUtil.createRandomUuidUri());
        reqMsg.getWsAddressingHeader().setMessageId(msgId);
        try {
            srv1.sendRequestResponse(reqMsg);
            Assertions.fail((String)"Expected a SoapFaultException to be thrown in case of a missing action");
        }
        catch (SoapFaultException e) {
            Optional relatesTo = e.getFaultMessage().getWsAddressingHeader().getRelatesTo();
            Assertions.assertTrue((boolean)relatesTo.isPresent());
            Assertions.assertEquals((Object)msgId.getValue(), (Object)((RelatesToType)relatesTo.get()).getValue());
        }
    }
}

