/*
 * Decompiled with CFR 0.152.
 */
package it.org.somda.sdc.dpws.soap;

import com.google.common.util.concurrent.ListenableFuture;
import it.org.somda.sdc.dpws.IntegrationTestUtil;
import it.org.somda.sdc.dpws.MockedUdpBindingModule;
import it.org.somda.sdc.dpws.soap.BasicPopulatedDevice;
import it.org.somda.sdc.dpws.soap.ClientPeer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.somda.sdc.dpws.guice.DefaultDpwsConfigModule;
import org.somda.sdc.dpws.service.HostedServiceProxy;
import org.somda.sdc.dpws.service.HostingServiceProxy;
import org.somda.sdc.dpws.soap.RequestResponseClient;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.interception.InterceptorException;
import org.somda.sdc.dpws.soap.wsmetadataexchange.GetMetadataClient;
import org.somda.sdc.dpws.soap.wsmetadataexchange.model.Metadata;
import org.somda.sdc.dpws.soap.wsmetadataexchange.model.MetadataSection;
import org.somda.sdc.dpws.wsdl.WsdlMarshalling;
import org.somda.sdc.dpws.wsdl.WsdlProvisioningMode;
import org.somda.sdc.dpws.wsdl.WsdlRetriever;
import org.somda.sdc.dpws.wsdl.model.TDefinitions;
import test.org.somda.common.LoggingTestWatcher;

@ExtendWith(value={LoggingTestWatcher.class})
class WsdlRetrievalIT {
    private static final Duration MAX_WAIT_TIME = IntegrationTestUtil.MAX_WAIT_TIME;
    private final IntegrationTestUtil IT = new IntegrationTestUtil();
    private BasicPopulatedDevice devicePeer;
    private ClientPeer clientPeer;
    private HostingServiceProxy hostingServiceProxy;
    private final SoapUtil soapUtil = (SoapUtil)this.IT.getInjector().getInstance(SoapUtil.class);

    WsdlRetrievalIT() {
        IntegrationTestUtil.preferIpV4Usage();
    }

    @AfterEach
    void tearDown() {
        this.devicePeer.stopAsync().awaitTerminated();
        this.clientPeer.stopAsync().awaitTerminated();
        this.devicePeer = null;
        this.clientPeer = null;
    }

    @Test
    void getWsdlAsResource() throws Exception {
        MetadataSection metadataSection = this.setUpWithProvisioningMode(WsdlProvisioningMode.RESOURCE);
        Assertions.assertNull((Object)metadataSection.getAny());
        Assertions.assertNotNull((Object)metadataSection.getLocation());
        WsdlRetriever retriever = (WsdlRetriever)this.clientPeer.getInjector().getInstance(WsdlRetriever.class);
        Map wsdlMap = retriever.retrieveWsdls(this.hostingServiceProxy);
        Assertions.assertFalse((boolean)wsdlMap.isEmpty());
        Assertions.assertEquals((long)2L, (long)wsdlMap.values().stream().mapToLong(Collection::size).sum());
        WsdlMarshalling wsdlMarshaller = (WsdlMarshalling)this.clientPeer.getInjector().getInstance(WsdlMarshalling.class);
        for (List wsdlList : wsdlMap.values()) {
            for (String wsdl : wsdlList) {
                TDefinitions tdef = wsdlMarshaller.unmarshal((InputStream)new ByteArrayInputStream(wsdl.getBytes(StandardCharsets.UTF_8)));
                Assertions.assertNotNull((Object)tdef);
            }
        }
    }

    @Test
    void getWsdlAsInlineDefinition() throws Exception {
        MetadataSection metadataSection = this.setUpWithProvisioningMode(WsdlProvisioningMode.INLINE);
        Assertions.assertNotNull((Object)metadataSection.getAny());
        Assertions.assertNull((Object)metadataSection.getLocation());
        WsdlRetriever retriever = (WsdlRetriever)this.clientPeer.getInjector().getInstance(WsdlRetriever.class);
        Map wsdlMap = retriever.retrieveWsdls(this.hostingServiceProxy);
        Assertions.assertFalse((boolean)wsdlMap.isEmpty());
        Assertions.assertEquals((long)2L, (long)wsdlMap.values().stream().mapToLong(Collection::size).sum());
        WsdlMarshalling wsdlMarshaller = (WsdlMarshalling)this.clientPeer.getInjector().getInstance(WsdlMarshalling.class);
        for (List wsdlList : wsdlMap.values()) {
            for (String wsdl : wsdlList) {
                TDefinitions tdef = wsdlMarshaller.unmarshal((InputStream)new ByteArrayInputStream(wsdl.getBytes(StandardCharsets.UTF_8)));
                Assertions.assertNotNull((Object)tdef);
            }
        }
    }

    private MetadataSection setUpWithProvisioningMode(final WsdlProvisioningMode provisioningMode) throws InterceptorException, InterruptedException, ExecutionException, TimeoutException {
        this.devicePeer = new BasicPopulatedDevice(null, new DefaultDpwsConfigModule(){

            public void customConfigure() {
                this.bind("Dpws.WsdlProvisioningMode", WsdlProvisioningMode.class, provisioningMode);
            }
        }, new MockedUdpBindingModule());
        this.clientPeer = new ClientPeer(new DefaultDpwsConfigModule(){

            public void customConfigure() {
                this.bind("SoapConfig.JaxbContextPath", String.class, "dpws_test_service.messages._2017._05._10");
            }
        }, new MockedUdpBindingModule());
        this.devicePeer.startAsync().awaitRunning();
        this.clientPeer.startAsync().awaitRunning();
        this.hostingServiceProxy = (HostingServiceProxy)this.clientPeer.getClient().connect(this.devicePeer.getEprAddress()).get(MAX_WAIT_TIME.getSeconds(), TimeUnit.SECONDS);
        HostedServiceProxy hostedServiceProxy = (HostedServiceProxy)this.hostingServiceProxy.getHostedServices().values().iterator().next();
        GetMetadataClient getMetadataClient = (GetMetadataClient)this.devicePeer.getInjector().getInstance(GetMetadataClient.class);
        ListenableFuture metadataFuture = getMetadataClient.sendGetMetadata((RequestResponseClient)hostedServiceProxy);
        SoapMessage soapMessage = (SoapMessage)metadataFuture.get(MAX_WAIT_TIME.toSeconds(), TimeUnit.SECONDS);
        Optional metadata = this.soapUtil.getBody(soapMessage, Metadata.class);
        Assertions.assertTrue((boolean)metadata.isPresent());
        List sections = ((Metadata)metadata.get()).getMetadataSection().stream().filter(metadataSection -> "http://schemas.xmlsoap.org/wsdl/".equals(metadataSection.getDialect())).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)sections.size());
        return (MetadataSection)sections.get(0);
    }
}

