/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.extension.ExtendWith;
import org.somda.sdc.common.guice.DefaultCommonConfigModule;
import org.somda.sdc.common.guice.DefaultCommonModule;
import org.somda.sdc.dpws.guice.DefaultDpwsConfigModule;
import org.somda.sdc.dpws.guice.DefaultDpwsModule;
import test.org.somda.common.CIDetector;
import test.org.somda.common.LoggingTestWatcher;

@ExtendWith(value={LoggingTestWatcher.class})
public abstract class DpwsTest {
    private static final Logger LOG = LogManager.getLogger(DpwsTest.class);
    private Injector injector;
    private List<AbstractModule> overridingModules;

    protected void overrideBindings(AbstractModule module) {
        this.overrideBindings(List.of(module));
    }

    protected void overrideBindings(List<AbstractModule> module) {
        this.overridingModules = module;
    }

    protected void setUp() throws Exception {
        this.injector = DpwsTest.configureInjector(Optional.ofNullable(this.overridingModules).orElse(Collections.emptyList()));
    }

    protected static Injector configureInjector(List<AbstractModule> overridingModules) {
        DefaultDpwsConfigModule dpwsConfigOverride = new DefaultDpwsConfigModule(){

            protected void customConfigure() {
                super.customConfigure();
                if (CIDetector.isRunningInCi()) {
                    Duration httpTimeouts = Duration.ofSeconds(120L);
                    Duration futureTimeouts = Duration.ofSeconds(30L);
                    LOG.info("CI detected, setting relaxed HTTP client timeouts of {}s", (Object)httpTimeouts.toSeconds());
                    this.bind("Dpws.HttpClientConnectTimeout", Duration.class, httpTimeouts);
                    this.bind("Dpws.HttpClientReadTimeout", Duration.class, httpTimeouts);
                    List<String> increasedTimeouts = List.of("Dpws.MaxWaitForFutures", "WsDiscovery.MaxWaitForProbeMatches", "WsDiscovery.MaxWaitForResolveMatches");
                    increasedTimeouts.forEach(item -> {
                        LOG.info("CI detected, setting {} to {}s", item, (Object)futureTimeouts.toSeconds());
                        this.bind((String)item, Duration.class, futureTimeouts);
                    });
                }
            }
        };
        Injector injector = !overridingModules.isEmpty() ? Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new DefaultCommonConfigModule(), new DefaultDpwsModule(), new DefaultCommonModule(), dpwsConfigOverride}).with(overridingModules)}) : Guice.createInjector((Module[])new Module[]{new DefaultCommonConfigModule(), new DefaultDpwsModule(), new DefaultCommonModule(), dpwsConfigOverride});
        return injector;
    }

    protected Injector getInjector() {
        return this.injector;
    }
}

