/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.client.helper;

import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.somda.sdc.common.util.ExecutorWrapperService;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.client.DiscoveredDevice;
import org.somda.sdc.dpws.client.DiscoveryObserver;
import org.somda.sdc.dpws.client.event.DeviceEnteredMessage;
import org.somda.sdc.dpws.client.event.DeviceLeftMessage;
import org.somda.sdc.dpws.client.event.DeviceProbeTimeoutMessage;
import org.somda.sdc.dpws.client.event.ProbedDeviceFoundMessage;
import org.somda.sdc.dpws.client.helper.DiscoveredDeviceResolver;
import org.somda.sdc.dpws.client.helper.HelloByeAndProbeMatchesObserverImpl;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wsdiscovery.event.ByeMessage;
import org.somda.sdc.dpws.soap.wsdiscovery.event.HelloMessage;
import org.somda.sdc.dpws.soap.wsdiscovery.event.ProbeMatchesMessage;
import org.somda.sdc.dpws.soap.wsdiscovery.event.ProbeTimeoutMessage;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ByeType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.HelloType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ObjectFactory;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ProbeMatchType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ProbeMatchesType;

class DiscoveredDeviceObserverTest
extends DpwsTest {
    private DiscoveredDeviceResolver discoveredDeviceResolver;
    private String expectedUri;
    private EndpointReferenceType expectedEpr;
    private HelloByeAndProbeMatchesObserverImpl helloByeAndProbeMatchesObserverImpl;
    private ObjectFactory objFactory;
    private int callbackVisitCount;

    DiscoveredDeviceObserverTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        WsAddressingUtil wsaUtil = (WsAddressingUtil)this.getInjector().getInstance(WsAddressingUtil.class);
        ExecutorWrapperService execService = new ExecutorWrapperService(MoreExecutors::newDirectExecutorService, "execService", "abcd");
        execService.startAsync().awaitRunning();
        this.discoveredDeviceResolver = (DiscoveredDeviceResolver)Mockito.mock(DiscoveredDeviceResolver.class);
        this.expectedUri = "http://expectedUri";
        this.expectedEpr = wsaUtil.createEprWithAddress(this.expectedUri);
        this.helloByeAndProbeMatchesObserverImpl = new HelloByeAndProbeMatchesObserverImpl(this.discoveredDeviceResolver, execService, wsaUtil, "abcd");
        this.objFactory = new ObjectFactory();
        this.callbackVisitCount = 0;
    }

    @Test
    void publishDeviceLeft() {
        this.helloByeAndProbeMatchesObserverImpl.registerDiscoveryObserver(new DiscoveryObserver(){

            @Subscribe
            void onDeviceLeft(DeviceLeftMessage deviceLeftMessage) {
                Assertions.assertEquals((Object)DiscoveredDeviceObserverTest.this.expectedUri, (Object)deviceLeftMessage.getPayload());
                ++DiscoveredDeviceObserverTest.this.callbackVisitCount;
            }
        });
        this.helloByeAndProbeMatchesObserverImpl.publishDeviceLeft(this.expectedUri);
        Assertions.assertEquals((int)1, (int)this.callbackVisitCount);
    }

    @Test
    void onHello() {
        HelloType hType = this.objFactory.createHelloType();
        hType.setEndpointReference(this.expectedEpr);
        HelloMessage hMsg = new HelloMessage(hType);
        Mockito.when((Object)this.discoveredDeviceResolver.resolve(hMsg)).thenReturn(Optional.of(new DiscoveredDevice(this.expectedUri, new ArrayList(), new ArrayList(), new ArrayList(), 1L)));
        this.helloByeAndProbeMatchesObserverImpl.registerDiscoveryObserver(new DiscoveryObserver(){

            @Subscribe
            void onDeviceEntered(DeviceEnteredMessage deviceEntered) {
                Assertions.assertEquals((Object)DiscoveredDeviceObserverTest.this.expectedUri, (Object)((DiscoveredDevice)deviceEntered.getPayload()).getEprAddress());
                ++DiscoveredDeviceObserverTest.this.callbackVisitCount;
            }
        });
        this.helloByeAndProbeMatchesObserverImpl.onHello(hMsg);
        Assertions.assertEquals((int)1, (int)this.callbackVisitCount);
    }

    @Test
    void onBye() {
        ByeType bType = this.objFactory.createByeType();
        bType.setEndpointReference(this.expectedEpr);
        ByeMessage bMsg = new ByeMessage(bType);
        this.helloByeAndProbeMatchesObserverImpl.registerDiscoveryObserver(new DiscoveryObserver(){

            @Subscribe
            void onDeviceLeft(DeviceLeftMessage deviceLeftMessage) {
                Assertions.assertEquals((Object)DiscoveredDeviceObserverTest.this.expectedUri, (Object)deviceLeftMessage.getPayload());
                ++DiscoveredDeviceObserverTest.this.callbackVisitCount;
            }
        });
        this.helloByeAndProbeMatchesObserverImpl.onBye(bMsg);
        Assertions.assertEquals((int)1, (int)this.callbackVisitCount);
    }

    @Test
    void onProbeMatches() {
        ProbeMatchType pmType = this.objFactory.createProbeMatchType();
        pmType.setEndpointReference(this.expectedEpr);
        ProbeMatchesType pmsType = this.objFactory.createProbeMatchesType();
        pmsType.setProbeMatch(Collections.singletonList(pmType));
        final String expectedId = "expectedId";
        ProbeMatchesMessage pmMsg = new ProbeMatchesMessage(expectedId, pmsType);
        Mockito.when((Object)this.discoveredDeviceResolver.resolve(pmMsg)).thenReturn(Optional.of(new DiscoveredDevice(this.expectedUri, new ArrayList(), new ArrayList(), new ArrayList(), 1L)));
        this.helloByeAndProbeMatchesObserverImpl.registerDiscoveryObserver(new DiscoveryObserver(){

            @Subscribe
            void onProbedDevice(ProbedDeviceFoundMessage probedDeviceFound) {
                Assertions.assertEquals((Object)expectedId, (Object)probedDeviceFound.getDiscoveryId());
                Assertions.assertEquals((Object)DiscoveredDeviceObserverTest.this.expectedUri, (Object)((DiscoveredDevice)probedDeviceFound.getPayload()).getEprAddress());
                ++DiscoveredDeviceObserverTest.this.callbackVisitCount;
            }
        });
        this.helloByeAndProbeMatchesObserverImpl.onProbeMatches(pmMsg);
        Assertions.assertEquals((int)1, (int)this.callbackVisitCount);
    }

    @Test
    void onProbeTimeout() {
        final Integer expectedDevicesCount = 10;
        final String expectedId = "expectedId";
        ProbeTimeoutMessage ptMsg = new ProbeTimeoutMessage(expectedDevicesCount, expectedId);
        this.helloByeAndProbeMatchesObserverImpl.registerDiscoveryObserver(new DiscoveryObserver(){

            @Subscribe
            void onTimeout(DeviceProbeTimeoutMessage deviceProbeTimeout) {
                Assertions.assertEquals((Integer)expectedDevicesCount, (Integer)deviceProbeTimeout.getFoundDevicesCount());
                Assertions.assertEquals((Object)expectedId, (Object)deviceProbeTimeout.getDiscoveryId());
                ++DiscoveredDeviceObserverTest.this.callbackVisitCount;
            }
        });
        this.helloByeAndProbeMatchesObserverImpl.onProbeTimeout(ptMsg);
        Assertions.assertEquals((int)1, (int)this.callbackVisitCount);
    }
}

