/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.client.helper;

import com.google.common.util.concurrent.Futures;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.client.DiscoveredDevice;
import org.somda.sdc.dpws.client.helper.DiscoveredDeviceResolver;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.EndpointReferenceType;
import org.somda.sdc.dpws.soap.wsdiscovery.WsDiscoveryClient;
import org.somda.sdc.dpws.soap.wsdiscovery.event.HelloMessage;
import org.somda.sdc.dpws.soap.wsdiscovery.model.HelloType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ObjectFactory;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ResolveMatchType;
import org.somda.sdc.dpws.soap.wsdiscovery.model.ResolveMatchesType;

class DiscoveredDeviceResolverTest
extends DpwsTest {
    private WsAddressingUtil wsaUtil;
    private ObjectFactory objFactory;

    DiscoveredDeviceResolverTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.wsaUtil = (WsAddressingUtil)this.getInjector().getInstance(WsAddressingUtil.class);
        this.objFactory = new ObjectFactory();
    }

    @Test
    void resolve() throws Exception {
        String expectedUri = "http://expectedUri";
        List<String> xAddrsInHello = Arrays.asList("http://inHello1", "http://inHello2");
        EndpointReferenceType epr = this.wsaUtil.createEprWithAddress(expectedUri);
        HelloType hType = this.objFactory.createHelloType();
        HelloMessage hMsg = new HelloMessage(hType);
        hType.setEndpointReference(epr);
        hType.setXAddrs(xAddrsInHello);
        hType.setScopes(this.objFactory.createScopesType());
        ResolveMatchType resolveMatchType = this.objFactory.createResolveMatchType();
        resolveMatchType.setScopes(this.objFactory.createScopesType());
        List<String> xAddrsInResolveMatches = Arrays.asList("http://inResolveMatches1", "http://inResolveMatches2");
        resolveMatchType.setEndpointReference(epr);
        resolveMatchType.setXAddrs(xAddrsInResolveMatches);
        ResolveMatchesType rmType = this.objFactory.createResolveMatchesType();
        rmType.setResolveMatch(resolveMatchType);
        WsDiscoveryClient wsdClient = (WsDiscoveryClient)Mockito.mock(WsDiscoveryClient.class);
        Mockito.when((Object)wsdClient.sendResolve(epr)).thenReturn((Object)Futures.immediateFuture((Object)rmType));
        DiscoveredDeviceResolver dpr = new DiscoveredDeviceResolver(wsdClient, Duration.ofSeconds(1L), Boolean.valueOf(true), this.wsaUtil, "abcd");
        Optional actualWithResolveMatches = dpr.resolve(hMsg);
        Assertions.assertTrue((boolean)actualWithResolveMatches.isPresent());
        Assertions.assertEquals((Object)expectedUri, (Object)((DiscoveredDevice)actualWithResolveMatches.get()).getEprAddress());
        Assertions.assertEquals(xAddrsInHello, (Object)((DiscoveredDevice)actualWithResolveMatches.get()).getXAddrs());
        hType.setXAddrs(new ArrayList());
        Optional actualWithoutResolveMatches = dpr.resolve(hMsg);
        Assertions.assertTrue((boolean)actualWithoutResolveMatches.isPresent());
        Assertions.assertEquals((Object)expectedUri, (Object)((DiscoveredDevice)actualWithoutResolveMatches.get()).getEprAddress());
        Assertions.assertEquals(xAddrsInResolveMatches, (Object)((DiscoveredDevice)actualWithoutResolveMatches.get()).getXAddrs());
    }
}

