/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.http;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.somda.sdc.dpws.http.ContentType;

public class ContentTypeTest {
    @Test
    void testFromListMultimap() {
        ArrayListMultimap data = ArrayListMultimap.create();
        String contentType = "Content-Type".toLowerCase();
        data.put((Object)contentType, (Object)"text/xml");
        Optional contentOpt = ContentType.fromListMultimap((ListMultimap)data);
        Assertions.assertTrue((boolean)contentOpt.isPresent());
        ContentType content = (ContentType)contentOpt.get();
        Assertions.assertEquals((Object)ContentType.ContentTypes.TEXT_XML, (Object)content.getContentType());
        Assertions.assertEquals((Object)StandardCharsets.ISO_8859_1, (Object)content.getCharset());
        data.clear();
        String boundary = "stuff";
        data.put((Object)contentType, (Object)("text/xml; charset=us-ascii; boundary=" + boundary));
        Optional contentOpt2 = ContentType.fromListMultimap((ListMultimap)data);
        Assertions.assertTrue((boolean)contentOpt2.isPresent());
        ContentType content2 = (ContentType)contentOpt2.get();
        Assertions.assertEquals((Object)ContentType.ContentTypes.TEXT_XML, (Object)content2.getContentType());
        Assertions.assertEquals((Object)StandardCharsets.US_ASCII, (Object)content2.getCharset());
        Assertions.assertEquals((Object)boundary, (Object)content2.getBoundary());
    }

    @Test
    void testFromApache() {
        BasicHeader header = new BasicHeader("Content-Type", "text/xml");
        Optional contentOpt = ContentType.fromApache((Header)header);
        Assertions.assertTrue((boolean)contentOpt.isPresent());
        ContentType content = (ContentType)contentOpt.get();
        Assertions.assertEquals((Object)ContentType.ContentTypes.TEXT_XML, (Object)content.getContentType());
        Assertions.assertEquals((Object)StandardCharsets.ISO_8859_1, (Object)content.getCharset());
        String boundary = "stuff";
        BasicHeader header2 = new BasicHeader("Content-Type", "text/xml; charset=us-ascii; boundary=" + boundary);
        Optional contentOpt2 = ContentType.fromApache((Header)header2);
        Assertions.assertTrue((boolean)contentOpt2.isPresent());
        ContentType content2 = (ContentType)contentOpt2.get();
        Assertions.assertEquals((Object)ContentType.ContentTypes.TEXT_XML, (Object)content2.getContentType());
        Assertions.assertEquals((Object)StandardCharsets.US_ASCII, (Object)content2.getCharset());
        Assertions.assertEquals((Object)boundary, (Object)content2.getBoundary());
    }
}

