/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.http.apache;

import com.google.common.io.CharStreams;
import com.google.inject.Injector;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.JAXBException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.somda.sdc.dpws.CommunicationLogContext;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.TransportBindingException;
import org.somda.sdc.dpws.http.ContentType;
import org.somda.sdc.dpws.http.apache.ClientTransportBinding;
import org.somda.sdc.dpws.http.apache.ClientTransportBindingFactory;
import org.somda.sdc.dpws.soap.SoapMarshalling;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.SoapUtil;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.model.Envelope;

class ClientTransportBindingTest
extends DpwsTest {
    private ClientTransportBindingFactory fac;
    private Injector injector;
    private HttpClient mockHttpClient;
    private String clientUri;
    private SoapMarshalling mockMarshalling;
    private SoapUtil mockSoapUtil;
    private ClientTransportBinding binding;
    private CommunicationLogContext communicationLogContext;

    ClientTransportBindingTest() {
    }

    @Override
    @BeforeEach
    protected void setUp() throws Exception {
        super.setUp();
        this.injector = this.getInjector();
        this.fac = (ClientTransportBindingFactory)this.injector.getInstance(ClientTransportBindingFactory.class);
        this.mockHttpClient = (HttpClient)Mockito.mock(HttpClient.class);
        this.clientUri = "http://somewhere.over.the.rainb.ow";
        this.mockMarshalling = (SoapMarshalling)Mockito.mock(SoapMarshalling.class);
        this.mockSoapUtil = (SoapUtil)Mockito.mock(SoapUtil.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.communicationLogContext = new CommunicationLogContext("Whatever");
        this.binding = this.fac.create(this.mockHttpClient, this.clientUri, this.mockMarshalling, this.mockSoapUtil, this.communicationLogContext);
    }

    @Test
    @DisplayName(value="RequestResponseServerHttpHandler shall fail when content-type and is absent and content is non-empty")
    void testContentTypeMissingWithNonEmptyContent() throws JAXBException, IOException {
        SoapMessage mockSoapMessage = (SoapMessage)Mockito.mock(SoapMessage.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        String requestContent = "heya";
        Charset requestEncoding = StandardCharsets.UTF_8;
        ((SoapMarshalling)Mockito.doAnswer(invocation -> {
            OutputStream os = (OutputStream)invocation.getArgument(1, OutputStream.class);
            os.write(requestContent.getBytes(requestEncoding));
            return null;
        }).when((Object)this.mockMarshalling)).marshal((Envelope)ArgumentMatchers.any(), (OutputStream)ArgumentMatchers.any());
        HttpEntity mockEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)mockEntity.getContentType()).thenReturn(null);
        Mockito.when((Object)mockEntity.getContent()).thenReturn((Object)new ByteArrayInputStream(new byte[]{1, 2, 3}));
        HttpResponse mockResponse = (HttpResponse)Mockito.mock(HttpResponse.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockResponse.getEntity()).thenReturn((Object)mockEntity);
        Mockito.when((Object)this.mockHttpClient.execute((HttpUriRequest)ArgumentMatchers.any(), (HttpContext)ArgumentMatchers.any())).thenReturn((Object)mockResponse);
        TransportBindingException error = (TransportBindingException)Assertions.assertThrows(TransportBindingException.class, () -> this.binding.onRequestResponse(mockSoapMessage));
        Assertions.assertTrue((boolean)error.getMessage().contains("Could not parse content type from element"));
    }

    @Test
    @DisplayName(value="RequestResponseServerHttpHandler shall not fail when content-type is absent and content is empty")
    void testContentTypeMissingWithEmptyContent() throws JAXBException, IOException {
        SoapMessage mockSoapMessage = (SoapMessage)Mockito.mock(SoapMessage.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        String requestContent = "heya";
        Charset requestEncoding = StandardCharsets.UTF_8;
        ((SoapMarshalling)Mockito.doAnswer(invocation -> {
            OutputStream os = (OutputStream)invocation.getArgument(1, OutputStream.class);
            os.write(requestContent.getBytes(requestEncoding));
            return null;
        }).when((Object)this.mockMarshalling)).marshal((Envelope)ArgumentMatchers.any(), (OutputStream)ArgumentMatchers.any());
        HttpEntity mockEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)mockEntity.getContentType()).thenReturn(null);
        HttpResponse mockResponse = (HttpResponse)Mockito.mock(HttpResponse.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockResponse.getEntity()).thenReturn((Object)mockEntity);
        Mockito.when((Object)mockEntity.getContent()).thenReturn((Object)new ByteArrayInputStream(new byte[0]));
        Mockito.when((Object)this.mockHttpClient.execute((HttpUriRequest)ArgumentMatchers.any(), (HttpContext)ArgumentMatchers.any())).thenReturn((Object)mockResponse);
        Assertions.assertDoesNotThrow(() -> this.binding.onRequestResponse(mockSoapMessage));
    }

    @Test
    @DisplayName(value="RequestResponseServerHttpHandler shall handle implicit iso-8859-1 in text/xml")
    void testContentTypeTextXmlImplicitIso() throws JAXBException, IOException, SoapFaultException {
        SoapMessage mockSoapMessage = (SoapMessage)Mockito.mock(SoapMessage.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        String requestContent = "heya";
        Charset requestEncoding = StandardCharsets.UTF_8;
        String responseContent = "The quick brown fox jumps over the lazy dog \u00fd";
        ContentType.ContentTypes responseType = ContentType.ContentTypes.TEXT_XML;
        Charset responseEncoding = responseType.getDefaultEncoding();
        Assertions.assertNotNull((Object)responseEncoding);
        ((SoapMarshalling)Mockito.doAnswer(invocation -> {
            OutputStream os = (OutputStream)invocation.getArgument(1, OutputStream.class);
            os.write(requestContent.getBytes(requestEncoding));
            return null;
        }).when((Object)this.mockMarshalling)).marshal((Envelope)ArgumentMatchers.any(), (OutputStream)ArgumentMatchers.any());
        BasicHeader header = new BasicHeader("Content-Type", responseType.getContentType());
        HttpEntity mockEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)mockEntity.getContentType()).thenReturn((Object)header);
        Mockito.when((Object)mockEntity.getContent()).thenReturn((Object)new ByteArrayInputStream(responseContent.getBytes(responseEncoding)));
        HttpResponse mockResponse = (HttpResponse)Mockito.mock(HttpResponse.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockResponse.getEntity()).thenReturn((Object)mockEntity);
        Mockito.when((Object)this.mockHttpClient.execute((HttpUriRequest)ArgumentMatchers.any(), (HttpContext)ArgumentMatchers.any())).thenReturn((Object)mockResponse);
        SoapMessage response = this.binding.onRequestResponse(mockSoapMessage);
        ArgumentCaptor readerCaptor = ArgumentCaptor.forClass(Reader.class);
        ((SoapMarshalling)Mockito.verify((Object)this.mockMarshalling, (VerificationMode)Mockito.times((int)1))).unmarshal((Reader)readerCaptor.capture());
        Reader reader = (Reader)readerCaptor.getValue();
        String actualResponseContent = CharStreams.toString((Readable)reader);
        Assertions.assertEquals((Object)responseContent, (Object)actualResponseContent);
    }

    @Test
    @DisplayName(value="RequestResponseServerHttpHandler shall handle explicit utf-16be in text/xml")
    void testContentTypeTextXmlExplicitUtf16() throws JAXBException, IOException, SoapFaultException {
        SoapMessage mockSoapMessage = (SoapMessage)Mockito.mock(SoapMessage.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        String requestContent = "heya";
        Charset requestEncoding = StandardCharsets.UTF_8;
        String responseContent = "The quick brown fox jumps over the lazy dog \u00fd \u2602";
        ContentType.ContentTypes responseType = ContentType.ContentTypes.TEXT_XML;
        Charset responseEncoding = StandardCharsets.UTF_16BE;
        Assertions.assertNotNull((Object)responseEncoding);
        ((SoapMarshalling)Mockito.doAnswer(invocation -> {
            OutputStream os = (OutputStream)invocation.getArgument(1, OutputStream.class);
            os.write(requestContent.getBytes(requestEncoding));
            return null;
        }).when((Object)this.mockMarshalling)).marshal((Envelope)ArgumentMatchers.any(), (OutputStream)ArgumentMatchers.any());
        BasicHeader header = new BasicHeader("Content-Type", responseType.getContentType() + "; charset=" + responseEncoding.displayName());
        HttpEntity mockEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)mockEntity.getContentType()).thenReturn((Object)header);
        Mockito.when((Object)mockEntity.getContent()).thenReturn((Object)new ByteArrayInputStream(responseContent.getBytes(responseEncoding)));
        HttpResponse mockResponse = (HttpResponse)Mockito.mock(HttpResponse.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockResponse.getEntity()).thenReturn((Object)mockEntity);
        Mockito.when((Object)this.mockHttpClient.execute((HttpUriRequest)ArgumentMatchers.any(), (HttpContext)ArgumentMatchers.any())).thenReturn((Object)mockResponse);
        SoapMessage response = this.binding.onRequestResponse(mockSoapMessage);
        ArgumentCaptor readerCaptor = ArgumentCaptor.forClass(Reader.class);
        ((SoapMarshalling)Mockito.verify((Object)this.mockMarshalling, (VerificationMode)Mockito.times((int)1))).unmarshal((Reader)readerCaptor.capture());
        Reader reader = (Reader)readerCaptor.getValue();
        String actualResponseContent = CharStreams.toString((Readable)reader);
        Assertions.assertEquals((Object)responseContent, (Object)actualResponseContent);
    }

    @Test
    @DisplayName(value="RequestResponseServerHttpHandler shall let jaxb handle application/xml without charset")
    void testContentTypeApplicationXml() throws JAXBException, IOException, SoapFaultException {
        SoapMessage mockSoapMessage = (SoapMessage)Mockito.mock(SoapMessage.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        String requestContent = "heya";
        Charset requestEncoding = StandardCharsets.UTF_8;
        String responseContent = "The quick brown fox jumps over the lazy dog \u00fd \u2602";
        ContentType.ContentTypes responseType = ContentType.ContentTypes.APPLICATION_XML;
        Charset responseEncoding = StandardCharsets.UTF_8;
        Assertions.assertNotNull((Object)responseEncoding);
        ((SoapMarshalling)Mockito.doAnswer(invocation -> {
            OutputStream os = (OutputStream)invocation.getArgument(1, OutputStream.class);
            os.write(requestContent.getBytes(requestEncoding));
            return null;
        }).when((Object)this.mockMarshalling)).marshal((Envelope)ArgumentMatchers.any(), (OutputStream)ArgumentMatchers.any());
        BasicHeader header = new BasicHeader("Content-Type", responseType.getContentType());
        HttpEntity mockEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)mockEntity.getContentType()).thenReturn((Object)header);
        Mockito.when((Object)mockEntity.getContent()).thenReturn((Object)new ByteArrayInputStream(responseContent.getBytes(responseEncoding)));
        HttpResponse mockResponse = (HttpResponse)Mockito.mock(HttpResponse.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)mockResponse.getEntity()).thenReturn((Object)mockEntity);
        Mockito.when((Object)this.mockHttpClient.execute((HttpUriRequest)ArgumentMatchers.any(), (HttpContext)ArgumentMatchers.any())).thenReturn((Object)mockResponse);
        SoapMessage response = this.binding.onRequestResponse(mockSoapMessage);
        ArgumentCaptor readerCaptor = ArgumentCaptor.forClass(Reader.class);
        ArgumentCaptor streamCaptor = ArgumentCaptor.forClass(InputStream.class);
        ((SoapMarshalling)Mockito.verify((Object)this.mockMarshalling, (VerificationMode)Mockito.times((int)0))).unmarshal((Reader)readerCaptor.capture());
        ((SoapMarshalling)Mockito.verify((Object)this.mockMarshalling, (VerificationMode)Mockito.times((int)1))).unmarshal((InputStream)streamCaptor.capture());
        InputStream inputStream = (InputStream)streamCaptor.getValue();
        String actualResponseContent = new String(inputStream.readAllBytes(), responseEncoding);
        Assertions.assertEquals((Object)responseContent, (Object)actualResponseContent);
    }
}

