/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.interception;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.InterceptorInfo;
import org.somda.sdc.dpws.soap.interception.InterceptorRegistry;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.RequestResponseObject;

class InterceptorRegistryTest
extends DpwsTest {
    InterceptorRegistryTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
    }

    @Test
    void testAddInterceptor() {
        String action = "http://action";
        InterceptorRegistry registry = (InterceptorRegistry)this.getInjector().getInstance(InterceptorRegistry.class);
        registry.addInterceptor(new Interceptor(){

            @MessageInterceptor
            void test(RequestResponseObject rrInfo) {
            }
        });
        registry.addInterceptor(new Interceptor(){

            @MessageInterceptor(sequenceNumber=5)
            void test(RequestResponseObject rrInfo) {
            }
        });
        registry.addInterceptor(new Interceptor(){

            @MessageInterceptor(value="http://action")
            void test(RequestResponseObject rrInfo) {
            }
        });
        List defaultInterceptors = registry.getDefaultInterceptors();
        Assertions.assertEquals((int)2, (int)defaultInterceptors.size());
        Assertions.assertEquals((int)5, (int)((InterceptorInfo)defaultInterceptors.get(0)).getSequenceNumber());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)((InterceptorInfo)defaultInterceptors.get(1)).getSequenceNumber());
        List interceptors = registry.getInterceptors("http://action");
        Assertions.assertEquals((int)1, (int)interceptors.size());
    }
}

