/*
 * Decompiled with CFR 0.152.
 */
package org.somda.sdc.dpws.soap.wsaddressing;

import java.io.InputStream;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.somda.sdc.dpws.CommunicationLogContext;
import org.somda.sdc.dpws.DpwsTest;
import org.somda.sdc.dpws.helper.JaxbMarshalling;
import org.somda.sdc.dpws.soap.ApplicationInfo;
import org.somda.sdc.dpws.soap.CommunicationContext;
import org.somda.sdc.dpws.soap.RequestResponseServer;
import org.somda.sdc.dpws.soap.SoapMarshalling;
import org.somda.sdc.dpws.soap.SoapMessage;
import org.somda.sdc.dpws.soap.TransportInfo;
import org.somda.sdc.dpws.soap.exception.SoapFaultException;
import org.somda.sdc.dpws.soap.factory.SoapMessageFactory;
import org.somda.sdc.dpws.soap.interception.Direction;
import org.somda.sdc.dpws.soap.interception.Interceptor;
import org.somda.sdc.dpws.soap.interception.MessageInterceptor;
import org.somda.sdc.dpws.soap.interception.RequestResponseObject;
import org.somda.sdc.dpws.soap.model.Envelope;
import org.somda.sdc.dpws.soap.wsaddressing.WsAddressingUtil;
import org.somda.sdc.dpws.soap.wsaddressing.model.AttributedURIType;

class WsAddressingServerInterceptorTest
extends DpwsTest {
    private SoapMessage request;
    private SoapMessage response;
    private RequestResponseServer server;
    private CommunicationContext mockCommunicationContext;

    WsAddressingServerInterceptorTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.mockCommunicationContext = new CommunicationContext(new ApplicationInfo(), new TransportInfo("mock.scheme", "localhost", Integer.valueOf(123), "remotehost", Integer.valueOf(456), Collections.emptyList()), new CommunicationLogContext("txetnoCgoLnoitacinummoC"));
        InputStream soapStrm = this.getClass().getResourceAsStream("soap-envelope.xml");
        Assertions.assertNotNull((Object)soapStrm);
        ((JaxbMarshalling)this.getInjector().getInstance(JaxbMarshalling.class)).startAsync().awaitRunning();
        ((SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class)).startAsync().awaitRunning();
        Envelope soapEnv = ((SoapMarshalling)this.getInjector().getInstance(SoapMarshalling.class)).unmarshal(soapStrm);
        SoapMessageFactory soapMessageFactory = (SoapMessageFactory)this.getInjector().getInstance(SoapMessageFactory.class);
        this.request = soapMessageFactory.createSoapMessage(soapEnv);
        this.response = soapMessageFactory.createSoapMessage(new Envelope());
        AttributedURIType responseAction = ((WsAddressingUtil)this.getInjector().getInstance(WsAddressingUtil.class)).createAttributedURIType("http://response-action");
        this.response.getWsAddressingHeader().setAction(responseAction);
        this.server = (RequestResponseServer)this.getInjector().getInstance(RequestResponseServer.class);
        this.server.register(new Interceptor(){

            @MessageInterceptor(value="http://example.com/fabrikam/mail/Delete", direction=Direction.REQUEST)
            void dummyProcess(RequestResponseObject rrInfo) {
            }
        });
    }

    @Test
    void testMessageIdDuplicationDetection() {
        Assertions.assertDoesNotThrow(() -> this.server.receiveRequestResponse(this.request, this.response, this.mockCommunicationContext));
        Assertions.assertThrows(SoapFaultException.class, () -> this.server.receiveRequestResponse(this.request, this.response, this.mockCommunicationContext));
    }
}

